/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.OracleLog;

class AQMessagePropertiesI
implements AQMessageProperties {
    private int attrAttempts;
    private String attrCorrelation;
    private int attrDelay;
    private Timestamp attrEnqTime;
    private String attrExceptionQueue;
    private int attrExpiration;
    private AQMessageProperties.MessageState attrMsgState;
    private int attrPriority;
    private AQAgentI[] attrRecipientList;
    private AQAgentI attrSenderId;
    private String attrTransactionGroup;
    private byte[] attrPreviousQueueMsgId;
    private AQMessageProperties.DeliveryMode deliveryMode;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQMessagePropertiesI() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrAttempts = -1;
            this.attrCorrelation = null;
            this.attrDelay = 0;
            this.attrEnqTime = null;
            this.attrExceptionQueue = null;
            this.attrExpiration = -1;
            this.attrMsgState = null;
            this.attrPriority = 0;
            this.attrRecipientList = null;
            this.attrSenderId = null;
            this.attrTransactionGroup = null;
            this.attrPreviousQueueMsgId = null;
            this.deliveryMode = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDequeueAttemptsCount() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrAttempts);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.attrAttempts;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrelation(String correlation) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrCorrelation = correlation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorrelation() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrCorrelation);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.attrCorrelation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(int delay) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrDelay = delay;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDelay() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrDelay);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.attrDelay;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getEnqueueTime() {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrEnqTime);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = this.attrEnqTime;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionQueue(String exceptionQueue) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrExceptionQueue = exceptionQueue;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionQueue() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrExceptionQueue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.attrExceptionQueue;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(int seconds) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrExpiration = seconds;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpiration() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrExpiration);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.attrExpiration;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQMessageProperties.MessageState getState() {
        AQMessageProperties.MessageState messageState;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrMsgState));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            messageState = this.attrMsgState;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return messageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrPriority = priority;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrPriority);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.attrPriority;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipientList(AQAgent[] agents) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(agents));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrRecipientList = new AQAgentI[agents.length];
            for (int i2 = 0; i2 < agents.length; ++i2) {
                this.attrRecipientList[i2] = (AQAgentI)agents[i2];
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQAgent[] getRecipientList() {
        AQAgent[] aQAgentArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrRecipientList);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQAgentArray = this.attrRecipientList;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQAgentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSender(AQAgent sender) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sender));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrSenderId = (AQAgentI)sender;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQAgent getSender() {
        AQAgentI aQAgentI;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrSenderId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQAgentI = this.attrSenderId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQAgentI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactionGroup() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrTransactionGroup);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.attrTransactionGroup;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransactionGroup(String _txn) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_txn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrTransactionGroup = _txn;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPreviousQueueMessageId(byte[] msgId) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(msgId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrPreviousQueueMsgId = msgId;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPreviousQueueMessageId() {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrPreviousQueueMsgId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.attrPreviousQueueMsgId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQMessageProperties.DeliveryMode getDeliveryMode() {
        AQMessageProperties.DeliveryMode deliveryMode;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.deliveryMode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            deliveryMode = this.deliveryMode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return deliveryMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeliveryMode(AQMessageProperties.DeliveryMode _deliveryMode) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)_deliveryMode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.deliveryMode = _deliveryMode;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Correlation             : " + this.getCorrelation() + "\n");
            Timestamp enqTime = this.getEnqueueTime();
            if (enqTime != null) {
                sb.append("Enqueue time            : " + enqTime + "\n");
            }
            sb.append("Exception Queue         : " + this.getExceptionQueue() + "\n");
            sb.append("Sender                  : (" + this.getSender() + ")\n");
            int deqAttempts = this.getDequeueAttemptsCount();
            if (deqAttempts != -1) {
                sb.append("Attempts                : " + deqAttempts + "\n");
            }
            sb.append("Delay                   : " + this.getDelay() + "\n");
            sb.append("Expiration              : " + this.getExpiration() + "\n");
            AQMessageProperties.MessageState state = this.getState();
            if (state != null) {
                sb.append("State                   : " + (Object)((Object)state) + "\n");
            }
            sb.append("Priority                : " + this.getPriority() + "\n");
            AQMessageProperties.DeliveryMode dmode = this.getDeliveryMode();
            if (dmode != null) {
                sb.append("Delivery Mode           : " + (Object)((Object)dmode) + "\n");
            }
            sb.append("Recipient List          : {");
            AQAgent[] rec = this.getRecipientList();
            if (rec != null) {
                for (int i2 = 0; i2 < rec.length; ++i2) {
                    sb.append(rec[i2]);
                    if (i2 == rec.length - 1) continue;
                    sb.append("; ");
                }
            }
            sb.append("}");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessagePropertiesI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttempts(int _attrAttempts) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_attrAttempts));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrAttempts = _attrAttempts;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnqueueTime(Timestamp _attrEnqTime) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_attrEnqTime));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrEnqTime = _attrEnqTime;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMessageState(AQMessageProperties.MessageState _attrMsgState) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)_attrMsgState));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrMsgState = _attrMsgState;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessagePropertiesI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.AQMessageProperties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

