/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.transform;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;

class MembersNUplet {
    private final Object[] valueList_;
    private final DimensionLabels[] dlList_;

    public MembersNUplet(IMember[] fullMemberList, int pivotIndex, AnalysisAxis axis) {
        this.valueList_ = new Object[fullMemberList.length - 1];
        this.dlList_ = new DimensionLabels[fullMemberList.length - 1];
        int j = 0;
        for (int i = 0; i < fullMemberList.length; ++i) {
            if (i == pivotIndex) continue;
            this.valueList_[j] = fullMemberList[i].getArrayValueImpl();
            this.dlList_[j] = axis.getDimensionLabelsList()[fullMemberList[i].getDimensionIndex()];
            ++j;
        }
    }

    public MembersNUplet(IMember[] fullMemberList, Object value, DimensionLabels pivotDimension, AnalysisAxis axis) {
        this.valueList_ = new Object[fullMemberList.length + 1];
        this.dlList_ = new DimensionLabels[fullMemberList.length + 1];
        for (int i = 0; i < fullMemberList.length; ++i) {
            this.valueList_[i] = fullMemberList[i].getArrayValueImpl();
            this.dlList_[i] = axis.getDimensionLabelsList()[fullMemberList[i].getDimensionIndex()];
        }
        this.valueList_[fullMemberList.length] = value;
        this.dlList_[fullMemberList.length] = pivotDimension;
    }

    public MembersNUplet(Object value, DimensionLabels pivotDimension) {
        this.valueList_ = new Object[1];
        this.dlList_ = new DimensionLabels[1];
        this.valueList_[0] = value;
        this.dlList_[0] = pivotDimension;
    }

    public Object[] getValues() {
        return this.valueList_;
    }

    public DimensionLabels[] getDimensionLabels() {
        return this.dlList_;
    }

    public Object getValue(DimensionLabels dl) {
        for (int i = 0; i < this.dlList_.length; ++i) {
            if (!this.dlList_[i].equals(dl)) continue;
            return this.valueList_[i];
        }
        return null;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof MembersNUplet)) {
            return false;
        }
        MembersNUplet that = (MembersNUplet)oThat;
        if (this.valueList_.length != that.valueList_.length) {
            return false;
        }
        for (int i = 0; i < this.valueList_.length; ++i) {
            if (this.valueList_[i].equals(that.valueList_[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 23;
        for (int i = 0; i < this.valueList_.length; ++i) {
            result = HashCodeHelper.hash(result, this.valueList_[i]);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MembersNUplet[");
        if (this.valueList_ == null) {
            buffer.append("memberList_ = ").append("null");
        } else {
            buffer.append("memberList_ = ");
            for (int i = 0; i < this.valueList_.length; ++i) {
                buffer.append(this.valueList_[i] + ", ");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

