/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.DateTimeUtil;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.enums.GroupCondition;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConditionCrystalValueComparator
implements Comparator {
    private Comparator a = null;
    private int if = 0;

    public ConditionCrystalValueComparator(Comparator comparator) {
        this.a = comparator;
    }

    public ConditionCrystalValueComparator(Comparator comparator, int n) {
        this.a = comparator;
        this.if = n;
    }

    public int compare(Object object, Object object2) {
        CrystalValue crystalValue = (CrystalValue)object;
        CrystalValue crystalValue2 = (CrystalValue)object2;
        if (crystalValue == null) {
            return crystalValue2 == null ? 0 : -1;
        }
        if (crystalValue2 == null) {
            return 1;
        }
        ValueType valueType = crystalValue.getValueType();
        CrystalAssert.ASSERT(valueType == crystalValue2.getValueType());
        switch (valueType.value()) {
            case 9: {
                return this.a((DateValue)crystalValue, (DateValue)crystalValue2, this.if);
            }
            case 15: {
                return this.a((DateTimeValue)crystalValue, (DateTimeValue)crystalValue2, this.if);
            }
            case 10: {
                return this.a((TimeValue)crystalValue, (TimeValue)crystalValue2, this.if);
            }
            case 8: {
                return this.a((BooleanValue)crystalValue, (BooleanValue)crystalValue2, this.if);
            }
        }
        return crystalValue.compareTo(crystalValue2, this.a);
    }

    public void setGroupCondition(int n) {
        this.if = n;
    }

    private int a(DateValue dateValue, DateValue dateValue2, int n) {
        if (dateValue == null) {
            if (dateValue2 == null) {
                return 0;
            }
            return -1;
        }
        if (dateValue2 == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                return dateValue.compareTo(dateValue2);
            }
            case 1: {
                int n2 = DateTimeUtil.DateToWeek(dateValue);
                int n3 = DateTimeUtil.DateToWeek(dateValue2);
                return this.a(n2, n3);
            }
            case 2: {
                int n4 = DateTimeUtil.DateToBiweek(dateValue);
                int n5 = DateTimeUtil.DateToBiweek(dateValue2);
                return this.a(n4, n5);
            }
            case 3: {
                int n6 = DateTimeUtil.DateToHalfMonth(dateValue);
                int n7 = DateTimeUtil.DateToHalfMonth(dateValue2);
                return this.a(n6, n7);
            }
            case 4: {
                int n8 = DateTimeUtil.DateToMonth(dateValue);
                int n9 = DateTimeUtil.DateToMonth(dateValue2);
                return this.a(n8, n9);
            }
            case 5: {
                int n10 = DateTimeUtil.DateToQuarterYear(dateValue);
                int n11 = DateTimeUtil.DateToQuarterYear(dateValue2);
                return this.a(n10, n11);
            }
            case 6: {
                int n12 = DateTimeUtil.DateToHalfYear(dateValue);
                int n13 = DateTimeUtil.DateToHalfYear(dateValue2);
                return this.a(n12, n13);
            }
            case 7: {
                int n14 = dateValue.getYear();
                int n15 = dateValue2.getYear();
                return this.a(n14, n15);
            }
        }
        CrystalAssert.ASSERT(false);
        return 0;
    }

    private int a(TimeValue timeValue, TimeValue timeValue2, int n) {
        switch (n) {
            case 0: {
                return timeValue.compareTo(timeValue2);
            }
            case 1: {
                int n2 = DateTimeUtil.TimeToMinutes(timeValue);
                int n3 = DateTimeUtil.TimeToMinutes(timeValue2);
                return this.a(n2, n3);
            }
            case 2: {
                int n4 = DateTimeUtil.TimeToHours(timeValue);
                int n5 = DateTimeUtil.TimeToHours(timeValue2);
                return this.a(n4, n5);
            }
            case 3: {
                int n6 = DateTimeUtil.TimeToAMPM(timeValue);
                int n7 = DateTimeUtil.TimeToAMPM(timeValue2);
                return this.a(n6, n7);
            }
        }
        CrystalAssert.ASSERT(false);
        return 0;
    }

    private int a(DateTimeValue dateTimeValue, DateTimeValue dateTimeValue2, int n) {
        switch (this.if) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                DateValue dateValue = dateTimeValue.getDateValue();
                DateValue dateValue2 = dateTimeValue2.getDateValue();
                int n2 = GroupCondition.ConvertToDatePeriodKind(n);
                return this.a(dateValue, dateValue2, n2);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                DateValue dateValue = dateTimeValue.getDateValue();
                DateValue dateValue3 = dateTimeValue2.getDateValue();
                int n3 = this.a(dateValue, dateValue3, 0);
                if (n3 != 0) {
                    return n3;
                }
                TimeValue timeValue = dateTimeValue.getTimeValue();
                TimeValue timeValue2 = dateTimeValue2.getTimeValue();
                int n4 = GroupCondition.ConvertToTimePeriodKind(n);
                return this.a(timeValue, timeValue2, n4);
            }
        }
        CrystalAssert.ASSERT(false);
        return 0;
    }

    private int a(BooleanValue booleanValue, BooleanValue booleanValue2, int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = !booleanValue2.getBoolean() && booleanValue.getBoolean();
                break;
            }
            case 2: {
                bl = booleanValue2.getBoolean() && !booleanValue.getBoolean();
                break;
            }
            case 3: {
                bl = booleanValue2.getBoolean();
                break;
            }
            case 4: {
                bl = !booleanValue2.getBoolean();
                break;
            }
            case 5: {
                bl = booleanValue.getBoolean();
                break;
            }
            case 6: {
                bl = !booleanValue.getBoolean();
                break;
            }
            case 0: {
                return booleanValue.compareTo(booleanValue2);
            }
            default: {
                CrystalAssert.ASSERT(false);
            }
        }
        return bl ? -1 : 0;
    }

    private int a(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }
}

