/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.BufferedRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.ByteArrayRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.DataPump;
import com.crystaldecisions.reports.common.filemanagement.FileRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.FilterRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.InMemoryRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.InsufficientCapacityException;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorageOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TempRandomAccessStorage
extends FilterRandomAccessStorage {
    private static final String else = ".tras";
    private static final String c = ".tmp";
    private static int case = 32;
    private static boolean f = false;
    private final int byte;
    private InMemoryRandomAccessStorage b;
    private final String long;
    private final String e;
    private final File void;
    private File char;
    private final boolean d;
    private RandomAccessStorage goto;

    public static int getDefaultBlockCount() {
        return case;
    }

    public static RandomAccessStorage createBuffered() {
        return new TempRandomAccessStorage(case, else, c, null, true);
    }

    public TempRandomAccessStorage(int n, String string, String string2, File file, boolean bl) {
        super(null);
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid blocks parameter: " + n);
        }
        TempRandomAccessStorage.a(file);
        this.byte = n;
        this.long = string;
        this.e = string2;
        this.void = file;
        this.d = bl;
        this.a();
    }

    private static void a(File file) {
        if (file == null) {
            return;
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Temp directory does not exist: " + file);
        }
        if (!file.canWrite()) {
            throw new RuntimeException("No write access to the specified temp directory: " + file);
        }
    }

    public TempRandomAccessStorage() {
        this(case, else, c, null, f);
    }

    public TempRandomAccessStorage(int n) {
        this(n, else, c, null, f);
    }

    public TempRandomAccessStorage(String string, String string2) {
        this(case, string, string2, null, f);
    }

    public TempRandomAccessStorage(String string, String string2, File file) {
        this(case, string, string2, file, f);
    }

    public TempRandomAccessStorage(String string, String string2, File file, boolean bl) {
        this(case, string, string2, file, bl);
    }

    private void a() {
        this.b = new ByteArrayRandomAccessStorage(8192, this.byte * 8192);
        this.ras = this.b;
    }

    private File do() throws IOException {
        return this.void == null ? File.createTempFile(this.long, this.e) : File.createTempFile(this.long, this.e, this.void);
    }

    private void if() throws IOException {
        assert (this.ras == this.b);
        if (this.char == null) {
            this.char = this.do();
        }
        this.goto = new FileRandomAccessStorage(this.char, "rw");
        this.b.writeTo(new RandomAccessStorageOutputStream(this.goto));
        if (this.d) {
            this.goto = new BufferedRandomAccessStorage(this.goto);
        }
        this.goto.seek(this.b.getFilePointer());
        this.ras = this.goto;
        this.b = null;
    }

    public void reset() throws IOException {
        if (this.b != null) {
            assert (this.ras == this.b && this.goto == null);
            this.b.setLength(0L, false);
            return;
        }
        if (this.goto != null) {
            assert (this.ras == this.goto && this.b == null);
            this.goto.close();
            this.goto = null;
            this.a();
            return;
        }
        this.verifyOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.ras == null) {
            return;
        }
        try {
            this.ras.close();
            this.ras = null;
            this.b = null;
            this.goto = null;
        }
        finally {
            if (this.char != null) {
                this.char.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.b != null) {
            assert (this.ras == this.b && this.goto == null);
            this.b.writeTo(outputStream);
            return;
        }
        if (this.goto != null) {
            assert (this.ras == this.goto && this.b == null);
            long l = this.goto.getFilePointer();
            try {
                this.goto.seek(0L);
                DataPump.pump(DataPump.createSource(this.goto), DataPump.createSink(outputStream));
            }
            finally {
                this.goto.seek(l);
            }
            return;
        }
        this.verifyOpen();
    }

    public void setLength(long l) throws IOException {
        try {
            super.setLength(l);
        }
        catch (InsufficientCapacityException insufficientCapacityException) {
            assert (this.ras == this.b && this.goto == null);
            this.if();
            super.setLength(l);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        InMemoryRandomAccessStorage inMemoryRandomAccessStorage = this.b;
        if (inMemoryRandomAccessStorage != null) {
            if (inMemoryRandomAccessStorage.fits(n2)) {
                inMemoryRandomAccessStorage.write(byArray, n, n2);
                return;
            }
            this.if();
        }
        assert (this.goto == this.ras);
        super.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        InMemoryRandomAccessStorage inMemoryRandomAccessStorage = this.b;
        if (inMemoryRandomAccessStorage != null) {
            if (inMemoryRandomAccessStorage.fits(1)) {
                inMemoryRandomAccessStorage.write(n);
                return;
            }
            this.if();
        }
        assert (this.goto == this.ras);
        super.write(n);
    }

    boolean inMemory() {
        return this.b != null;
    }

    public String toString() {
        return "TRAS(" + this.ras + ")";
    }
}

