/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.FilterRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorageInputStream;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorageOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class RandomAccessStorages {
    private RandomAccessStorages() {
    }

    public static long skip(RandomAccessStorage randomAccessStorage, long l) throws IOException {
        long l2 = randomAccessStorage.length();
        long l3 = randomAccessStorage.getFilePointer();
        long l4 = l3 + l;
        if (l4 < 0L) {
            l4 = 0L;
        } else if (l4 > l2) {
            l4 = l2;
        }
        if (l3 != l4) {
            randomAccessStorage.seek(l4);
        }
        return l4 - l3;
    }

    public static void readFully(RandomAccessStorage randomAccessStorage, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = randomAccessStorage.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public static void readFully(RandomAccessStorage randomAccessStorage, byte[] byArray) throws IOException {
        RandomAccessStorages.readFully(randomAccessStorage, byArray, 0, byArray.length);
    }

    public static int readPos(RandomAccessStorage randomAccessStorage, long l, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        long l2 = -1L;
        if (bl) {
            l2 = randomAccessStorage.getFilePointer();
        }
        if (l2 != l) {
            randomAccessStorage.seek(l);
        }
        int n3 = randomAccessStorage.read(byArray, n, n2);
        if (bl) {
            randomAccessStorage.seek(l2);
        }
        return n3;
    }

    public static void writePos(RandomAccessStorage randomAccessStorage, long l, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        long l2 = -1L;
        if (bl) {
            l2 = randomAccessStorage.getFilePointer();
        }
        if (l2 != l) {
            randomAccessStorage.seek(l);
        }
        randomAccessStorage.write(byArray, n, n2);
        if (bl) {
            randomAccessStorage.seek(l2);
        }
    }

    public static RandomAccessStorage readOnlyRandomAccessStorage(RandomAccessStorage randomAccessStorage) {
        return new ReadOnlyRandomAccessStorage(randomAccessStorage);
    }

    private static RandomAccessStorage a(RandomAccessStorage randomAccessStorage) {
        FilterRandomAccessStorage filterRandomAccessStorage;
        while (randomAccessStorage instanceof FilterRandomAccessStorage && (filterRandomAccessStorage = (FilterRandomAccessStorage)randomAccessStorage).isBypassable()) {
            randomAccessStorage = filterRandomAccessStorage.ras;
        }
        return randomAccessStorage;
    }

    public static InputStream asInputStream(RandomAccessStorage randomAccessStorage, long l) throws IOException {
        randomAccessStorage.seek(l);
        return new RandomAccessStorageInputStream(RandomAccessStorages.a(randomAccessStorage));
    }

    public static InputStream asInputStream(RandomAccessStorage randomAccessStorage, long l, boolean bl) throws IOException {
        randomAccessStorage.seek(l);
        return new RandomAccessStorageInputStream(RandomAccessStorages.a(randomAccessStorage), bl);
    }

    public static OutputStream asOutputStream(RandomAccessStorage randomAccessStorage) {
        return new RandomAccessStorageOutputStream(RandomAccessStorages.a(randomAccessStorage));
    }

    public static OutputStream asOutputStream(RandomAccessStorage randomAccessStorage, boolean bl) {
        return new RandomAccessStorageOutputStream(RandomAccessStorages.a(randomAccessStorage), bl);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ReadOnlyRandomAccessStorage
    extends FilterRandomAccessStorage {
        private static final String try = "Read-only RandomAccessStorage";

        public ReadOnlyRandomAccessStorage(RandomAccessStorage randomAccessStorage) {
            super(randomAccessStorage);
        }

        public void flush() throws IOException {
            throw new UnsupportedOperationException(try);
        }

        public void setLength(long l) throws IOException {
            throw new UnsupportedOperationException(try);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            throw new UnsupportedOperationException(try);
        }

        public void write(int n) throws IOException {
            throw new UnsupportedOperationException(try);
        }

        public String toString() {
            return "RORAS(" + this.ras + ')';
        }
    }
}

