/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.util.GregorianCalendar;

public class DateTimeUtil {
    public static int DateToWeek(DateValue dateValue) {
        return (dateValue.getCRDate() + 2) / 7;
    }

    public static int DateToWeekDay(DateValue dateValue) {
        return (DateValue.getCRDate(dateValue) + 2) % 7 + 1;
    }

    public static int DateToBiweek(DateValue dateValue) {
        return (dateValue.getCRDate() + 2) / 14;
    }

    public static int DateToBiweekDay(DateValue dateValue) {
        return (dateValue.getCRDate() + 2) % 14 + 1;
    }

    public static int DateToHalfMonth(DateValue dateValue) {
        int n = (dateValue.getYear() * 12 + dateValue.getMonth() - 1) * 2;
        if (dateValue.getDay() > 15) {
            ++n;
        }
        return n;
    }

    public static int DateToMonth(DateValue dateValue) {
        return dateValue.getYear() * 12 + dateValue.getMonth() - 1;
    }

    public static int DateToQuarterYear(DateValue dateValue) {
        int n = dateValue.getMonth();
        int n2 = dateValue.getYear() * 4;
        if (n > 3) {
            ++n2;
        }
        if (n > 6) {
            ++n2;
        }
        if (n > 9) {
            ++n2;
        }
        return n2;
    }

    public static int DateToHalfYear(DateValue dateValue) {
        int n = dateValue.getYear() * 2;
        if (dateValue.getMonth() > 6) {
            ++n;
        }
        return n;
    }

    public static int DayOfWeek(DateValue dateValue) {
        return (dateValue.getCRDate() + 2) % 7 + 1;
    }

    public static int TimeToHours(TimeValue timeValue) {
        return (int)(timeValue.getTimeInNs() / 3600000000000L);
    }

    public static int TimeToMinutes(TimeValue timeValue) {
        return (int)(timeValue.getTimeInNs() / 60000000000L);
    }

    public static int TimeToAMPM(TimeValue timeValue) {
        int n = DateTimeUtil.TimeToHours(timeValue);
        if (n >= 12) {
            return 1;
        }
        return 0;
    }

    public static int NDaysInYear(int n) {
        return DateTimeUtil.isLeapYear(n) ? 366 : 365;
    }

    public static int NDaysInMonth(int n, int n2) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("monthN must be between 1 and 12");
        }
        int n3 = a.do[--n2];
        if (n2 == a.int && DateTimeUtil.isLeapYear(n)) {
            ++n3;
        }
        return n3;
    }

    public static boolean isLeapYear(int n) {
        return n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    public static String getMonthNameString(int n, boolean bl) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("monthN must be between 1 and 12");
        }
        if (bl) {
            return dateFormatSymbols.getShortMonths()[n - 1];
        }
        return dateFormatSymbols.getMonths()[n - 1];
    }

    public static String getWeekdayNameString(int n, boolean bl) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("weekdayN must be between 1 and 7");
        }
        if (bl) {
            return dateFormatSymbols.getShortWeekdays()[n];
        }
        return dateFormatSymbols.getWeekdays()[n];
    }

    public static int getSystemFirstDayOfWeek() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return gregorianCalendar.getFirstDayOfWeek();
    }

    public static int getSystemMinimalDaysInFirstWeekOfYear() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return gregorianCalendar.getMinimalDaysInFirstWeek();
    }

    public static RangeValue WeekToDateFromSun(DateValue dateValue) {
        int n = DateTimeUtil.DateToWeekDay(dateValue);
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - --n);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue, true, true);
    }

    public static RangeValue MonthToDate(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromYMD(dateValue.getYear(), dateValue.getMonth(), 1);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue, true, true);
    }

    public static RangeValue YearToDate(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromYMD(dateValue.getYear(), 1, 1);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue, true, true);
    }

    public static RangeValue Last7Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - 6);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue, true, true);
    }

    public static RangeValue Last4WeeksToSun(DateValue dateValue) {
        int n = DateTimeUtil.DateToWeekDay(dateValue);
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - --n - 27);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() - n);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue LastFullWeek(DateValue dateValue) {
        int n = DateTimeUtil.DateToWeekDay(dateValue);
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - --n - 7);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() - n - 1);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue LastFullMonth(DateValue dateValue) {
        int n = dateValue.getYear();
        int n2 = dateValue.getMonth();
        int n3 = dateValue.getDay();
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - n3);
        DateValue dateValue3 = n2 == 1 ? DateValue.fromYMD(n - 1, 12, 1) : DateValue.fromYMD(n, n2 - 1, 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue2, true, true);
    }

    public static RangeValue AllDatesToToday(DateValue dateValue) {
        return RangeValue.fromStartAndEndValues(DateValue.fromCRDate(0), dateValue, true, true);
    }

    public static RangeValue AllDatesToYesterday(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(DateValue.fromCRDate(0), dateValue2, true, true);
    }

    public static RangeValue AllDatesFromToday(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromYMD(9999, 12, 31);
        return RangeValue.fromStartAndEndValues(dateValue, dateValue2, true, true);
    }

    public static RangeValue AllDatesFromTomorrow(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() + 1);
        DateValue dateValue3 = DateValue.fromYMD(9999, 12, 31);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Aged0To30Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - 30);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue, true, true);
    }

    public static RangeValue Aged31To60Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - 60);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() - 31);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Aged61To90Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() - 90);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() - 61);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Over90Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(0);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() - 91);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Next30Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() + 30);
        return RangeValue.fromStartAndEndValues(dateValue, dateValue2, true, true);
    }

    public static RangeValue Next31To60Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() + 31);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() + 60);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Next61To90Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() + 61);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() + 90);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Next91To365Days(DateValue dateValue) {
        DateValue dateValue2 = DateValue.fromCRDate(dateValue.getCRDate() + 91);
        DateValue dateValue3 = DateValue.fromCRDate(dateValue.getCRDate() + 365);
        return RangeValue.fromStartAndEndValues(dateValue2, dateValue3, true, true);
    }

    public static RangeValue Calendar1stQtr(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n, 4, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 1, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue Calendar2ndQtr(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n, 7, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 4, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue Calendar3rdQtr(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n, 10, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 7, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue Calendar4thQtr(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n + 1, 1, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 10, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue Calendar1stHalf(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n, 7, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 1, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue Calendar2ndHalf(DateValue dateValue) {
        int n = dateValue.getYear();
        DateValue dateValue2 = DateValue.fromYMD(n + 1, 1, 1);
        DateValue dateValue3 = DateValue.fromYMD(n, 7, 1);
        DateValue dateValue4 = DateValue.fromCRDate(dateValue2.getCRDate() - 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue4, true, true);
    }

    public static RangeValue LastYearMTD(DateValue dateValue) {
        int n;
        int n2 = dateValue.getYear();
        int n3 = dateValue.getMonth();
        int n4 = n = dateValue.getDay();
        if (n3 == 2 && n == 29) {
            --n4;
        }
        DateValue dateValue2 = DateValue.fromYMD(n2 - 1, n3, n4);
        DateValue dateValue3 = DateValue.fromYMD(n2 - 1, n3, 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue2, true, true);
    }

    public static RangeValue LastYearYTD(DateValue dateValue) {
        int n;
        int n2 = dateValue.getYear();
        int n3 = dateValue.getMonth();
        int n4 = n = dateValue.getDay();
        if (n3 == 2 && n == 29) {
            --n4;
        }
        DateValue dateValue2 = DateValue.fromYMD(n2 - 1, n3, n4);
        DateValue dateValue3 = DateValue.fromYMD(n2 - 1, 1, 1);
        return RangeValue.fromStartAndEndValues(dateValue3, dateValue2, true, true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class a {
        public static boolean for = false;
        public static int a = 12;
        public static int[] do = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        public static int int = 1;
        public static int if = 1;

        private a() {
        }
    }
}

