/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;

public final class CharacterBuffer {
    CharacterSet charSet;
    byte[] bytes;
    int next;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterBuffer(CharacterSet charSet) {
        this.charSet = charSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(charSet));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.next = 0;
            this.bytes = new byte[32];
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(int c2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.charSet.encode(this, c2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] __result__ = CharacterSet.useOrCopy(this.bytes, 0, this.next);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterBuffer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterBuffer"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

