/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.jdbc.TNSAddress.AddressList;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;

    public NavAddressList(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    public void navigate(ConnStrategy cs, StringBuffer sBuf) {
        this.navigate2(cs, sBuf, 0);
    }

    private void navigate2(ConnStrategy cs, StringBuffer sBuf, int reCurCnt) {
        int i2;
        boolean nested = false;
        ++reCurCnt;
        this.sBuflength = sBuf.length();
        sBuf.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
            for (i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(cs);
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (i2 = 0; i2 < this.activeChildren.size(); ++i2) {
                if (this.getChildrenType(i2) == 1) {
                    nested = true;
                    ((NavAddressList)this.activeChildren.elementAt(i2)).navigate2(cs, sBuf, reCurCnt);
                    continue;
                }
                ((NavSchemaObject)this.activeChildren.elementAt(i2)).navigate(cs, sBuf);
            }
        }
        if (!(--reCurCnt == 0 && nested || this.sourceRoute)) {
            this.closeNVPair(cs, false);
        } else {
            this.closeNVPair(cs, true);
        }
        sBuf.setLength(this.sBuflength);
    }

    public void addToString(ConnStrategy cs) {
        String NVString = this.toString();
        for (int i2 = cs.cOpts.size() - 1; i2 >= 0 && !((ConnOption)cs.cOpts.elementAt((int)i2)).done; --i2) {
            ((ConnOption)cs.cOpts.elementAt((int)i2)).conn_data.append(NVString);
        }
    }

    public String toString() {
        String s2 = "";
        s2 = s2 + "(ADDRESS_LIST=";
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            s2 = s2 + ((NavSchemaObject)this.children.elementAt(i2)).toString();
        }
        if (this.sourceRoute) {
            s2 = s2 + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
        }
        if (this.loadBalance) {
            s2 = s2 + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            s2 = s2 + "(FAILOVER=false)";
        }
        s2 = s2 + ")";
        return s2;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int childNum) {
        return ((NavSchemaObject)this.children.elementAt(childNum)).isA();
    }

    public NavAddress getChild(int childNum) {
        return (NavAddress)this.children.elementAt(childNum);
    }

    private void closeNVPair(ConnStrategy cs, boolean mode) {
        for (int i2 = cs.cOpts.size() - 1; i2 >= 0 && !((ConnOption)cs.cOpts.elementAt((int)i2)).done && (mode || cs.cOpts.size() - 1 - i2 < this.getChildrenSize()); --i2) {
            if (this.sourceRoute) {
                ((ConnOption)cs.cOpts.elementAt((int)i2)).conn_data.append("(SOURCE_ROUTE=yes)");
                ((ConnOption)cs.cOpts.elementAt((int)i2)).conn_data.append("(HOP_COUNT=0)");
            }
            ((ConnOption)cs.cOpts.elementAt((int)i2)).conn_data.append(")");
        }
    }
}

