/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version;
    private boolean needStackingForCommitRollbackPrepare;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        block13: {
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        block29: {
            super(pm_conn, xaconn);
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                block28: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    try {
                        this.m_version = ((OracleConnection)pm_conn).getVersionNumber();
                        this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
                    }
                    catch (SQLException sqe) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block28;
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource(pm_conn, xaconn): getVersionNumber() -- SQLException");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (this.m_version >= 8170) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource(pm_conn): Java XA not supported for this server version");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flag) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                int returnVal = -1;
                try {
                    if (xid == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start(): XAER_INVAL: xid is null");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    int isolFlag = flag & 0xFF00;
                    int otherFlag = (flag &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                    if (((flag &= 0xFFFEFFFF) & 0x8200002) != flag || otherFlag != 0 && (otherFlag & 0x10000) != 65536) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start(): XAER_INVAL: invalid flag");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start(): XAER_INVAL: invalid Isolation flag");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    if ((flag & 0x8200000) != 0 && ((isolFlag & 0xFF00) != 0 || (otherFlag & 0x10000) != 0)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start(): XAER_INVAL: Isolation flags not allowed " + "for JOIN/RESUME");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    flag |= isolFlag | otherFlag;
                    this.saveAndAlterAutoCommitModeForGlobalTransaction();
                    try {
                        returnVal = this.doStart(xid, flag);
                    }
                    catch (SQLException sqle) {
                        this.checkError(sqle, -3);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start(): return status returnVal = " + returnVal);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.checkError(returnVal);
                    boolean[] isLocallySuspended = new boolean[]{false};
                    super.createOrUpdateXid(xid, false, isLocallySuspended);
                }
                catch (XAException ea) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    throw ea;
                }
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int flag) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int returnVal = -1;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_start_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, this.timeout);
                cstmt.setInt(6, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.start() returnVal=" + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (returnVal == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flag) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                block66: {
                    int returnVal = -1;
                    boolean isTMSUCCESS = false;
                    boolean isTMFAIL = false;
                    try {
                        if (xid == null) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.end(): XAER_INVAL: xid is null");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(-5);
                        }
                        int validFlags = 638582786;
                        if ((flag & validFlags) != flag) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.end(): XAER_INVAL: invalid flag");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(-5);
                        }
                        Xid stackedXid = null;
                        isTMSUCCESS = (flag & 0x4000000) != 0;
                        boolean bl = isTMFAIL = (flag & 0x20000000) != 0;
                        if (isTMSUCCESS || isTMFAIL) {
                            stackedXid = super.suspendStacked(xid);
                        }
                        try {
                            boolean isLocallySuspended = false;
                            if (isTMSUCCESS || isTMFAIL) {
                                isLocallySuspended = this.isXidSuspended(xid);
                                if (isLocallySuspended) {
                                    super.resumeStacked(xid);
                                }
                                this.removeXidFromList(xid);
                            } else if (flag == 0x2000000) {
                                boolean[] flags = new boolean[]{false};
                                super.createOrUpdateXid(xid, true, flags);
                                isLocallySuspended = flags[0];
                            }
                            returnVal = this.doEnd(xid, flag, isLocallySuspended);
                        }
                        catch (SQLException sqle) {
                            this.checkError(sqle, -3);
                        }
                        if (stackedXid != null) {
                            super.resumeStacked(stackedXid);
                        } else if (this.isXidListEmpty()) {
                            this.exitGlobalTxnMode();
                            this.activeXid = null;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.end(): return status returnVal = " + returnVal);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.checkError(returnVal);
                        if ((!isTMSUCCESS || flag == 0x4000000) && (!isTMFAIL || flag == 0x20000000)) break block66;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.end(): XAER_INVAL: The flag combines TMSUCCESS or TMFAIL with other flags: " + flag);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    finally {
                        this.restoreAutoCommitModeForGlobalTransaction();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag) + ", " + OracleLog.argument(isLocallySuspended));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement cstmt = null;
            int returnVal = -1;
            try {
                cstmt = this.connection.prepareCall(xa_end_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.end() returnVal=" + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (returnVal == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhase));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit(): XAER_INVAL: xid is null");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!TRACE || !OracleLog.recursiveEnter()) throw new XAException(-5);
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        throw new XAException(-5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Xid stackedXid = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    stackedXid = super.suspendStacked(xid);
                } else {
                    this.removeXidFromList(xid);
                    if (this.activeXid == null) {
                        this.exitGlobalTxnMode();
                    }
                }
                try {
                    try {
                        this.doCommit(xid, onePhase);
                    }
                    catch (SQLException sqle) {
                        this.checkError(sqle, -3);
                    }
                }
                catch (XAException xae) {
                    if (xae.errorCode == -7) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit(): Error during commit is fatal so, close the connection.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        try {
                            this.connection.close();
                            throw xae;
                        }
                        catch (SQLException ea) {
                            if (!TRACE || !OracleLog.recursiveEnter()) throw xae;
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit(): connection.close yielded: " + ea.getMessage());
                                throw xae;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    if (!this.needStackingForCommitRollbackPrepare) throw xae;
                    super.resumeStacked(stackedXid);
                    throw xae;
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
            }
        }
        catch (Throwable throwable) {
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                throw throwable;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(Xid xid, boolean onePhase) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhase));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_commit_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, onePhase ? 1 : 0);
                cstmt.execute();
                int returnVal = cstmt.getInt(1);
                this.checkError(returnVal, -7);
            }
            catch (SQLException s2) {
                int returnVal = s2.getErrorCode();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit() returnVal=" + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (returnVal == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare(Xid xid) throws XAException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                Xid stackedXid;
                int returnVal;
                block54: {
                    returnVal = 0;
                    if (xid == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.prepare(): XAER_INVAL: xid is null");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (!TRACE) throw new XAException(-5);
                        if (!OracleLog.recursiveEnter()) throw new XAException(-5);
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            throw new XAException(-5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    stackedXid = null;
                    if (this.needStackingForCommitRollbackPrepare) {
                        stackedXid = super.suspendStacked(xid);
                    }
                    try {
                        try {
                            int x_e;
                            returnVal = this.doPrepare(xid);
                            if (returnVal == 0 || returnVal == 3) break block54;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.prepare(): return status returnVal = " + returnVal);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if ((x_e = OracleXAException.errorConvert(returnVal)) != 0 && x_e != 3) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + returnVal);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                XAException __ex__ = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), returnVal);
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                            returnVal = x_e;
                        }
                        catch (SQLException sqle) {
                            this.checkError(sqle, -3);
                        }
                    }
                    catch (XAException xaex) {
                        if (xaex.errorCode != -7) {
                            if (!this.needStackingForCommitRollbackPrepare) throw xaex;
                            super.resumeStacked(stackedXid);
                            throw xaex;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit(): Error during commit is fatal so, close the connection.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        try {
                            this.connection.close();
                            throw xaex;
                        }
                        catch (SQLException ea) {
                            if (!TRACE) throw xaex;
                            if (!OracleLog.recursiveEnter()) throw xaex;
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.commit(): connection.close yielded: " + ea.getMessage());
                                throw xaex;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = returnVal;
            }
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                throw throwable;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return n2;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int returnVal = 0;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_prepare_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                int errorCode = s2.getErrorCode();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.prepare() errorCode=" + errorCode);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (errorCode == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int returnVal = 0;
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.forget(): XAER_INVAL: xid is null");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                this.removeXidFromList(xid);
                try {
                    returnVal = this.doForget(xid);
                }
                catch (SQLException sqle) {
                    this.checkError(sqle, -3);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.forget(): return status returnVal = " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkError(returnVal);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doForget(Xid xid) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int returnVal = 0;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_forget_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.forget() returnVal=" + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (returnVal == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                int returnVal = 0;
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.rollback(): XAER_INVAL: xid is null");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                Xid stackedXid = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    stackedXid = super.suspendStacked(xid);
                } else {
                    this.removeXidFromList(xid);
                    if (this.activeXid == null) {
                        this.exitGlobalTxnMode();
                    }
                }
                try {
                    this.doRollback(xid);
                }
                catch (SQLException sqle) {
                    this.checkError(sqle, -3);
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.rollback(): return status returnVal = " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkError(returnVal);
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback(Xid xid) throws XAException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_rollback_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                int returnVal = cstmt.getInt(1);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.doRollback() returnVal=" + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkError(returnVal, -7);
            }
            catch (SQLException s2) {
                int errorCode = s2.getErrorCode();
                if (errorCode == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-6);
                }
                throw s2;
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nsites) + ", " + OracleLog.argument(action) + ", " + OracleLog.argument(dbnames) + ", " + OracleLog.argument(xids));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                this.doDoTwoPhaseAction(nsites, action, dbnames, xids);
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDoTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nsites) + ", " + OracleLog.argument(action) + ", " + OracleLog.argument(dbnames) + ", " + OracleLog.argument(xids));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new XAException(-6);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedBytes(Xid xid) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                byte[] byArray = Util.serializeObject(xid);
                return byArray;
            }
            catch (IOException ioe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "         Debug: OracleXAResource.getSerializedBytes() got exception: " + ioe);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, "         Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return byArray;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

