/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.converter.CharacterSetMetaData;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OracleTypeCHAR() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCHAR(OracleConnection conn) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleTypeCHAR(OracleConnection conn, int typecode) {
        super(typecode);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(typecode));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                        Object var8_9 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            Object var10_12 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_14 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        CHAR cHAR;
        block32: {
            block30: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (value != null) break block30;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                Datum datum = null;
                Object var12_16 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return datum;
            }
            if (!(value instanceof CHAR)) break block32;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CHAR)value);
                    Object var8_32 = null;
                }
                catch (Throwable throwable) {
                    Object var8_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            CHAR cHAR2 = (CHAR)value;
            Object var12_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_22 = null;
                }
                catch (Throwable throwable) {
                    Object var14_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return cHAR2;
        }
        try {
            CHAR datum;
            if (this.typeCode == 1 && value instanceof String) {
                if (this.characterSemantic != 0) {
                    int ratio = CharacterSetMetaData.getRatio(this.pickleCharaterSetId, 1);
                    String s2 = (String)value;
                    for (int i2 = s2.length(); i2 < this.length / ratio; ++i2) {
                        s2 = s2 + " ";
                    }
                    value = s2;
                    datum = new CHAR(value, this.pickleCharacterSet);
                } else {
                    datum = new CHAR((String)value, this.pickleCharacterSet, this.length);
                }
            } else {
                datum = new CHAR(value, this.pickleCharacterSet);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                    Object var10_35 = null;
                }
                catch (Throwable throwable) {
                    Object var10_36 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            cHAR = datum;
            Object var12_18 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_24 = null;
            }
            catch (Throwable throwable) {
                Object var14_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                    datumArray = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Datum[] datumArray2 = null;
            if (obj != null) {
                if (obj instanceof Object[] && !(obj instanceof char[][])) {
                    Datum[] __result__ = super.toDatumArray(obj, conn, beginIdx, count);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var9_9 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    Datum[] datumArray3 = __result__;
                    Object var13_13 = null;
                    if (!TRACE) return datumArray3;
                    if (!OracleLog.recursiveEnter()) return datumArray3;
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_16 = null;
                        OracleLog.recursiveExit();
                        return datumArray3;
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                datumArray2 = this.cArrayToDatumArray(obj, conn, beginIdx, count);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                    Object var11_25 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            datumArray = datumArray2;
            Object var13_14 = null;
            if (!TRACE) return datumArray;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return datumArray;
        try {}
        catch (Throwable throwable) {
            Object var15_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_18 = null;
        OracleLog.recursiveExit();
        return datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        try {
            block23: {
                block22: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tdsReader));
                            Object var3_2 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    super.parseTDSrec(tdsReader);
                    try {
                        this.length = tdsReader.readUB2();
                        this.form = tdsReader.readByte();
                        this.characterSemantic = this.form & 0x80;
                        this.form &= 0x7F;
                        this.charset = tdsReader.readUB2();
                    }
                    catch (SQLException ex) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 47 + "parseTDS");
                                Object var5_7 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var5_8 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.form != 2) break block22;
                    if (this.pickleNcharCharacterSet == 0) break block23;
                }
                Object var9_12 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                        Object var7_24 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.pickleNcharCharacterSet = (short)2000;
            }
            this.pickleCharaterSetId = this.pickleNcharCharacterSet;
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            Object var9_13 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var11_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var11_17 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int pickle81(PickleContext context, Datum data) throws SQLException {
        int n2;
        try {
            SQLException __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(data));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            CHAR dbchar = this.getDbCHAR(data);
            if (this.characterSemantic != 0 && this.form != 2) {
                if (dbchar.getStringWithReplacement().length() > this.length) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 72 + "\"" + dbchar.getStringWithReplacement() + "\"");
                            Object var6_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (dbchar.getLength() > (long)this.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 72 + "\"" + dbchar.getStringWithReplacement() + "\"");
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = super.pickle81(context, dbchar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var10_15 = null;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var12_18 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_20 = null;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        block45: {
            Object __result__;
            block43: {
                CHAR result;
                block41: {
                    CHAR cHAR;
                    block39: {
                        Object var4_7;
                        try {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(map));
                                    cHAR = null;
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            if (bytes != null && bytes.length != 0) break block39;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                                    Object var7_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var7_10 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            var4_7 = null;
                            Object var17_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_17 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_26 = null;
                                }
                                catch (Throwable throwable2) {
                                    Object var19_27 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable2;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw throwable;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_18 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_19 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return var4_7;
                    }
                    result = null;
                    switch (this.form) {
                        case 1: 
                        case 2: {
                            result = new CHAR(bytes, this.pickleCharacterSet);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            result = new CHAR(bytes, null);
                        }
                    }
                    if (type != 1) break block41;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                            Object var9_33 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    cHAR = result;
                    Object var17_14 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_21 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return cHAR;
                }
                if (type != 2) break block43;
                __result__ = result.stringValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)__result__);
                        Object var11_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                String string = __result__;
                Object var17_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return string;
            }
            if (type != 3) break block45;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                    Object var13_39 = null;
                }
                catch (Throwable throwable) {
                    Object var13_40 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            __result__ = bytes;
            Object var17_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_24 = null;
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __result__;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + bytes);
                Object var15_42 = null;
            }
            catch (Throwable throwable) {
                Object var15_43 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CHAR getDbCHAR(Datum data) {
        CHAR cHAR;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(data));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            CHAR in_char_obj = (CHAR)data;
            CHAR db_char_obj = null;
            if (in_char_obj.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
                db_char_obj = in_char_obj;
            } else {
                try {
                    db_char_obj = new CHAR(in_char_obj.toString(), this.pickleCharacterSet);
                }
                catch (SQLException ex) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            ex.printStackTrace(pw);
                            String z = sw.toString();
                            OracleTypeCHAR.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    db_char_obj = in_char_obj;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + db_char_obj);
                    Object var11_14 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            cHAR = db_char_obj;
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum[] cArrayToDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                    datumArray = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum[] datumArray2 = null;
            if (obj != null) {
                Object parray;
                if (obj instanceof char[][]) {
                    parray = (char[][])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        datumArray2[i2] = new CHAR(new String(parray[(int)beginIdx + i2 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof boolean[]) {
                    parray = (boolean[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i3 = 0; i3 < len; ++i3) {
                        datumArray2[i3] = new CHAR((boolean)parray[(int)beginIdx + i3 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof short[]) {
                    parray = (short[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i4 = 0; i4 < len; ++i4) {
                        datumArray2[i4] = new CHAR((int)parray[(int)beginIdx + i4 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof int[]) {
                    parray = (int[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i5 = 0; i5 < len; ++i5) {
                        datumArray2[i5] = new CHAR((int)parray[(int)beginIdx + i5 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof long[]) {
                    parray = (long[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i6 = 0; i6 < len; ++i6) {
                        datumArray2[i6] = new CHAR(new Long((long)parray[(int)beginIdx + i6 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof float[]) {
                    parray = (float[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i7 = 0; i7 < len; ++i7) {
                        datumArray2[i7] = new CHAR(new Float((float)parray[(int)beginIdx + i7 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof double[]) {
                    parray = (double[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray2 = new Datum[len];
                    for (int i8 = 0; i8 < len; ++i8) {
                        datumArray2[i8] = new CHAR(new Double((double)parray[(int)beginIdx + i8 - 1]), this.pickleCharacterSet);
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + obj);
                            Object var11_23 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_24 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                    Object var13_26 = null;
                }
                catch (Throwable throwable) {
                    Object var13_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datumArray = datumArray2;
            Object var15_29 = null;
        }
        catch (Throwable throwable) {
            Object var15_30 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_33 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_34 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_31 = null;
            }
            catch (Throwable throwable) {
                Object var17_32 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.length);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.length;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(out));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            out.writeInt(this.form);
            out.writeInt(this.charset);
            out.writeInt(this.length);
            out.writeInt(this.characterSemantic);
            out.writeShort(this.pickleCharaterSetId);
            out.writeShort(this.pickleNcharCharacterSet);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.form = in.readInt();
            this.charset = in.readInt();
            this.length = in.readInt();
            this.characterSemantic = in.readInt();
            this.pickleCharaterSetId = in.readShort();
            this.pickleNcharCharacterSet = in.readShort();
            this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(OracleConnection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = conn;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNCHAR() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = this.form == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = this.connection;
            Object var6_8 = null;
            if (!TRACE) return oracleConnection;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleConnection;
        try {
            OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeCHAR"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

