/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TIMESTAMPTZ;

final class T4CTTIokpn
extends T4CTTIfun {
    static final int REGISTER_KPNDEF = 1;
    static final int UNREGISTER_KPNDEF = 2;
    static final int POST_KPNDEF = 3;
    static final int EXISTINGCLIENT_KPNDEF = 0;
    static final int NEWCLIENT_KPNDEF = 1;
    static final int KPUN_PRS_RAW = 1;
    static final int KPUN_VER_10200 = 2;
    static final int KPUN_VER_11100 = 3;
    static final int KPUN_VER_11200 = 4;
    static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
    static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
    static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
    static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
    static final int KPD_CHNF_OPFILTER = 1;
    static final int KPD_CHNF_INSERT = 2;
    static final int KPD_CHNF_UPDATE = 4;
    static final int KPD_CHNF_DELETE = 8;
    static final int KPD_CHNF_ROWID = 16;
    static final int KPD_CQ_QUERYNF = 32;
    static final int KPD_CQ_BEST_EFFORT = 64;
    static final int KPD_CQ_CLQRYCACHE = 128;
    static final int KPD_CHNF_INVALID_REGID = 0;
    static final int SUBSCR_QOS_RELIABLE = 1;
    static final int SUBSCR_QOS_PAYLOAD = 2;
    static final int SUBSCR_QOS_REPLICATE = 4;
    static final int SUBSCR_QOS_SECURE = 8;
    static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
    static final int SUBSCR_QOS_MULTICBK = 32;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_NONE = 0;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_TIME = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_SUMMARY = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_LAST = 2;
    private int opcode;
    private int mode;
    private int nbOfRegistrationInfo;
    private String user;
    private String location;
    private int[] namespace;
    private int[] kpdnrgrpval;
    private int[] kpdnrgrprepcnt;
    private int[] payloadType;
    private int[] qosFlags;
    private int[] timeout;
    private int[] dbchangeOpFilter;
    private int[] dbchangeTxnLag = null;
    private byte[][] registeredAgentName = null;
    private byte[][] kpdnrcx = null;
    private byte[] kpdnrgrpcla;
    private byte[] kpdnrgrptyp = null;
    private TIMESTAMPTZ[] kpdnrgrpstatim = null;
    private long[] dbchangeRegistrationId = null;
    private byte[] userArr = null;
    private byte[] locationArr = null;
    private long regid = 0L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIokpn(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)125);
    }

    void doOKPN(int _opcode, int _mode, String _user, String _location, int _nbOfRegistrationInfo, int[] _namespace, String[] _registeredAgentName, byte[][] _kpdnrcx, int[] _payloadType, int[] _qosFlags, int[] _timeout, int[] _dbchangeOpFilter, int[] _dbchangeTxnLag, long[] _dbchangeRegistrationId, byte[] _kpdnrgrpcla, int[] _kpdnrgrpval, byte[] _kpdnrgrptyp, TIMESTAMPTZ[] _kpdnrgrpstatim, int[] _kpdnrgrprepcnt) throws IOException, SQLException {
        this.opcode = _opcode;
        this.mode = _mode;
        this.user = _user;
        this.location = _location;
        this.nbOfRegistrationInfo = _nbOfRegistrationInfo;
        this.namespace = _namespace;
        this.kpdnrcx = _kpdnrcx;
        this.payloadType = _payloadType;
        this.qosFlags = _qosFlags;
        this.timeout = _timeout;
        this.dbchangeOpFilter = _dbchangeOpFilter;
        this.dbchangeTxnLag = _dbchangeTxnLag;
        this.dbchangeRegistrationId = _dbchangeRegistrationId;
        this.kpdnrgrpcla = _kpdnrgrpcla;
        this.kpdnrgrpval = _kpdnrgrpval;
        this.kpdnrgrptyp = _kpdnrgrptyp;
        this.kpdnrgrpstatim = _kpdnrgrpstatim;
        this.kpdnrgrprepcnt = _kpdnrgrprepcnt;
        this.registeredAgentName = new byte[this.nbOfRegistrationInfo][];
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            if (_registeredAgentName[i2] == null) continue;
            this.registeredAgentName[i2] = this.meg.conv.StringToCharBytes(_registeredAgentName[i2]);
        }
        this.userArr = (byte[])(this.user != null ? this.meg.conv.StringToCharBytes(this.user) : null);
        this.locationArr = (byte[])(this.location != null ? this.meg.conv.StringToCharBytes(this.location) : null);
        this.regid = 0L;
        this.doRPC();
    }

    void marshal() throws IOException {
        int presentation = 1;
        int kpnver = 2;
        this.meg.marshalUB1((byte)this.opcode);
        this.meg.marshalUB4(this.mode);
        if (this.userArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.userArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.locationArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.locationArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbOfRegistrationInfo);
        this.meg.marshalUB2(presentation);
        this.meg.marshalUB2(kpnver);
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
            }
        }
        if (this.userArr != null) {
            this.meg.marshalCHR(this.userArr);
        }
        if (this.locationArr != null) {
            this.meg.marshalCHR(this.locationArr);
        }
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            this.meg.marshalUB4(this.namespace[i2]);
            byte[] kpdnrnm = this.registeredAgentName[i2];
            if (kpdnrnm != null && kpdnrnm.length > 0) {
                this.meg.marshalUB4(kpdnrnm.length);
                this.meg.marshalCLR(kpdnrnm, 0, kpdnrnm.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            if (this.kpdnrcx[i2] != null && this.kpdnrcx[i2].length > 0) {
                this.meg.marshalUB4(this.kpdnrcx[i2].length);
                this.meg.marshalCLR(this.kpdnrcx[i2], 0, this.kpdnrcx[i2].length);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(this.payloadType[i2]);
            if (this.connection.getTTCVersion() < 4) continue;
            this.meg.marshalUB4(this.qosFlags[i2]);
            byte[] kpdnrpaycb = new byte[]{};
            this.meg.marshalUB4(kpdnrpaycb.length);
            if (kpdnrpaycb.length > 0) {
                this.meg.marshalCLR(kpdnrpaycb, kpdnrpaycb.length);
            }
            this.meg.marshalUB4(this.timeout[i2]);
            int kpdnsd = 0;
            this.meg.marshalUB4(kpdnsd);
            this.meg.marshalUB4(this.dbchangeOpFilter[i2]);
            this.meg.marshalUB4(this.dbchangeTxnLag[i2]);
            this.meg.marshalUB4((int)this.dbchangeRegistrationId[i2]);
            if (this.connection.getTTCVersion() < 5) continue;
            this.meg.marshalUB1(this.kpdnrgrpcla[i2]);
            this.meg.marshalUB4(this.kpdnrgrpval[i2]);
            this.meg.marshalUB1(this.kpdnrgrptyp[i2]);
            if (this.kpdnrgrpstatim[i2] == null) {
                this.meg.marshalDALC(null);
            } else {
                this.meg.marshalDALC(this.kpdnrgrpstatim[i2].shareBytes());
            }
            this.meg.marshalSB4(this.kpdnrgrprepcnt[i2]);
            this.meg.marshalSB8(this.dbchangeRegistrationId[i2]);
        }
    }

    long getRegistrationId() {
        return this.regid;
    }

    void readRPA() throws IOException, SQLException {
        int kpnrl = (int)this.meg.unmarshalUB4();
        for (int i2 = 0; i2 < kpnrl; ++i2) {
            this.meg.unmarshalUB4();
        }
        int[] regidArr = new int[kpnrl];
        for (int i3 = 0; i3 < kpnrl; ++i3) {
            regidArr[i3] = (int)this.meg.unmarshalUB4();
        }
        this.regid = regidArr[0];
        if (this.connection.getTTCVersion() >= 5) {
            long kpngnregid;
            int kpngrl = (int)this.meg.unmarshalUB4();
            this.regid = kpngnregid = this.meg.unmarshalSB8();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIokpn.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIokpn.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIokpn.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIokpn"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

