/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleStatement;

class CharAccessor
extends CharCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            int maxLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (max_len > (maxLength = 2000)) {
                maxLength = max_len;
            }
            if (stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
                maxLength = 32766;
            }
            this.init(stmt, 96, 9, max_len, form, external_type, forBind, maxLength, 255);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            int maxLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (max_len > (maxLength = 2000)) {
                maxLength = max_len;
            }
            if (stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
                maxLength = 32766;
            }
            this.init(stmt, 96, 9, max_len, nullable, flags, precision, scale, contflag, total_elems, form, maxLength, 255);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.CharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

