/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjClassID;

public final class IdentObj {
    public static final int OBJECT_NA = -3;
    public static final int SERIES_NA = -3;
    public static final int GROUP_NA = -3;
    public static final int MISC_NA = -3;
    public static final IdentObj GLOBAL = new IdentObj(-3);
    public static final int HILO_VOLUME_SERIES = 1;
    public static final int PIEBAR_ID_TOPLINE = 300;
    public static final int PIEBAR_ID_BOTTOMLINE = 400;
    private final int m_objectID;
    private final int m_seriesID;
    private final int m_groupID;
    private final int m_miscID;

    public IdentObj(int objectID) {
        this(objectID, -3, -3, -3);
    }

    public IdentObj(int objectID, int seriesID) {
        this(objectID, seriesID, -3, -3);
    }

    public IdentObj(int objectID, int seriesID, int groupID) {
        this(objectID, seriesID, groupID, -3);
    }

    public IdentObj(int objectID, int seriesID, int groupID, int miscID) {
        this.m_objectID = objectID;
        this.m_seriesID = seriesID;
        this.m_groupID = groupID;
        this.m_miscID = miscID;
    }

    public IdentObj changeObject(int newObjectID) {
        return new IdentObj(newObjectID, this.getSeriesID(), this.getGroupID(), this.getMiscID());
    }

    public IdentObj changeSeries(int newSeriesID) {
        return new IdentObj(this.getObjectID(), newSeriesID, this.getGroupID(), this.getMiscID());
    }

    public IdentObj changeGroup(int newGroupID) {
        return new IdentObj(this.getObjectID(), this.getSeriesID(), newGroupID, this.getMiscID());
    }

    public IdentObj changeMisc(int newMiscID) {
        return new IdentObj(this.getObjectID(), this.getSeriesID(), this.getGroupID(), newMiscID);
    }

    public IdentObj incrementMisc(int increment) {
        return new IdentObj(this.getObjectID(), this.getSeriesID(), this.getGroupID(), this.getMiscID() + increment);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_objectID;
        result = 37 * result + this.m_seriesID;
        result = 37 * result + this.m_groupID;
        result = 37 * result + this.m_miscID;
        return result;
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof IdentObj)) {
            return false;
        }
        IdentObj xID = (IdentObj)x;
        if (this.m_objectID != xID.m_objectID) {
            return false;
        }
        if (this.m_seriesID != xID.m_seriesID) {
            return false;
        }
        if (this.m_groupID != xID.m_groupID) {
            return false;
        }
        return this.m_miscID == xID.m_miscID;
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public int getMiscID() {
        return this.m_miscID;
    }

    public int getObjectID() {
        return this.m_objectID;
    }

    public int getSeriesID() {
        return this.m_seriesID;
    }

    public boolean isGROUP_NA() {
        return this.m_groupID == -3;
    }

    public boolean isExceptional() {
        return ObjClassID.isExceptional(this.m_objectID);
    }

    public boolean isMISC_NA() {
        return this.m_miscID == -3;
    }

    public boolean isOBJECT_NA() {
        return this.m_objectID == -3;
    }

    public boolean isSERIES_NA() {
        return this.m_seriesID == -3;
    }

    public boolean isColorByHeightRelated() {
        boolean bByHeight;
        switch (this.m_objectID) {
            case 18: 
            case 1005: {
                bByHeight = true;
                break;
            }
            default: {
                bByHeight = false;
            }
        }
        return bByHeight;
    }

    public boolean canBeExceptional() {
        boolean bCanBeExceptional;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 500: 
            case 502: 
            case 503: 
            case 521: 
            case 542: 
            case 543: 
            case 547: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 561: 
            case 562: 
            case 1001: 
            case 1005: {
                bCanBeExceptional = true;
                break;
            }
            default: {
                bCanBeExceptional = false;
            }
        }
        return bCanBeExceptional;
    }

    public boolean isSeriesRelated() {
        boolean bSeries;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 500: 
            case 502: 
            case 503: 
            case 521: 
            case 542: 
            case 543: 
            case 547: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 561: 
            case 562: 
            case 703: 
            case 704: 
            case 1001: 
            case 1005: {
                bSeries = true;
                break;
            }
            default: {
                bSeries = false;
            }
        }
        return bSeries;
    }

    public boolean matches(IdentObj id) {
        boolean bMatches = true;
        if (this.m_objectID != id.m_objectID && this.m_objectID != -3 && id.m_objectID != -3) {
            bMatches = false;
        }
        if (this.m_seriesID != id.m_seriesID && this.m_seriesID != -3 && id.m_seriesID != -3) {
            bMatches = false;
        }
        if (this.m_groupID != id.m_groupID && this.m_groupID != -3 && id.m_groupID != -3) {
            bMatches = false;
        }
        if (this.m_miscID != id.m_miscID && this.m_miscID != -3 && id.m_miscID != -3) {
            bMatches = false;
        }
        return bMatches;
    }

    public boolean needsStripping() {
        boolean bNeedsStripping = false;
        switch (this.m_objectID) {
            case 14: 
            case 538: 
            case 541: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 563: 
            case 564: {
                bNeedsStripping = true;
            }
        }
        return bNeedsStripping;
    }

    public String toString() {
        return ObjClassID.getObjectName(this.m_objectID) + "(" + this.m_objectID + ", " + this.m_seriesID + ", " + this.m_groupID + ", " + this.m_miscID + ")";
    }
}

