/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import java.util.Comparator;

public class FaceHidingComparator
implements Comparator {
    private static final boolean DEBUG = false;
    private Point3d[] vertices;
    private double m_dMin = 0.0;
    private double m_dMax = 0.0;

    public FaceHidingComparator(Point3d viewer, Point3d[] verts) {
        if (verts == null || viewer == null) {
            throw new IllegalArgumentException("Null data");
        }
        for (int i = 0; i < verts.length; ++i) {
            if (verts[i] != null) continue;
            throw new IllegalArgumentException("Vertex is null");
        }
        this.vertices = verts;
    }

    public final void minMax(int[] face) {
        this.m_dMin = Double.POSITIVE_INFINITY;
        this.m_dMax = Double.NEGATIVE_INFINITY;
        int index = 0;
        double dd = 0.0;
        for (int i = 0; i < face.length; ++i) {
            index = face[i];
            dd = this.vertices[index].z;
            if (dd < this.m_dMin) {
                this.m_dMin = dd;
            }
            if (!(dd > this.m_dMax)) continue;
            this.m_dMax = dd;
        }
    }

    public final double averageZ(int[] face) {
        double dz = 0.0;
        int nLen = face.length;
        for (int i = 0; i < nLen; ++i) {
            dz += this.vertices[face[i]].z;
        }
        return dz / (double)nLen;
    }

    public int compareMinMax(int[] face1, int[] face2) {
        this.minMax(face1);
        double dMin1 = this.m_dMin;
        double dMax1 = this.m_dMax;
        this.minMax(face2);
        if (this.m_dMax < dMin1) {
            return 1;
        }
        if (dMax1 < this.m_dMin) {
            return -1;
        }
        return 0;
    }

    public int compare(Object obj1, Object obj2) {
        double z2;
        int[] face1 = (int[])obj1;
        int[] face2 = (int[])obj2;
        if (face1.length > 3) {
            return 1;
        }
        if (face2.length > 3) {
            return -1;
        }
        int nReturn = this.compareMinMax(face1, face2);
        if (nReturn != 0) {
            return nReturn;
        }
        double z1 = this.averageZ(face1);
        if (z1 < (z2 = this.averageZ(face2))) {
            return -1;
        }
        if (z2 < z1) {
            return 1;
        }
        return 0;
    }
}

