/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Cone3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.ShapeUtility;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class ConeView {
    private final boolean bDirectMethod = false;
    static double EPSILON = 1.0E-5;
    private static final double EPSILON2 = EPSILON * EPSILON;
    static String INVISIBLE = "INVISIBLE";
    static String BOTTOM_ONLY = "BOTTOM_ONLY";
    static String TOP_ONLY = "TOP_ONLY";
    static String TOP_SURROUNDED = "TOP_SURROUNDED";
    static String TOP_GENERAL = "TOP_GENERAL";
    static String SIDE_ONLY = "SIDE_ONLY";
    static String BOTTOM_GENERAL = "BOTTOM_GENERAL";
    private String viewType;
    JChart_3D m_chart;
    transient Point3d bottomCenter;
    private boolean isPreCalc = false;
    private double fViewAngleCos;
    private double fViewAngleSin;
    private double fViewRadius;
    private double fViewY;
    private transient Cone3D cone;
    private Point2D m_center = null;
    private Point2D[] m_rays = null;
    private Point2D[] m_points2D = null;
    transient Shape m_topEllipse = null;
    transient Shape m_bottomEllipse = null;
    private Point3d[] vertices = null;
    int nBottomCount = 0;
    int nTopCount = 0;
    int nContourCount = 5;

    public ConeView(Cone3D cone, JChart_3D chart, Point3d bottomCenter) {
        this.cone = cone;
        this.m_chart = chart;
        this.bottomCenter = bottomCenter;
        Point3d[] topPoints = cone.getTopPoints();
        this.nTopCount = topPoints.length;
        Point3d[] bottomPoints = cone.getBottomPoints();
        this.nBottomCount = bottomPoints.length;
        int nLen = bottomPoints.length + topPoints.length + 5;
        Point3d[] vert = new Point3d[nLen];
        int index = 0;
        int i = 0;
        while (i < bottomPoints.length) {
            vert[index] = bottomPoints[i];
            ++i;
            ++index;
        }
        i = 0;
        while (i < topPoints.length) {
            vert[index] = topPoints[i];
            ++i;
            ++index;
        }
        Point3d temp = vert[0];
        int i2 = 0;
        while (i2 < 5) {
            vert[index] = new Point3d(temp);
            ++i2;
            ++index;
        }
        this.vertices = vert;
    }

    public final double getViewerDistance() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        return this.fViewRadius;
    }

    public final Point3d[] getVertices() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        return this.vertices;
    }

    public final Object getViewType() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        return this.viewType;
    }

    public boolean isVisible() {
        return this.viewType != INVISIBLE;
    }

    public final boolean isCylinder() {
        return !FP.nonzero(this.cone.getTopRadius() - this.cone.getBottomRadius());
    }

    private void preCalc() {
        int i;
        Point3d viewer = this.m_chart.getViewerInWorldCoordinates();
        double fVX = viewer.x - this.bottomCenter.x;
        double fVY = viewer.y - this.bottomCenter.y;
        double fVZ = viewer.z - this.bottomCenter.z;
        double fViewRadius = Math.sqrt(fVX * fVX + fVZ * fVZ);
        boolean isRadiusZero = fViewRadius < EPSILON;
        this.fViewAngleCos = isRadiusZero ? 0.0 : fVX / fViewRadius;
        this.fViewAngleSin = isRadiusZero ? 0.0 : fVZ / fViewRadius;
        this.fViewRadius = fViewRadius;
        this.fViewY = fVY;
        double fBottomRadius = this.cone.getBottomRadius();
        double fCenterY = this.cone.getCenterY();
        double fHeight = this.cone.getHeight();
        boolean bAboveCenter = false;
        boolean bAboveTop = false;
        boolean bBelowBottom = true;
        if (fHeight > EPSILON) {
            bAboveCenter = this.fViewY > fCenterY + EPSILON;
            bAboveTop = this.fViewY > fHeight + EPSILON;
            bBelowBottom = this.fViewY < -EPSILON;
        } else if (fHeight < -EPSILON) {
            bAboveCenter = this.fViewY < fCenterY - EPSILON;
            bAboveTop = this.fViewY < fHeight - EPSILON;
            bBelowBottom = this.fViewY > EPSILON;
        }
        boolean bOutCone = false;
        if (Double.isInfinite(fCenterY)) {
            bOutCone = fViewRadius > fBottomRadius + EPSILON;
        } else {
            boolean bl = bOutCone = Math.abs(fCenterY * fViewRadius) > Math.abs(fVY * (fBottomRadius + EPSILON));
        }
        if (bOutCone) {
            this.calcContourPoints();
            this.viewType = bAboveTop ? TOP_GENERAL : (bBelowBottom ? BOTTOM_GENERAL : SIDE_ONLY);
        } else {
            this.viewType = bAboveCenter ? TOP_SURROUNDED : (bAboveTop ? TOP_ONLY : (bBelowBottom ? BOTTOM_ONLY : INVISIBLE));
        }
        if (this.viewType == INVISIBLE) {
            System.out.println("ConeView invisible for cone " + this.cone + "\nviewPoint in the users coords " + new Point3d(fVX, fVY, fVZ));
        } else {
            Matrix4d transWorldToCamera = this.m_chart.getMatrix();
            for (i = 0; i < this.vertices.length; ++i) {
                Point3d point = this.vertices[i];
                this.transformUserToWorld(point);
                transWorldToCamera.transformPoint3d(point, point);
            }
            this.isPreCalc = true;
            this.m_bottomEllipse = this.calcConeBottom();
            this.m_topEllipse = this.calcConeTop();
        }
        if (bOutCone) {
            this.m_rays = new Point2D.Double[2];
            this.m_points2D = new Point2D.Double[4];
            int nStart = this.nBottomCount + this.nTopCount;
            for (i = 0; i < 4; ++i) {
                this.m_points2D[i] = this.m_chart.projectPoint3dInDouble(this.vertices[nStart + i]);
            }
            this.m_rays[0] = new Point2D.Double(this.m_points2D[0].getX() - this.m_points2D[3].getX(), this.m_points2D[0].getY() - this.m_points2D[3].getY());
            this.m_rays[1] = new Point2D.Double(this.m_points2D[1].getX() - this.m_points2D[2].getX(), this.m_points2D[1].getY() - this.m_points2D[2].getY());
        }
    }

    final void calcContourPoints() {
        double fCircleRadius = 0.0;
        double fBottomRadius = this.cone.getBottomRadius();
        double fTopRadius = this.cone.getTopRadius();
        double fCenterY = this.cone.getCenterY();
        double fHeight = this.cone.getHeight();
        fCircleRadius = Double.isInfinite(fCenterY) ? fBottomRadius : (fCenterY - this.fViewY) * this.cone.getTanOfConeAngle();
        double dVisibleConeAngle = 0.0;
        dVisibleConeAngle = fCircleRadius > this.fViewRadius ? 0.0 : (fCircleRadius < -this.fViewRadius ? Math.PI : Math.acos(fCircleRadius / this.fViewRadius));
        double xx = fBottomRadius * Math.cos(dVisibleConeAngle);
        double zz = fBottomRadius * Math.sin(dVisibleConeAngle);
        Point3d bottomLeft = new Point3d(xx, 0.0, -zz);
        Point3d bottomRight = new Point3d(xx, 0.0, zz);
        xx = fTopRadius * Math.cos(dVisibleConeAngle);
        zz = fTopRadius * Math.sin(dVisibleConeAngle);
        Point3d topRight = new Point3d(xx, fHeight, zz);
        Point3d topLeft = new Point3d(xx, fHeight, -zz);
        this.rotatePoint(bottomLeft);
        this.rotatePoint(bottomRight);
        this.rotatePoint(topRight);
        this.rotatePoint(topLeft);
        int index = this.vertices.length - 5;
        this.vertices[index] = bottomLeft;
        this.vertices[++index] = bottomRight;
        this.vertices[++index] = topRight;
        this.vertices[++index] = topLeft;
        Point3d frontPoint = new Point3d(this.cone.getBottomRadius(), 0.0, 0.0);
        this.rotatePoint(frontPoint);
        this.vertices[++index] = frontPoint;
    }

    Point2D calcCenterPoint() {
        Point2D projectedPoint;
        double centerY = this.cone.getCenterY();
        if (Double.isInfinite(centerY)) {
            centerY = 1.7014117331926443E38;
        }
        Point3d point = new Point3d(0.0, centerY, 0.0);
        this.transformUserToWorld(point);
        Matrix4d transWorldToCamera = this.m_chart.getMatrix();
        transWorldToCamera.transformPoint3d(point, point);
        this.m_center = projectedPoint = this.m_chart.projectPoint3dInDouble(point);
        return projectedPoint;
    }

    Point2D getCenterPoint() {
        if (this.m_center != null) {
            return this.m_center;
        }
        return this.calcCenterPoint();
    }

    Point2D getLightDirection() {
        return new Point2D.Double(this.fViewAngleCos, this.fViewAngleSin);
    }

    public static Point2D[] calcLightPoints(Point2D.Double lightVec, Shape shape) {
        Point2D.Double[] returnPoints = null;
        double fMax = Double.NEGATIVE_INFINITY;
        double fMin = Double.POSITIVE_INFINITY;
        boolean bFirstTime = true;
        double[] p = new double[6];
        double xx = 0.0;
        double yy = 0.0;
        double fValue = 0.0;
        int nType = -1;
        double dFlatness = 1.0;
        PathIterator it = shape.getPathIterator(null, dFlatness);
        boolean bSkip = false;
        while (!it.isDone()) {
            bSkip = false;
            nType = it.currentSegment(p);
            switch (nType) {
                case 0: {
                    xx = p[0];
                    yy = p[1];
                    fValue = xx * lightVec.x + yy * lightVec.y;
                    if (!bFirstTime) break;
                    fMin = fMax = fValue;
                    Point2D.Double point1 = new Point2D.Double(xx, yy);
                    Point2D.Double point2 = new Point2D.Double(xx, yy);
                    returnPoints = new Point2D.Double[]{point1, point2};
                    bSkip = true;
                    bFirstTime = false;
                    break;
                }
                case 1: {
                    xx = p[0];
                    yy = p[1];
                    break;
                }
                case 2: {
                    xx = p[2];
                    yy = p[3];
                    break;
                }
                case 3: {
                    xx = p[3];
                    yy = p[4];
                    break;
                }
                default: {
                    bSkip = true;
                }
            }
            it.next();
            if (bSkip) continue;
            fValue = xx * lightVec.x + yy * lightVec.y;
            if (fValue > fMax) {
                fMax = fValue;
                returnPoints[0].x = xx;
                returnPoints[0].y = yy;
                continue;
            }
            if (!(fValue < fMin)) continue;
            fMin = fValue;
            returnPoints[1].x = xx;
            returnPoints[1].y = yy;
        }
        if (returnPoints == null) {
            ShapeUtility.write(shape);
            System.out.println("ConeView no points found ");
        }
        return returnPoints;
    }

    public static double calcGradientValue(double fX, double fStartX, double fEndX) {
        double fValue = 0.0;
        double fDeltaX = fEndX - fStartX;
        fValue = (fX - fStartX) / fDeltaX;
        if (fValue >= 0.0 && fValue <= 1.0) {
            return fValue;
        }
        if (fValue < 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    final void rotatePoint(Point3d point) {
        double fX = this.fViewAngleCos;
        double fZ = this.fViewAngleSin;
        double pointX = point.x;
        double pointZ = point.z;
        point.x = fX * pointX - fZ * pointZ;
        point.z = fZ * pointX + fX * pointZ;
    }

    final void transformUserToWorld(Point3d p) {
        p.x += this.bottomCenter.x;
        p.y += this.bottomCenter.y;
        p.z += this.bottomCenter.z;
    }

    public Shape getConeTop() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        return this.m_topEllipse;
    }

    private Shape calcConeTop() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        Point2D[] points = new Point2D[this.nTopCount];
        int nStart = this.nBottomCount;
        for (int i = 0; i < this.nTopCount; ++i) {
            points[i] = this.m_chart.projectPoint3dInDouble(this.vertices[nStart + i]);
        }
        GeneralPath path = new GeneralPath();
        Interpolation2D.createSmoothPath(path, Arrays.asList(points), true);
        return path;
    }

    protected Shape getConeBottom() {
        if (!this.isPreCalc) {
            this.preCalc();
        }
        return this.m_bottomEllipse;
    }

    private Shape calcConeBottom() {
        Point2D[] points = new Point2D[this.nBottomCount];
        for (int i = 0; i < this.nBottomCount; ++i) {
            points[i] = this.m_chart.projectPoint3dInDouble(this.vertices[i]);
        }
        GeneralPath path = new GeneralPath();
        Interpolation2D.createSmoothPath(path, Arrays.asList(points), true);
        return path;
    }

    Shape calcConeBody() {
        GeneralPath path = new GeneralPath();
        Interpolation2D.createPolygon(path, this.m_points2D, true);
        return path;
    }

    public boolean calcTessellationAreas(Area coneBody, int nFactor, double[] fX, Area[] tessArea, Point2D[] tessGradientPoint) {
        if (this.m_rays == null) {
            throw new RuntimeException(" Precalc before calling this method. ");
        }
        if (!FP.nonzero(this.m_rays[0].getY()) || !FP.nonzero(this.m_rays[1].getY())) {
            return false;
        }
        double fTemp = 0.0;
        double fDelta = 0.0;
        double fDeltaX = 0.0;
        double fDeltaY = 0.0;
        double fBottomY = 0.0;
        double fTangens = 0.0;
        double x0 = 0.0;
        double x1 = 0.0;
        double fs = 0.0;
        GeneralPath path = null;
        Rectangle2D rect = coneBody.getBounds2D();
        double fMaxY = rect.getMaxY();
        double fMinY = rect.getMinY();
        double fMinX = rect.getMinX();
        double fMaxX = rect.getMaxX();
        if (Math.abs(this.m_center.getY()) < FP.BIG && Math.abs(this.m_center.getX()) < FP.BIG) {
            boolean bCenterAboveCone = this.m_center.getY() > fMinY + FP.TOLERANCE;
            fBottomY = bCenterAboveCone ? fMinY : fMaxY;
            fDeltaY = fBottomY - this.m_center.getY();
            fTangens = this.m_rays[0].getX() / this.m_rays[0].getY();
            x0 = this.m_center.getX() + fDeltaY * fTangens;
            fTangens = this.m_rays[1].getX() / this.m_rays[1].getY();
            x1 = this.m_center.getX() + fDeltaY * fTangens;
            fTemp = x0;
            fDelta = (x1 - x0) / (double)(nFactor - 1);
            int i = 0;
            while (i < fX.length) {
                fX[i] = fTemp;
                fDeltaX = fTemp - this.m_center.getX();
                fs = Math.abs(fDeltaY) / Math.sqrt(fDeltaX * fDeltaX + fDeltaY * fDeltaY);
                tessGradientPoint[i] = new Point2D.Double(this.m_center.getX() + fs * fDeltaX, this.m_center.getY() + fs * fDeltaY);
                ++i;
                fTemp += fDelta;
            }
            for (int j = 0; j < tessArea.length; ++j) {
                path = new GeneralPath();
                path.moveTo((float)this.m_center.getX(), (float)this.m_center.getY());
                path.lineTo((float)fX[j], (float)fBottomY);
                path.lineTo((float)fX[j + 1], (float)fBottomY);
                path.closePath();
                tessArea[j] = new Area(path);
                tessArea[j].intersect(coneBody);
            }
        } else {
            fTangens = this.m_rays[0].getX() / this.m_rays[0].getY();
            double fTangens1 = this.m_rays[1].getX() / this.m_rays[1].getY();
            fDeltaX = (fMaxY - fMinY) * fTangens;
            if (fDeltaX > 0.0) {
                x0 = fMinX - fDeltaX;
                x1 = fMaxX;
                fBottomY = fMaxY;
            } else {
                x0 = fMinX;
                x1 = fMaxX - fDeltaX;
                fBottomY = fMinY;
            }
            fDelta = (x1 - x0) / (double)(nFactor - 1);
            fDeltaY = -fDelta * fTangens;
            fTemp = x0;
            int i = 0;
            while (i < fX.length) {
                fX[i] = fTemp;
                tessGradientPoint[i] = new Point2D.Double(fTemp, fBottomY += fDeltaY);
                ++i;
                fTemp += fDelta;
            }
            for (int j = 0; j < tessArea.length; ++j) {
                path = new GeneralPath();
                path.moveTo((float)fX[j], (float)fMinY);
                path.lineTo((float)(fX[j] + fDeltaX), (float)fMaxY);
                path.lineTo((float)(fX[j + 1] + fDeltaX), (float)fMaxY);
                path.lineTo((float)fX[j + 1], (float)fMinY);
                path.closePath();
                tessArea[j] = new Area(path);
                tessArea[j].intersect(coneBody);
            }
        }
        return true;
    }

    static Point2D.Double normalize(Point2D.Double p) {
        double norm = Math.sqrt(p.x * p.x + p.y * p.y);
        if (norm == 0.0) {
            return new Point2D.Double();
        }
        return new Point2D.Double(p.x / norm, p.y / norm);
    }

    static Point2D.Double getAngles(Point2D.Double[] rays) {
        Point2D.Double p = new Point2D.Double();
        p.x = Math.atan2(rays[0].y, rays[0].x);
        p.y = Math.atan2(rays[2].y, rays[2].x);
        return p;
    }

    static boolean findIntersectionOfLines(double P0x, double P0y, double D0x, double D0y, double P1x, double P1y, double D1x, double D1y, Point2D.Double Intersection) {
        double Ex = P1x - P0x;
        double Ey = P1y - P0y;
        double kross = D0x * D1y - D0y * D1x;
        double kross2 = kross * kross;
        double lenD02 = D0x * D0x + D0y * D0y;
        double lenD12 = D1x * D1x + D1y * D1y;
        if (kross2 < EPSILON2 * lenD02 * lenD12) {
            Intersection.setLocation(D0x, D0y);
            return true;
        }
        double s = (Ex * D1y - Ey * D1x) / kross;
        Intersection.setLocation(P0x + s * D0x, P0y + s * D0y);
        return false;
    }

    public Shape getEllipse(Point3d bb, Point3d cc, double R, double dScale, boolean isBottom) {
        double bbcc = bb.mult(cc);
        if (!FP.nonzero(bbcc)) {
            throw new RuntimeException("TO DO");
        }
        bb.x /= bbcc;
        bb.y /= bbcc;
        bb.z /= bbcc;
        double cc_RR = cc.mult(cc) - R * R;
        Matrix3d M = new Matrix3d();
        M.m00 = 1.0 + cc_RR * bb.x * bb.x - (cc.x * bb.x + cc.x * bb.x);
        M.m01 = 0.0 + cc_RR * bb.x * bb.y - (cc.x * bb.y + cc.y * bb.x);
        M.m02 = 0.0 + cc_RR * bb.x * bb.z - (cc.x * bb.z + cc.z * bb.x);
        M.m10 = M.m01;
        M.m11 = 1.0 + cc_RR * bb.y * bb.y - (cc.y * bb.y + cc.y * bb.y);
        M.m12 = 0.0 + cc_RR * bb.y * bb.z - (cc.y * bb.z + cc.z * bb.y);
        M.m20 = M.m02;
        M.m21 = M.m12;
        M.m22 = 1.0 + cc_RR * bb.z * bb.z - (cc.z * bb.z + cc.z * bb.z);
        double[] lambda = new double[2];
        AffineTransform trans = new AffineTransform();
        ConeView.diagonalize(M, lambda, trans);
        trans.scale(dScale, dScale);
        double cos = trans.getScaleX();
        double sin = trans.getShearX();
        double e0 = 2.0 * (cos * M.m02 - sin * M.m12);
        double e1 = 2.0 * (sin * M.m02 + cos * M.m12);
        double H = -M.m22 - 0.25 * (e0 * e0 / lambda[0] + e1 * e1 / lambda[1]);
        double h0 = Math.sqrt(H / lambda[0]);
        double h1 = Math.sqrt(H / lambda[1]);
        double c0 = 0.5 * e0 / lambda[0];
        double c1 = 0.5 * e1 / lambda[1];
        Ellipse2D.Double ellipse = new Ellipse2D.Double(c0 - h0, c1 - h1, h0 + h0, h1 + h1);
        Shape shape = trans.createTransformedShape(ellipse);
        return shape;
    }

    public static void diagonalize(Matrix3d M, double[] lambda, AffineTransform trans) {
        if (FP.nonzero(M.m01 - M.m10)) {
            throw new RuntimeException("Matrix + " + M + " not symmetrical.");
        }
        double bb = M.m00 + M.m11;
        double diff = M.m00 - M.m11;
        double delta = diff * diff + 4.0 * M.m01 * M.m01;
        lambda[0] = 0.5 * (bb + Math.sqrt(delta));
        lambda[1] = bb - lambda[0];
        double cos = -M.m01;
        double sin = M.m00 - lambda[0];
        double norm = Math.sqrt(cos * cos + sin * sin);
        if (!(norm > 0.0)) {
            throw new RuntimeException("Matrix + " + M + " is degenerated.");
        }
        trans.setTransform(cos /= norm, -(sin /= norm), sin, cos, 0.0, 0.0);
    }

    public static void testDiagonalize() {
        Matrix3d M = new Matrix3d();
        M.m10 = 1.0;
        M.m01 = 1.0;
        M.m00 = 5.0;
        M.m11 = 2.0;
        AffineTransform MM = new AffineTransform(M.m00, M.m01, M.m01, M.m11, 0.0, 0.0);
        double[] L = new double[2];
        AffineTransform tr = new AffineTransform();
        ConeView.diagonalize(M, L, tr);
        System.out.println("MM = " + MM);
        System.out.println("Eigenvalues:" + L[0] + "," + L[1] + "\nTr = " + tr);
        AffineTransform trInverse = null;
        try {
            trInverse = tr.createInverse();
        }
        catch (Exception ex) {
            System.out.println("Non invertible matrix " + tr);
            return;
        }
        tr.concatenate(MM);
        tr.concatenate(trInverse);
        System.out.println("\nDiagonalized matrix tr = " + tr);
        System.out.println("\nIt should be        tr = " + new AffineTransform(L[0], 0.0, 0.0, L[1], 0.0, 0.0));
    }
}

