/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ConeView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.FillRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ListOfLayersComposition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Shape_Layer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.sun.Position;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.ShapeUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConeTessellated {
    private static final double[] s_specularPosition = new double[]{0.0, 0.5, 0.6f, 0.7f, 1.0};
    private static final double[] s_position = new double[]{0.0, 0.45f, 0.5, 0.55f, 1.0};
    private static final Color[] s_colors = new Color[]{Color.black, Color.red, Color.white, Color.red, Color.black};
    private transient ConeView coneView = null;
    private transient IBlackBox m_bb = null;
    private transient Rectangle bounds = null;
    private Color highlightColor = s_colors[2];
    private Color midtoneColor = s_colors[1];
    private Color borderColor = s_colors[0];
    private FillGradientObj m_fillGradientObj = null;
    private Color mainTopColor = this.midtoneColor.brighter();
    private Color borderTopColor = this.midtoneColor.darker();
    private boolean m_bSpecularLightOn = true;
    private final int m_nFactor = 20;

    public FillGradientObj calcFillGradientObj() {
        if (this.m_fillGradientObj == null) {
            Color color0 = null;
            double[] position = null;
            if (this.m_bSpecularLightOn) {
                color0 = this.highlightColor;
                position = s_specularPosition;
            } else {
                color0 = this.midtoneColor.brighter();
                position = s_position;
            }
            Color[] colors = new Color[]{this.borderColor, this.midtoneColor, color0, this.midtoneColor, this.borderColor};
            this.m_fillGradientObj = new FillGradientObj(colors, position, 15);
        }
        return this.m_fillGradientObj;
    }

    public IBlackBox getBlackBox() {
        return this.m_bb;
    }

    public void setBlackBox(IBlackBox bb) {
        this.m_bb = bb;
        this.setSpecularLight(bb.isSpecularLight());
        Color color = bb.getFillColor();
        this.setMidtoneColor(color);
        this.setMainTopColor(color.brighter());
        this.setBorderTopColor(color.darker());
    }

    public boolean isSpecularLight() {
        return this.m_bSpecularLightOn;
    }

    public void setSpecularLight(boolean bOn) {
        if (this.m_bSpecularLightOn != bOn) {
            this.m_bSpecularLightOn = bOn;
            this.m_fillGradientObj = null;
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (!this.highlightColor.equals(color)) {
            this.highlightColor = color;
            this.m_fillGradientObj = null;
        }
    }

    public Color getMidtoneColor() {
        return this.midtoneColor;
    }

    public void setMidtoneColor(Color color) {
        if (!this.midtoneColor.equals(color)) {
            this.midtoneColor = color;
            this.m_fillGradientObj = null;
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (!this.borderColor.equals(color)) {
            this.borderColor = color;
            this.m_fillGradientObj = null;
        }
    }

    public Color getMainTopColor() {
        return this.mainTopColor;
    }

    public void setMainTopColor(Color color) {
        this.mainTopColor = color;
    }

    public Color getBorderTopColor() {
        return this.borderTopColor;
    }

    public void setBorderTopColor(Color color) {
        this.borderTopColor = color;
    }

    public void setConeView(ConeView coneView) {
        this.coneView = coneView;
    }

    final double getViewerDistance() {
        return this.coneView.getViewerDistance();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public ListOfLayersComposition build() {
        Area fullCone;
        boolean isSideVisible;
        if (this.coneView == null) {
            throw new IllegalArgumentException("ConeView instance is null.");
        }
        Object viewType = this.coneView.getViewType();
        Area coneBody = null;
        Area bottomEllipse = null;
        Area topEllipse = null;
        Shape visibleEllipse = null;
        boolean bl = isSideVisible = viewType == ConeView.TOP_GENERAL || viewType == ConeView.BOTTOM_GENERAL || viewType == ConeView.SIDE_ONLY;
        if (isSideVisible) {
            if (this.coneView.m_bottomEllipse != null) {
                bottomEllipse = new Area(this.coneView.m_bottomEllipse);
            }
            if (this.coneView.m_topEllipse != null) {
                topEllipse = new Area(this.coneView.m_topEllipse);
            }
            coneBody = new Area(this.coneView.calcConeBody());
            if (viewType == ConeView.TOP_GENERAL) {
                coneBody.subtract(topEllipse);
                coneBody.add(bottomEllipse);
                visibleEllipse = topEllipse;
            } else if (viewType == ConeView.BOTTOM_GENERAL) {
                coneBody.subtract(bottomEllipse);
                coneBody.add(topEllipse);
                visibleEllipse = bottomEllipse;
            } else if (viewType == ConeView.SIDE_ONLY) {
                if (topEllipse != null) {
                    coneBody.add(topEllipse);
                }
                if (bottomEllipse != null) {
                    coneBody.add(bottomEllipse);
                }
            }
        } else if (viewType == ConeView.TOP_ONLY) {
            visibleEllipse = this.coneView.getConeTop();
        } else if (viewType == ConeView.BOTTOM_ONLY) {
            visibleEllipse = this.coneView.getConeBottom();
        } else if (viewType == ConeView.TOP_SURROUNDED) {
            visibleEllipse = this.coneView.getConeBottom();
        }
        if (ShapeUtility.isEmpty(visibleEllipse)) {
            visibleEllipse = null;
        }
        if (ShapeUtility.isEmpty(coneBody)) {
            coneBody = null;
        }
        Area area = fullCone = visibleEllipse == null ? new Area() : new Area(visibleEllipse);
        if (coneBody != null) {
            fullCone.add(coneBody);
        }
        this.bounds = fullCone.getBounds();
        Dimension size = new Dimension(this.bounds.width, this.bounds.height);
        ListOfLayersComposition cmp = new ListOfLayersComposition(size);
        ArrayList<Shape_Layer> layersList = new ArrayList<Shape_Layer>();
        if (viewType == ConeView.INVISIBLE) {
            return cmp;
        }
        double angle = 1.5707963267948966;
        Point2D.Double lightVec = new Point2D.Double(Math.cos(angle), Math.sin(angle));
        Paint gradientPaint = null;
        FillRenderer renderer = null;
        if (isSideVisible && coneBody != null) {
            Point2D center = this.coneView.calcCenterPoint();
            Color[] tessColor = new Color[21];
            double[] fTessX = new double[21];
            Area[] tessArea = new Area[20];
            Point2D[] tessPoint = new Point2D[21];
            boolean isOK = this.coneView.calcTessellationAreas(coneBody, 20, fTessX, tessArea, tessPoint);
            if (!isOK) {
                gradientPaint = this.midtoneColor;
                renderer = new FillRenderer(gradientPaint);
                layersList.add(new Shape_Layer(cmp, coneBody, renderer, Position.CENTER));
            } else {
                double fStart = fTessX[0];
                this.m_fillGradientObj = this.calcFillGradientObj();
                for (int l = 0; l <= 20; ++l) {
                    tessColor[l] = this.m_fillGradientObj.getColorAt((double)l / 20.0);
                }
                Color fillColor = this.midtoneColor.darker();
                fillColor = fillColor.darker();
                fillColor = fillColor.darker();
                renderer = new FillRenderer(fillColor);
                layersList.add(new Shape_Layer(cmp, coneBody, renderer, Position.CENTER));
                for (int i = 0; i < 20; ++i) {
                    gradientPaint = new GradientPaint(tessPoint[i], tessColor[i], tessPoint[i + 1], tessColor[i + 1]);
                    renderer = new FillRenderer(gradientPaint);
                    layersList.add(new Shape_Layer(cmp, tessArea[i], renderer, Position.CENTER));
                }
            }
        }
        if (visibleEllipse != null) {
            Point2D[] points = ConeView.calcLightPoints(lightVec, visibleEllipse);
            if (points != null) {
                gradientPaint = new GradientPaint(points[0], this.borderTopColor, points[1], this.mainTopColor);
                renderer = new FillRenderer(gradientPaint);
                Shape_Layer lay = new Shape_Layer(cmp, visibleEllipse, renderer, Position.CENTER);
                layersList.add(lay);
            } else {
                System.out.println("ConeTessellated#build warning : visibleEllipse is empty." + ShapeUtility.shapeToString(visibleEllipse));
            }
        }
        ConeTessellated.setLayers(cmp, layersList);
        cmp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return cmp;
    }

    public static double calcHighlightX(Point2D center, double fRadius, Point2D lightRay) {
        return center.getX() + fRadius * (lightRay.getX() / lightRay.getY());
    }

    public static void calcTessellationColors(Color colorHigh, Color colorLow, double fHighLightX, double[] fX, Color[] tessColor) {
        float[] rgba1 = new float[3];
        float[] rgba2 = new float[3];
        double fDelta = 1.0f / (float)tessColor.length;
        float s1 = 0.0f;
        float s2 = 0.0f;
        for (int i = 0; i < tessColor.length; ++i) {
            if ((s1 = (float)((double)s1 + fDelta)) > 1.0f) {
                s1 = 1.0f;
            }
            s2 = 1.0f - s1;
            colorHigh.getRGBColorComponents(rgba1);
            colorLow.getRGBColorComponents(rgba2);
            float r = s1 * rgba1[0] + s2 * rgba2[0];
            float g = s1 * rgba1[1] + s2 * rgba2[1];
            float b = s1 * rgba1[2] + s2 * rgba2[2];
            tessColor[i] = new Color(r, g, b);
        }
    }

    public static void setLayers(ListOfLayersComposition cmp, List<Shape_Layer> layerList) {
        int nLen = layerList.size();
        Shape_Layer[] newL = new Shape_Layer[nLen];
        Iterator<Shape_Layer> it = layerList.iterator();
        for (int index = 0; index < nLen; ++index) {
            newL[index] = it.next();
        }
        cmp.setLayers(newL);
    }
}

