/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;

public final class Point3d {
    public double x;
    public double y;
    public double z;

    public Point3d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point3d(double xx, double yy, double zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public Point3d(Point3d p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public void copy(Point3d src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point3d)) {
            return false;
        }
        Point3d p2 = (Point3d)obj;
        boolean bEquals = FP.equal(this.x, p2.x) && FP.equal(this.y, p2.y) && FP.equal(this.z, p2.z);
        return bEquals;
    }

    public Point3d minus(Point3d p2) {
        return new Point3d(this.x - p2.x, this.y - p2.y, this.z - p2.z);
    }

    public Point3d minusMinus(Point3d p2) {
        this.x -= p2.x;
        this.y -= p2.y;
        this.z -= p2.z;
        return this;
    }

    public Point3d plus(Point3d p2) {
        return new Point3d(this.x + p2.x, this.y + p2.y, this.z + p2.z);
    }

    public Point3d plus(double d, Point3d p2) {
        return new Point3d(this.x + d * p2.x, this.y + d * p2.y, this.z + d * p2.z);
    }

    public Point3d plusPlus(Point3d p2) {
        this.x += p2.x;
        this.y += p2.y;
        this.z += p2.z;
        return this;
    }

    public Point3d plusPlus(double d, Point3d p2) {
        this.x += d * p2.x;
        this.y += d * p2.y;
        this.z += d * p2.z;
        return this;
    }

    public Point3d multMult(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public final double mult(Point3d p2) {
        return this.x * p2.x + this.y * p2.y + this.z * p2.z;
    }

    public final double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final void normalize() {
        double d = this.norm();
        if (FP.nonzero(d)) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
    }

    public String toString() {
        String s = "(" + this.x + ", " + this.y + ", " + this.z + ")";
        return s;
    }
}

