/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitPolynomial
implements ICurveFit {
    private static final int MAX_ORDER = 10;
    private int m_nOrder;

    public FitPolynomial(int nOrder) {
        assert (nOrder >= 1 && nOrder <= 10);
        this.m_nOrder = nOrder;
    }

    public double compute(double x, double[] a) {
        assert (a.length >= this.m_nOrder + 1 + 1);
        double y = a[1];
        for (int i = 1; i <= this.m_nOrder; ++i) {
            y += a[i + 1] * Math.pow(x, i);
        }
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= this.m_nOrder + 1 + 1);
        double product = 1.0;
        for (int i = 1; i <= this.m_nOrder + 1; ++i) {
            a[i] = product;
            product *= x;
        }
    }

    public int numCoeffs() {
        return this.m_nOrder + 1;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= this.m_nOrder + 1 + 1);
        String strEquation = "y = ";
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "x";
        if (!bHighOrderFirst) {
            strEquation = strEquation + strTerm2 + " + " + strTerm1;
            for (int i = 3; i <= this.m_nOrder + 1; ++i) {
                strEquation = strCoeffs[i] + "x^" + (i - 1) + " + " + strEquation;
            }
        } else {
            strEquation = strEquation + strTerm1 + " + " + strTerm2;
            for (int i = 3; i <= this.m_nOrder + 1; ++i) {
                strEquation = strEquation + " + " + strCoeffs[i] + "x^" + (i - 1);
            }
        }
        return strEquation;
    }
}

