/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectedLineEngine
implements ITrendlineEngine {
    private boolean isValid = false;
    private List<Point2D> dataSet;

    ConnectedLineEngine() {
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        this.dataSet = data;
        int validDataCount = 0;
        for (Point2D pt : data) {
            if (pt == null) continue;
            ++validDataCount;
        }
        if (validDataCount > 1) {
            this.isValid = true;
        }
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Point> vcPts = new ArrayList<Point>();
        for (Point2D pt : this.dataSet) {
            if (pt == null) continue;
            int x = dataProcessor.getXAxisCoord(seriesId, pt.getX());
            int y = dataProcessor.getYAxisCoord(seriesId, pt.getY());
            vcPts.add(new Point(x, y));
        }
        return vcPts;
    }

    @Override
    public String getEquationText(Format format) {
        return "";
    }

    @Override
    public String getCorrelationText(Format format) {
        return "";
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
    }
}

