/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IIntervalScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.ITimeScaleAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IntervalScaleFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

class TimeScaleAxis
extends Axis2DObj
implements ITimeScaleAxis {
    public static final int MAX_LEVELS = 3;
    private static final Logger _logger = Logger.getLogger((String)"TimeScaleAxis");
    private int[] _majorGridsTicks = null;
    private int[] _minorGridsTicks = null;
    private Rectangle[] _dataRects;
    private final IIntervalScale[] _level = new IIntervalScale[3];

    public TimeScaleAxis(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, minMax, bVertical, bAscending, nAxisOffset, nAxisSize, true);
        perspective.setDepthAngle(0);
        perspective.setDepthRadius(0);
    }

    public void calc() {
        GregorianCalendar start = new GregorianCalendar();
        GregorianCalendar end = new GregorianCalendar();
        start.setTimeInMillis((long)this.m_Perspective.getStartDate());
        end.setTimeInMillis((long)this.m_Perspective.getEndDate());
        int firstLevelInterval = this.m_Perspective.getLevelInterval(0);
        int q1StartMonth = this.m_Perspective.getQuarter1StartMonth();
        IIntervalScale data = IntervalScaleFactory.getIntervalScale(start, end, firstLevelInterval, firstLevelInterval, q1StartMonth);
        this._dataRects = this.getLevelRects(0, data.getOffsets());
        for (int i = 0; i < 3; ++i) {
            int interval = this.m_Perspective.getLevelInterval(i);
            if (interval == 0) continue;
            if (firstLevelInterval == 0) {
                firstLevelInterval = interval;
            }
            this._level[i] = IntervalScaleFactory.getIntervalScale(start, end, firstLevelInterval, interval, q1StartMonth);
            this.calcLevel(this._level[i], i);
        }
        int minorInterval = this.m_Perspective.getMinorGridTickInterval();
        IIntervalScale minorGridsTicksInterval = minorInterval == 0 ? this._level[0] : IntervalScaleFactory.getIntervalScale(start, end, firstLevelInterval, minorInterval, q1StartMonth);
        Rectangle[] minorRects = this.getLevelRects(0, minorGridsTicksInterval.getOffsets());
        int minorCount = minorGridsTicksInterval.getCount();
        this._minorGridsTicks = new int[minorCount];
        for (int i = 0; i < minorCount; ++i) {
            this._minorGridsTicks[i] = minorRects[i].x;
        }
        int majorInterval = this.m_Perspective.getMajorGridTickInterval();
        IIntervalScale majorGridsTicksInterval = majorInterval == 0 ? this._level[1] : IntervalScaleFactory.getIntervalScale(start, end, firstLevelInterval, majorInterval, q1StartMonth);
        if (majorGridsTicksInterval.getInterval() != 0) {
            Rectangle[] majorRects = this.getLevelRects(1, majorGridsTicksInterval.getOffsets());
            int majorCount = majorGridsTicksInterval.getCount();
            this._majorGridsTicks = new int[majorCount];
            for (int i = 0; i < majorCount; ++i) {
                this._majorGridsTicks[i] = majorRects[i].x;
            }
        }
        super.calc();
    }

    public Rectangle getAxisRect() {
        Rectangle r = new Rectangle();
        r.x = this._dataRects[0].x;
        r.y = this._dataRects[0].y;
        r.width = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, this.m_bVertScale);
        r.height = 0;
        for (int level = 0; level < 3; ++level) {
            int interval = this.m_Perspective.getLevelInterval(level);
            if (interval == 0) continue;
            r.height += this.m_Perspective.getLevelHeight(level);
        }
        return r;
    }

    public int getDataUnitWidth() {
        int w = this._dataRects[0].width;
        if (this._dataRects.length == 2) {
            w = Math.max(this._dataRects[0].width, this._dataRects[1].width);
        } else if (this._dataRects.length > 1) {
            w = this._dataRects[1].width;
        }
        return w;
    }

    public String[] getLabels(IIntervalScale interval, int format, int level) {
        String[] labels = null;
        if (format == -1) {
            double[] offsets = interval.getOffsets();
            int count = offsets.length;
            double diff = interval.getEnd().getTimeInMillis() - interval.getStart().getTimeInMillis();
            String dateFormat = this.m_Perspective.getLevelDateFormat(level);
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            int roundingFactor = 0;
            if (interval.getInterval() > 1) {
                roundingFactor = 1000;
            }
            labels = new String[count];
            long time = 0L;
            for (int i = 0; i < count; ++i) {
                labels[i] = formatter.format(new Date((time += (long)(diff * offsets[i]) + (long)roundingFactor) + interval.getStart().getTimeInMillis()));
            }
        } else {
            labels = interval.getLabels(format);
        }
        return labels;
    }

    public void calcLevel(IIntervalScale interval, int level) {
        double[] offsets = interval.getOffsets();
        int levelFormat = this.m_Perspective.getLevelTextFormat(level);
        String[] labels = this.getLabels(interval, levelFormat, level);
        Rectangle[] rects = this.getLevelRects(level, offsets);
        IdentObj boxId = this.m_Perspective.getTimeScaleLevel(level);
        IdentObj labelId = this.m_Perspective.getTimeScaleLevelText(level);
        for (int i = 0; i < offsets.length; ++i) {
            Rectangle rect = rects[i];
            BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, boxId);
            DrawFactory.createRectangle(this.m_Perspective.getDetectiv(), boxId, rect.x, rect.y, rect.width, rect.height, bbBox, null);
            BlackBoxObj lbBox = new BlackBoxObj(this.m_Perspective, labelId);
            ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, labelId);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), labelId, labels[i], rect, textStyle, lbBox, null);
        }
    }

    public double getValueCoord(double fValue) {
        int orgin = AxisUtils.getAxisOrgin(this.m_Perspective, this.m_template, this.m_bVertScale);
        double len = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, this.m_bVertScale);
        double start = this.m_Perspective.getStartDate();
        double end = this.m_Perspective.getEndDate();
        double offset = (fValue - start) / (end - start);
        double coord = len * offset + (double)orgin;
        if (_logger.isDebugEnabled()) {
            GregorianCalendar t = new GregorianCalendar();
            t.setTimeInMillis((long)fValue);
            _logger.debug((Object)("\ngetValueCoord fValue=" + fValue + "\ncoord=" + coord + "\noffset=" + offset + "\ntime=" + t.getTime() + "\nms=" + t.get(14)));
        }
        return coord;
    }

    private Rectangle[] getLevelRects(int level, double[] values) {
        int previousYOffset = 0;
        for (int i = 0; i < level; ++i) {
            previousYOffset += this.m_Perspective.getLevelHeight(i);
        }
        int orgin = AxisUtils.getAxisOrgin(this.m_Perspective, this.m_template, this.m_bVertScale);
        int len = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, this.m_bVertScale);
        Rectangle frameRect = AxisUtils.getFrameRect(this.m_Perspective, this.m_template, this.m_bVertScale);
        Rectangle frame = new Rectangle(frameRect.x, frameRect.y, frameRect.width, frameRect.height);
        Point frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        int levelHeight = this.m_Perspective.getLevelHeight(level);
        int y = frame.y - frameDepthOffset.y - previousYOffset - this.m_Perspective.getLevelHeight(level);
        int lastX = 0;
        int count = values.length;
        Rectangle[] rects = new Rectangle[count];
        for (int i = 0; i < count; ++i) {
            int x = orgin + lastX;
            int width = (int)((double)len * values[i]);
            rects[i] = new Rectangle(x, y, width, levelHeight);
            lastX += (int)(values[i] * (double)len);
        }
        rects[count - 1].width = len - rects[count - 1].x - Math.abs(orgin);
        return rects;
    }

    protected boolean getMajorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajorTick());
    }

    protected boolean getMinorTickDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinorTick());
    }

    protected int getNumMinorGrids() {
        int numMinorGrids = 0;
        if (this._minorGridsTicks != null) {
            numMinorGrids = this._minorGridsTicks.length;
        }
        return numMinorGrids;
    }

    protected double getMinorGridPos(int index) {
        int pos = 0;
        if (this._minorGridsTicks != null) {
            pos = this._minorGridsTicks[index];
        }
        return pos;
    }

    protected void calcMinorGrids() {
        SimpleBlackBoxObj blackbox = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMinor(), true);
        int nMisc = -3;
        double fPos = 0.0;
        int numMinorGrids = this.getNumMinorGrids();
        IdentObj id = this.m_template.getMinor();
        for (int gridIndex = 0; gridIndex < numMinorGrids; ++gridIndex) {
            IdentObj newID = id.changeMisc(nMisc++);
            fPos = this.getMinorGridPos(gridIndex);
            this.calcMinorGridLine(newID, fPos, blackbox);
        }
    }

    protected void calcMinorTickLine(double fRelPos) {
        int nPosVC = (int)fRelPos;
        this.m_minorTicks.calc(nPosVC);
    }

    protected void calcMajorTickLine(double fRelPos) {
        int nPosVC = (int)fRelPos;
        this.m_majorTicks.calc(nPosVC);
    }

    protected void calcMinorTicks() {
        double fPos = 0.0;
        int numMinorGrids = this.getNumMinorGrids();
        for (int gridIndex = 0; gridIndex < numMinorGrids; ++gridIndex) {
            fPos = this.getMinorGridPos(gridIndex);
            this.calcMinorTickLine(fPos);
        }
    }

    public int getNumMajorGrids() {
        int numMajorGrids = 0;
        if (this._majorGridsTicks != null) {
            numMajorGrids = this._majorGridsTicks.length;
        }
        return numMajorGrids;
    }

    public double getMajorGridPos(int index) {
        int pos = 0;
        if (this._majorGridsTicks != null) {
            pos = this._majorGridsTicks[index];
        }
        return pos;
    }

    protected int getNumLabels() {
        return 0;
    }

    public void calcLabels() {
        if (this.m_Perspective.getX1TitleDisplay()) {
            IdentObj titleId = Identity.X1Title;
            String titleStr = this.m_Perspective.getX1TitleString();
            BlackBoxObj titleBlackBox = new BlackBoxObj(this.m_Perspective, titleId);
            ITextStyle titleTextStyle = this.getTitleTextStyle(0, titleId);
            Rectangle rTitleVC = this.getAxisRect();
            Dimension titleWidthAndHeightVC = null;
            titleWidthAndHeightVC = TextUtil.getTextDimensionVC(this.m_Perspective, titleId, titleStr);
            rTitleVC.y -= rTitleVC.height + 500;
            rTitleVC.height = titleWidthAndHeightVC.height;
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), titleId, titleStr, rTitleVC, titleTextStyle, titleBlackBox, null);
        }
    }
}

