/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataTextPosition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Scaling;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IGanttAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.Format;

public class JChart_2D_Gantt
extends JChart_2D {
    public static final int TASK_UNLINKED = -1;
    public static final int TASK_NOTROLLEDUP = -1;
    public static final int TASK_STARTDATE = 0;
    public static final int TASK_STOPDATE = 1;
    public static final int TASK_PERCENT_COMPLETE = 2;
    public static final int TASK_SECOND_STARTDATE = 3;
    public static final int TASK_SECOND_STOPDATE = 4;
    public static final int TASK_CHILDLINKLINE = 5;
    public static final int TASK_PARENT_IF_ROLLEDUP = 6;
    private IGanttAxis m_taskObj;
    private IOrdinalAxis m_taskAxis;
    private INumericAxis m_timeAxisStandard;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Gantt(perspective);
        }
    };

    private JChart_2D_Gantt(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
        this.calcUsingStandardAxis();
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        return dataTextTemplate;
    }

    protected void calcUsingStandardAxis() {
        this.m_DataLabels = new DataLabels(this.m_Perspective);
        this.m_taskAxis = this.createOrdinalAxis();
        this.m_timeAxisStandard = this.createTimeAxis();
        this.m_taskAxis.calc();
        this.m_timeAxisStandard.calc();
        this.m_taskObj = AxisFactory.createGanttEngine(this.m_Perspective, this.m_timeAxisStandard, this.m_taskAxis, this.getDataView(), this.wantDepthEffect() ? this.m_depth2D : null);
        this.m_taskObj.calc(this.m_timeAxisStandard.getMinCoord(), this.m_timeAxisStandard.getMaxCoord(), this.m_Perspective.getCurrentDate());
        this.calcDataLabels();
        if (!this.m_Perspective.getPDECalc()) {
            this.m_taskAxis.calcAxisBody();
            this.getFrame().drawFrameBorders(this.m_Perspective.getLineWidth(Identity.Frame));
            this.m_timeAxisStandard.calcAxisBody();
            this.m_taskObj.drawAllTasks();
            this.m_taskObj.drawAllLinks();
            this.m_taskObj.drawAllRollups();
            this.drawDataLabels();
        }
    }

    private IOrdinalAxis createOrdinalAxis() {
        return AxisFactory.create2DOrdinalAxis(this.m_Perspective, this.m_Perspective.getAccess(), AxisTemplate.O1_AXIS, 1, true, false);
    }

    private INumericAxis createTimeAxis() {
        Scaling scaleNew = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
        MinMaxObj minMaxObj = scaleNew.findLimits(0, 7, false, null, this.getDataView().getDataFormat());
        boolean isAscending = !this.m_Perspective.getY1AxisDescending();
        int axisSide = this.m_Perspective.getY1AxisSide();
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.m_Perspective.getAccess(), AxisTemplate.Y1_AXIS, minMaxObj, false, isAscending, axisSide, 100, true);
    }

    public IAxis getTaskAxis() {
        return this.m_taskAxis;
    }

    public IAxis getTimeAxis() {
        return this.m_timeAxisStandard;
    }

    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int nDataTextPositionSecondary, Dimension dimLabel) {
        double start = this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STARTDATE, false);
        int baseCoord = (int)this.m_timeAxisStandard.getValueCoord(start);
        DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nDataTextPositionSecondary, this.m_Perspective.getJGraphType(), this.getFrame().getDepthOffset(1.0), baseCoord, this.getCoords(s, g), 0, dimLabel, this.m_depth2D.getSeriesFrontOffset(0), 1.0, 0.0, 0.0, true, !this.m_Perspective.getY1AxisDescending(), this.m_Perspective.getDataTextAngle(s, g), this.m_Perspective.getDataTextRadius(s, g), false, 0, false, false);
        return dataTextPos.calcPosition();
    }

    protected Point getCoords(int s, int g) {
        int center = (int)this.m_taskAxis.getCenterCoord(g);
        double stop = this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STOPDATE, false);
        int high = (int)this.m_timeAxisStandard.getValueCoord(stop);
        return new Point(high, center);
    }

    protected void calcDataLabels() {
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                if (!this.m_DataLabels.wantDataLabel(s, g)) continue;
                double startDate = this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STARTDATE, false);
                double stopDate = this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STOPDATE, false);
                long value = DateUtils.diff((long)startDate, (long)stopDate, 4);
                this.m_DataLabels.setDataValue(value, s, g);
                this.m_DataLabels.setDataText(this.getDataString(value, s, g), s, g);
            }
        }
    }

    protected String getDataString(double value, int s, int g) {
        String template = this.m_Perspective.getDataTextTemplate(s, g);
        Format format = this.getTimeAxis().getDataTextFormat();
        String resultString = format.format(value);
        resultString = TextUtil.ReplaceMacro(template, "[TIME]", resultString);
        resultString = TextUtil.ReplaceMacro(resultString, "[TASK]", this.m_Perspective.getGroupLabel(g));
        String start = format.format(this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STARTDATE, false));
        String stop = format.format(this.getDataView().getDataAsDouble(s, g, DataItem.DI_GANTT_STOPDATE, false));
        resultString = TextUtil.ReplaceMacro(resultString, "[START]", start);
        resultString = TextUtil.ReplaceMacro(resultString, "[STOP]", stop);
        return resultString;
    }

    public IAxis getAxis(int axisId) {
        if (axisId == 514) {
            return this.getTaskAxis();
        }
        return this.getTimeAxis();
    }
}

