/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBlackBoxObj
implements IBlackBox {
    private Perspective m_Perspective;
    private IdentObj m_id;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    private Color m_borderColor;
    private Color m_fillColor;
    private BasicStroke m_simpleStroke;
    private boolean m_isSpecular;
    private double m_intensity = 1.0;

    public SimpleBlackBoxObj(Perspective p, IdentObj id, boolean bWantRiserBorder) {
        this.m_Perspective = p;
        this.m_id = id;
        this.m_simpleStroke = new BasicStroke((float)Math.max((double)p.getMinLineWidthDC(id), p.ptsWidthToDC(0.75)));
        this.m_bTransparentBorderColor = !bWantRiserBorder || this.m_Perspective.getTransparentBorderColor(id);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(id);
        this.m_borderColor = this.m_bTransparentBorderColor ? null : this.m_Perspective.getBorderColor(id);
        this.m_fillColor = this.m_bTransparentFillColor ? null : this.m_Perspective.getFillColor(id);
        this.m_isSpecular = this.m_Perspective.getSpecularLight();
    }

    @Override
    public Object clone(Object obj) {
        if (!(obj instanceof SimpleBlackBoxObj)) {
            return null;
        }
        SimpleBlackBoxObj sbbObj = (SimpleBlackBoxObj)obj;
        SimpleBlackBoxObj newSbbObj = new SimpleBlackBoxObj(sbbObj.m_Perspective, sbbObj.m_id, false);
        newSbbObj.copy(sbbObj);
        return newSbbObj;
    }

    public void copy(SimpleBlackBoxObj bb) {
        this.m_Perspective = bb.m_Perspective;
        this.m_id = bb.m_id;
        this.m_bTransparentBorderColor = bb.m_bTransparentBorderColor;
        this.m_bTransparentFillColor = bb.m_bTransparentFillColor;
        this.m_borderColor = bb.m_borderColor;
        this.m_fillColor = bb.m_fillColor;
        this.m_simpleStroke = bb.m_simpleStroke;
        this.m_isSpecular = bb.m_isSpecular;
        this.m_intensity = bb.m_intensity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleBlackBoxObj)) {
            return false;
        }
        SimpleBlackBoxObj bb2 = (SimpleBlackBoxObj)obj;
        boolean bEqual = this.m_bTransparentBorderColor == bb2.m_bTransparentBorderColor && this.m_bTransparentFillColor == bb2.m_bTransparentFillColor && this.m_borderColor.equals(bb2.m_borderColor) && this.m_fillColor.equals(bb2.m_fillColor);
        this.m_borderColor.equals(bb2.m_borderColor);
        return bEqual;
    }

    @Override
    public Color getBorderColor() {
        return this.m_borderColor;
    }

    @Override
    public Color getFillColor() {
        return this.m_fillColor;
    }

    @Override
    public boolean isSpecularLight() {
        return this.m_isSpecular;
    }

    @Override
    public boolean copyGradientColors(List<ColorPinObj> list) {
        return false;
    }

    @Override
    public int getFillType() {
        return 1;
    }

    @Override
    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    @Override
    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    @Override
    public void setTransparentFillColor(boolean bTransparent) {
        this.m_bTransparentFillColor = bTransparent;
    }

    @Override
    public void setTransparentBorderColor(boolean bTransparent) {
        this.m_bTransparentBorderColor = bTransparent;
    }

    @Override
    public void paintLine(Graphics2D g, Point pt1, Point pt2, Stroke penStroke) {
        Java2DLine.paintLine(g, this.m_borderColor, pt1, pt2, penStroke);
    }

    @Override
    public void paintPolygon(Graphics2D g2, Polygon p) {
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.m_simpleStroke);
        if (!this.m_bTransparentFillColor) {
            this.setFill(g2, this.m_fillColor);
            g2.fillPolygon(p);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.drawPolygon(p);
        }
        g2.setStroke(stroke);
    }

    private void setFill(Graphics2D g2, Color color) {
        double fR = (double)color.getRed() * this.m_intensity;
        double fG = (double)color.getGreen() * this.m_intensity;
        double fB = (double)color.getBlue() * this.m_intensity;
        g2.setColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB)));
    }

    @Override
    public void paintRect(Graphics2D g2, Rectangle r) {
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.m_simpleStroke);
        if (!this.m_bTransparentFillColor) {
            this.setFill(g2, this.m_fillColor);
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.drawRect(r.x, r.y, r.width, r.height);
        }
        g2.setStroke(stroke);
    }

    @Override
    public void paintRectDotted(Graphics2D g, Rectangle r, boolean bNoFill, boolean bDotted) {
        this.paintRect(g, r, bNoFill);
    }

    @Override
    public void paintRect(Graphics2D g2, Rectangle r, boolean bNoFill) {
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.m_simpleStroke);
        if (!this.m_bTransparentFillColor && !bNoFill) {
            this.setFill(g2, this.m_fillColor);
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.drawRect(r.x, r.y, r.width, r.height);
        }
        g2.setStroke(stroke);
    }

    @Override
    public void paintOval(Graphics2D g2, Rectangle r, boolean bNoFill) {
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.m_simpleStroke);
        if (!this.m_bTransparentFillColor && !bNoFill) {
            this.setFill(g2, this.m_fillColor);
            g2.fillOval(r.x, r.y, r.width, r.height);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.drawOval(r.x, r.y, r.width, r.height);
        }
        g2.setStroke(stroke);
    }

    @Override
    public void setBorderColor(Color color) {
        this.m_borderColor = color == null ? null : new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void setFillColor(Color color) {
        this.m_fillColor = color;
        this.m_intensity = 1.0;
    }

    @Override
    public Image getTexture() {
        return null;
    }

    @Override
    public Color getGradientColorAt(double relValue) {
        return null;
    }

    @Override
    public Dimension getDropShadowOffset() {
        return null;
    }

    @Override
    public Color getDropShadowColor() {
        return null;
    }

    public IdentObj getIdentObjID() {
        return null;
    }

    @Override
    public int getGradientDirection() {
        return 1;
    }

    @Override
    public FillGradientObj getFillGradientObj() {
        return null;
    }

    @Override
    public void paintArc2D(Graphics2D g2D, Arc2D arc2D) {
        if (!this.m_bTransparentBorderColor) {
            Stroke stroke = g2D.getStroke();
            g2D.setStroke(this.m_simpleStroke);
            Color fg3D = this.m_borderColor;
            this.setFill(g2D, fg3D);
            g2D.setStroke(stroke);
            g2D.draw(arc2D);
            g2D.setStroke(stroke);
        }
    }

    @Override
    public void paintShape(Graphics2D g, Shape shapeDC) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void setRenderingTweaks(IdentObj id) {
    }

    @Override
    public void setBorderProperties(IdentObj objectID) {
        this.m_borderColor = this.m_Perspective.getBorderColor(objectID);
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(objectID);
    }

    @Override
    public Stroke getPenStroke() {
        return this.m_simpleStroke;
    }

    @Override
    public void setIntensity(double intensity) {
        this.m_intensity = intensity;
    }

    @Override
    public double getIntensity() {
        return this.m_intensity;
    }

    @Override
    public void setAnchorRect(Rectangle2D anchor) {
    }

    @Override
    public void setHighlightColor(Color highlight) {
        this.setFillColor(highlight);
    }
}

