/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillObj;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

abstract class FillSfxObj
extends FillObj {
    public Image createOvalMask(Rectangle r) {
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = img.createGraphics();
        gos.setColor(new Color(0, 0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255, 255));
        gos.fillOval(0, 0, r.width, r.height);
        gos.dispose();
        return img;
    }

    protected Image createPolygonMask(Polygon poly) {
        Rectangle r = poly.getBounds();
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)((Image)img).getGraphics();
        gos.setColor(new Color(0, 0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255, 255));
        gos.translate(-r.x, -r.y);
        if (this.internalBorderThickness != 0.0) {
            gos.setStroke(new BasicStroke((float)this.internalBorderThickness, 1, 1));
            gos.draw(poly);
        }
        gos.fillPolygon(poly);
        gos.dispose();
        return img;
    }

    public Image createShapeMask(Shape shape) {
        Rectangle r = shape.getBounds();
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)((Image)img).getGraphics();
        gos.setColor(new Color(0, 0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255, 255));
        gos.translate(-r.x, -r.y);
        if (this.internalBorderThickness != 0.0) {
            gos.setStroke(new BasicStroke((float)this.internalBorderThickness, 1, 1));
            gos.draw(shape);
        }
        gos.fill(shape);
        gos.dispose();
        return img;
    }

    public void fillOval(Graphics2D g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Rectangle r = new Rectangle(x, y, width, height);
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = img.createGraphics();
        this.fillSfxRect(gos, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(null, g, img, this.createOvalMask(r), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics2D g, int[] nXPoints, int[] nYPoints, int nPoints) {
        Polygon poly = new Polygon(nXPoints, nYPoints, nPoints);
        Rectangle r = poly.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = img.createGraphics();
        this.fillSfxRect(gos, 0, 0, r.width, r.height);
        this.applyFilter(null, g, img, this.createPolygonMask(poly), r, r, null);
        img.flush();
        gos.dispose();
    }

    public void fillShape(Graphics2D g, Shape shape) {
        if (shape == null) {
            return;
        }
        Rectangle r = shape.getBounds();
        BufferedImage img = Perspective.createOffscreenImage(r.width, r.height);
        Graphics2D gos = img.createGraphics();
        this.fillSfxRect(gos, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(null, g, img, this.createShapeMask(shape), r, r, null);
        img.flush();
    }

    public void fillRect(Graphics2D g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        BufferedImage img = Perspective.createOffscreenImage(width, height);
        Graphics2D gos = img.createGraphics();
        this.fillSfxRect(gos, 0, 0, width, height);
        gos.dispose();
        g.drawImage((Image)img, x, y, null);
        img.flush();
    }

    public abstract void copy(FillObj var1);

    protected abstract void fillSfxRect(Graphics2D var1, int var2, int var3, int var4, int var5);
}

