/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinStripeObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillSfxObj;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillGradientObj
extends FillSfxObj {
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int DOWN = 3;
    public static final int UP = 4;
    public static final int DOWN_LEFT = 5;
    public static final int UP_LEFT = 6;
    public static final int DOWN_RIGHT = 7;
    public static final int UP_RIGHT = 8;
    public static final int RADIAL = 9;
    public static final int RADIAL_TOPLEFT = 10;
    public static final int RADIAL_TOPRIGHT = 11;
    public static final int RADIAL_BOTTOMLEFT = 12;
    public static final int RADIAL_BOTTOMRIGHT = 13;
    public static final int RECTANGULAR = 14;
    public static final int TWO_POINTS = 15;
    public static final int GRADIENT_MAX = 15;
    private static final Point2D.Double s_ptStart = new Point2D.Double();
    private static final Point2D.Double s_ptEnd = new Point2D.Double(1.0, 0.0);
    private static final FillGradientObj s_fillGradientObj;
    private int m_nDirection;
    private ColorPinStripeObj m_ColorStripe;
    private Point2D m_startPt = new Point2D.Double();
    private Point2D m_endPt = new Point2D.Double(1.0, 0.0);
    private Rectangle2D m_anchorRect = null;

    public FillGradientObj(Color[] colors, double[] stopPoints, int nDirection) {
        this.m_ColorStripe = new ColorPinStripeObj(colors, stopPoints);
        this.m_nDirection = nDirection;
    }

    public FillGradientObj(ColorPinStripeObj colorStripe, Point2D.Double startPt, Point2D.Double endPt) {
        this.m_ColorStripe = colorStripe;
        this.m_startPt = startPt;
        this.m_endPt = endPt;
        this.m_nDirection = 15;
    }

    public FillGradientObj(int nGradientDirection) {
        this.m_ColorStripe = new ColorPinStripeObj();
        this.m_nDirection = nGradientDirection;
    }

    public static FillGradientObj getInstance() {
        return s_fillGradientObj;
    }

    @Override
    public void copy(FillObj fo) {
        if (!(fo instanceof FillGradientObj)) {
            return;
        }
        FillGradientObj fgo = (FillGradientObj)fo;
        this.m_nDirection = fgo.m_nDirection;
        this.m_ColorStripe.copy(fgo.m_ColorStripe);
        if (this.m_nDirection == 15) {
            this.m_startPt = (Point2D)fgo.m_startPt.clone();
            this.m_endPt = (Point2D)fgo.m_endPt.clone();
        }
    }

    public void setStartPt(double fx, double fy) {
        this.m_startPt = new Point2D.Double(fx, fy);
    }

    public void setEndPt(double fx, double fy) {
        this.m_endPt = new Point2D.Double(fx, fy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        FillGradientObj fgo = null;
        if (obj instanceof FillGradientObj) {
            fgo = (FillGradientObj)obj;
            return this.m_nDirection == fgo.m_nDirection && this.m_ColorStripe.equals(fgo.m_ColorStripe);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.m_nDirection;
        result = result * 37 + this.m_ColorStripe.hashCode();
        return super.hashCode();
    }

    public final Paint createGradientPaint(double fIntensity) {
        Point2D ptStart = this.m_startPt == null ? s_ptStart : this.m_startPt;
        Point2D ptEnd = this.m_endPt == null ? s_ptEnd : this.m_endPt;
        return this.m_ColorStripe.createGradientPaint(ptStart, ptEnd, fIntensity);
    }

    public final Paint createGradientPaint(Point2D ptStart, Point2D ptEnd) {
        return this.m_ColorStripe.createGradientPaint(ptStart, ptEnd, 1.0);
    }

    public final Paint createGradientPaint(Point2D ptStart, Point2D ptEnd, double fIntensity) {
        return this.m_ColorStripe.createGradientPaint(ptStart, ptEnd, fIntensity);
    }

    public final FillGradientObj restrictColorStripe(Point2D.Double ptStart, double fStart, Point2D.Double ptEnd, double fEnd) {
        ColorPinStripeObj newColorStripe = this.m_ColorStripe.restrictColorStripe(ptStart, fStart, ptEnd, fEnd);
        return new FillGradientObj(newColorStripe, ptStart, ptEnd);
    }

    public final Paint createRadialGradientPaint(Rectangle2D bounds) {
        return this.m_ColorStripe.createRadialGradientPaint(bounds, 1.0);
    }

    public final Paint createRadialGradientPaint(Rectangle2D bounds, double fIntensity) {
        return this.m_ColorStripe.createRadialGradientPaint(bounds, fIntensity);
    }

    private void downGradient(Graphics2D g, int x, int y, int width, int height) {
        int xmax = x + width;
        int ymax = y + height;
        for (int i = y; i < ymax; ++i) {
            Color color = this.m_ColorStripe.getColorAt((double)(i - y) / (double)height);
            g.setColor(color);
            g.drawLine(x, i, xmax, i);
        }
    }

    private void downLeftGradient(Graphics2D g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        for (int i = 0; i < nExtMax; ++i) {
            double fCoef = (double)i / (double)nExtMax;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            xPoint[0] = (int)((double)width - fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x + width;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] + 5;
            g.drawPolygon(xPoint, yPoint, 4);
        }
    }

    private void downRightGradient(Graphics2D g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        for (int i = 0; i < nExtMax; ++i) {
            double fCoef = (double)i / (double)nExtMax;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            xPoint[0] = (int)(fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] - 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] - 5;
            g.drawPolygon(xPoint, yPoint, 4);
        }
    }

    @Override
    public void fillShape(Graphics2D g2D, Shape shape) {
        this.fillShape(g2D, shape, 1.0);
    }

    public void fillShape(Graphics2D g2D, Shape shape, double fIntensity) {
        Rectangle2D bounds = this.m_anchorRect != null ? this.m_anchorRect : shape.getBounds();
        Rectangle2D.Double radialBounds = null;
        Point2D ptStart = this.m_startPt;
        Point2D ptEnd = this.m_endPt;
        if (this.m_nDirection != 15) {
            double fRight = bounds.getMaxX();
            double fLeft = bounds.getMinX();
            double fDown = bounds.getMaxY();
            double fUp = bounds.getMinY();
            double fH = bounds.getHeight();
            double fW = bounds.getWidth();
            switch (this.m_nDirection) {
                case 1: {
                    ptStart = new Point2D.Double(fLeft, fDown);
                    ptEnd = new Point2D.Double(fRight, fDown);
                    break;
                }
                case 2: {
                    ptStart = new Point2D.Double(fRight, fDown);
                    ptEnd = new Point2D.Double(fLeft, fDown);
                    break;
                }
                case 3: {
                    ptStart = new Point2D.Double(fLeft, fUp);
                    ptEnd = new Point2D.Double(fLeft, fDown);
                    break;
                }
                case 4: {
                    ptStart = new Point2D.Double(fLeft, fDown);
                    ptEnd = new Point2D.Double(fLeft, fUp);
                    break;
                }
                case 5: {
                    ptStart = new Point2D.Double(fRight, fUp);
                    ptEnd = new Point2D.Double(fLeft, fDown);
                    break;
                }
                case 6: {
                    ptStart = new Point2D.Double(fRight, fDown);
                    ptEnd = new Point2D.Double(fLeft, fUp);
                    break;
                }
                case 7: {
                    ptStart = new Point2D.Double(fLeft, fUp);
                    ptEnd = new Point2D.Double(fRight, fDown);
                    break;
                }
                case 8: {
                    ptStart = new Point2D.Double(fLeft, fDown);
                    ptEnd = new Point2D.Double(fRight, fUp);
                    break;
                }
                case 9: {
                    radialBounds = new Rectangle2D.Double(fLeft, fUp, fW, fH);
                    break;
                }
                case 10: {
                    radialBounds = new Rectangle2D.Double(2.0 * fLeft - fRight, 2.0 * fUp - fDown, fW + fW, fH + fH);
                    break;
                }
                case 11: {
                    radialBounds = new Rectangle2D.Double(fLeft, 2.0 * fUp - fDown, fW + fW, fH + fH);
                    break;
                }
                case 12: {
                    radialBounds = new Rectangle2D.Double(2.0 * fLeft - fRight, fUp, fW + fW, fH + fH);
                    break;
                }
                case 13: {
                    radialBounds = new Rectangle2D.Double(fLeft, fUp, fW + fW, fH + fH);
                }
            }
        }
        Paint gradient = radialBounds == null ? this.createGradientPaint(ptStart, ptEnd, fIntensity) : this.createRadialGradientPaint(radialBounds, fIntensity);
        g2D.setPaint(gradient);
        g2D.draw(shape);
        g2D.fill(shape);
    }

    @Override
    public void fillArc(Graphics2D g2D, Arc2D arc2D) {
        double fX1 = arc2D.getX();
        double fY1 = arc2D.getY();
        double fX2 = fX1 + arc2D.getWidth();
        double fY2 = fY1 + arc2D.getHeight();
        Color firstColor = this.m_ColorStripe.getColorAt(0.0);
        Color secondColor = this.m_ColorStripe.getColorAt(1.0);
        GradientPaint gradient = new GradientPaint((float)fX1, (float)fY1, firstColor, (float)fX2, (float)fY2, secondColor);
        g2D.setPaint(gradient);
        g2D.fill(arc2D);
    }

    @Override
    public void fillSfxRect(Graphics2D g, int x, int y, int width, int height) {
        switch (this.m_nDirection) {
            case 1: {
                this.rightGradient(g, x, y, width, height);
                break;
            }
            case 2: {
                this.leftGradient(g, x, y, width, height);
                break;
            }
            case 3: {
                this.downGradient(g, x, y, width, height);
                break;
            }
            case 4: {
                this.upGradient(g, x, y, width, height);
                break;
            }
            case 9: {
                this.radialGradient(g, x, y, width, height);
                break;
            }
            case 5: {
                this.downLeftGradient(g, x, y, width, height);
                break;
            }
            case 6: {
                this.upLeftGradient(g, x, y, width, height);
                break;
            }
            case 7: {
                this.downRightGradient(g, x, y, width, height);
                break;
            }
            case 8: {
                this.upRightGradient(g, x, y, width, height);
                break;
            }
            case 10: {
                this.radialTopLeftGradient(g, x, y, width, height);
                break;
            }
            case 11: {
                this.radialTopRightGradient(g, x, y, width, height);
                break;
            }
            case 12: {
                this.radialBottomLeftGradient(g, x, y, width, height);
                break;
            }
            case 13: {
                this.radialBottomRightGradient(g, x, y, width, height);
                break;
            }
            case 14: {
                this.rectangularGradient(g, x, y, width, height);
                break;
            }
            default: {
                this.fillShape(g, new Rectangle2D.Double(x, y, width, height));
            }
        }
    }

    public void insertPin(double fPosition, Color leftColor, Color rightColor) {
        this.m_ColorStripe.insertPin(fPosition, leftColor, rightColor);
    }

    public final void insertPin(double fPosition, Color color) {
        this.m_ColorStripe.insertPin(fPosition, color);
    }

    private void leftGradient(Graphics2D g, int x, int y, int width, int height) {
        int xmax = x + width;
        int ymax = y + height;
        for (int i = xmax - 1; i >= x; --i) {
            Color color = this.m_ColorStripe.getColorAt(1.0 - (double)(i - x) / (double)width);
            g.setColor(color);
            g.drawLine(i, y, i, ymax);
        }
    }

    private void radialBottomLeftGradient(Graphics2D g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0 + (double)height), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
        }
    }

    private void radialBottomRightGradient(Graphics2D g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0 + (double)width), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0 + (double)height), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
        }
    }

    private void radialGradient(Graphics2D g, int x, int y, int width, int height) {
        int xp = -width / 4 + x;
        int yp = -height / 4 + y;
        int wp = width + width / 2;
        int hp = height + height / 2;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillOval((int)((double)(xp + wp / 2) - fCoef * (double)wp / 2.0), (int)((double)(yp + hp / 2) - fCoef * (double)hp / 2.0), (int)(2.0 * (fCoef * (double)wp / 2.0)), (int)(2.0 * (fCoef * (double)hp / 2.0)));
        }
    }

    private void radialTopLeftGradient(Graphics2D g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
        }
    }

    private void radialTopRightGradient(Graphics2D g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0 + (double)width), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
        }
    }

    private void rightGradient(Graphics2D g, int x, int y, int width, int height) {
        int xmax = x + width;
        int ymax = y + height;
        for (int i = x; i < xmax; ++i) {
            Color color = this.m_ColorStripe.getColorAt((double)(i - x) / (double)width);
            g.setColor(color);
            g.drawLine(i, y, i, ymax);
        }
    }

    public void setDirection(int nDirection) {
        if (nDirection < 1 || nDirection > 15) {
            throw new IllegalArgumentException();
        }
        this.m_nDirection = nDirection;
    }

    private void upGradient(Graphics2D g, int x, int y, int width, int height) {
        int xmax = x + width;
        int ymax = y + height;
        for (int i = ymax - 1; i >= y; --i) {
            Color color = this.m_ColorStripe.getColorAt(1.0 - (double)(i - y) / (double)height);
            g.setColor(color);
            g.drawLine(x, i, xmax, i);
        }
    }

    private void upLeftGradient(Graphics2D g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        for (int i = nExtMax - 1; i >= 0; --i) {
            double fCoef = (double)i / (double)nExtMax;
            Color color = this.m_ColorStripe.getColorAt(1.0 - fCoef);
            g.setColor(color);
            xPoint[0] = (int)(fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] + 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] + 5;
            yPoint[3] = yPoint[0] + 5;
            g.drawPolygon(xPoint, yPoint, 4);
        }
    }

    private void upRightGradient(Graphics2D g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        for (int i = nExtMax - 1; i >= 0; --i) {
            double fCoef = (double)i / (double)nExtMax;
            Color color = this.m_ColorStripe.getColorAt(1.0 - fCoef);
            g.setColor(color);
            xPoint[0] = (int)((double)width - fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x + width;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] + 5;
            g.drawPolygon(xPoint, yPoint, 4);
        }
    }

    private void rectangularGradient(Graphics2D g, int x, int y, int width, int height) {
        int xp = -width / 4 + x;
        int yp = -height / 4 + y;
        int wp = width + width / 2;
        int hp = height + height / 2;
        int nMaxExtent = Math.max(wp, hp) / 2;
        for (int nExtent = nMaxExtent - 1; nExtent >= 0; --nExtent) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            Color color = this.m_ColorStripe.getColorAt(fCoef);
            g.setColor(color);
            g.fillRect((int)((double)(xp + wp / 2) - fCoef * (double)wp / 2.0), (int)((double)(yp + hp / 2) - fCoef * (double)hp / 2.0), (int)(2.0 * (fCoef * (double)wp / 2.0)), (int)(2.0 * (fCoef * (double)hp / 2.0)));
        }
    }

    public Color getColorAt(double fValue) {
        return this.m_ColorStripe.getColorAt(fValue);
    }

    public final boolean copyGradientColors(List<ColorPinObj> list) {
        return this.m_ColorStripe.copyGradientColors(list);
    }

    public final double[] getPositions() {
        return this.m_ColorStripe.getPositions();
    }

    public final Color[] getUpperColors() {
        return this.m_ColorStripe.getUpperColors();
    }

    public final Color[] getLowerColors() {
        return this.m_ColorStripe.getLowerColors();
    }

    @Override
    public int getGradientDirection() {
        return this.m_nDirection;
    }

    public String toString() {
        return "FillGradientObj:" + this.m_ColorStripe;
    }

    public void setAnchorRect(Rectangle2D anchorRect) {
        this.m_anchorRect = anchorRect;
    }

    static {
        Color blue1 = Color.blue.darker();
        Color blue2 = Color.blue.brighter();
        Color green1 = Color.green.darker();
        Color green2 = Color.green;
        Color[] colors = new Color[]{blue1, blue1, blue1, blue2, blue2, green1, green1, green2, green2, Color.yellow, Color.yellow, Color.orange, Color.orange, Color.red, Color.red, Color.red.darker(), Color.red.darker(), Color.gray.darker(), Color.gray.darker(), Color.gray, Color.gray, Color.lightGray, Color.lightGray, Color.white, Color.white, Color.white};
        double[] positions = new double[]{0.0, 0.2f, 0.25, 0.3f, 0.35f, 0.4f, 0.45f, 0.49f, 0.54f, 0.6f, 0.66f, 0.72f, 1.0};
        s_fillGradientObj = new FillGradientObj(colors, positions, 1);
    }
}

