/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import java.awt.Color;

public class ColorPinObj {
    private Color m_LeftColor;
    private Color m_RightColor;
    private double m_fPosition;

    ColorPinObj() {
        this.m_LeftColor = Color.WHITE;
        this.m_RightColor = Color.WHITE;
        this.m_fPosition = 0.0;
    }

    ColorPinObj(double fValue, Color leftColor, Color rightColor) {
        this.m_LeftColor = leftColor;
        this.m_RightColor = rightColor;
        if (!(this.m_fPosition >= 0.0) || !(this.m_fPosition <= 1.0)) {
            throw new IllegalArgumentException("The position must be between 0.0 and 1.0");
        }
        this.m_fPosition = fValue;
    }

    public void copy(ColorPinObj cpo) {
        this.m_fPosition = cpo.m_fPosition;
        this.m_LeftColor = cpo.m_LeftColor;
        this.m_RightColor = cpo.m_RightColor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorPinObj)) {
            return false;
        }
        ColorPinObj cpo = (ColorPinObj)obj;
        boolean bEqual = this.m_fPosition == cpo.m_fPosition && this.m_LeftColor.equals(cpo.m_LeftColor) && this.m_RightColor.equals(cpo.m_RightColor);
        return bEqual;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (int)this.m_fPosition * 100;
        result = result * 37 + this.m_LeftColor.hashCode();
        result = result * 37 + this.m_RightColor.hashCode();
        return result;
    }

    public Color getLeftColor() {
        return this.m_LeftColor;
    }

    public double getPosition() {
        return this.m_fPosition;
    }

    public Color getRightColor() {
        return this.m_RightColor;
    }

    public void setColor(Color leftColor, Color rightColor) {
        assert (leftColor != null);
        assert (rightColor != null);
        this.m_LeftColor = leftColor;
        this.m_RightColor = rightColor;
    }

    public String toString() {
        return "[" + (float)this.m_fPosition + "/" + this.m_LeftColor.toString() + "/" + this.m_RightColor.toString() + "]";
    }
}

