/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.UniversalPictureStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataRange;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ICVOMSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplateArray;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.TDGNotEnoughData;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataStorageFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataStorageFastDouble;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Annotations;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.BackgroundObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Ticks2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.TitleObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.StandardLookPFJ;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElements;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.KeyObject;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjClassID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Perspective
extends PerspectiveBase {
    static final int ZOOM_X_DIRECTION = 1;
    static final int ZOOM_Y_DIRECTION = 2;
    public static final String DATA_VALUE_MACRO = "[DATA]";
    public static final String SERIES_VALUE_MACRO = "[SERIES]";
    public static final String CATEGORY_VALUE_MACRO = "[CATEGORY]";
    public static final String Y_VALUE_MACRO = "[Y]";
    public static final String X_VALUE_MACRO = "[X]";
    public static final String SIZE_VALUE_MACRO = "[SIZE]";
    public static final String OPEN_VALUE_MACRO = "[OPEN]";
    public static final String HI_VALUE_MACRO = "[HIGH]";
    public static final String LOW_VALUE_MACRO = "[LOW]";
    public static final String CLOSE_VALUE_MACRO = "[CLOSE]";
    public static final String INTERVAL_VALUE_MACRO = "[INTERVAL]";
    public static final String TASK_VALUE_MACRO = "[TASK]";
    public static final String START_VALUE_MACRO = "[START]";
    public static final String STOP_VALUE_MACRO = "[STOP]";
    public static final String TIME_VALUE_MACRO = "[TIME]";
    public static final int NO_CHART_YET = 0;
    public static final int VIEW_ALL_DATA = 0;
    private IDataStorage dataStorage;
    private DataRange dataRange;
    private VC m_VC;
    private IDrawContainer m_Detectiv;
    private Map<Object, IdentObj> m_ExceptionalRisers;
    boolean m_bHaveExceptionalRisers = false;
    private boolean m_bValidChart;
    private MarkerTemplateArray m_markerTemplateArray = null;
    private int m_AxisTextSizeVC;
    private boolean m_TestLabelCalc;
    private final transient BackgroundObj m_background;
    private final transient TitleObj m_title;
    private final transient TitleObj m_subtitle;
    private final transient TitleObj m_footnote;
    private Dimension m_dimContainerSize = null;
    private boolean m_bPlacing = false;
    boolean m_UseFastDataStorage = false;
    int m_FastDataRows = 0;
    int m_FastDataCols = 0;
    boolean pgsdkAutoArrange;
    private transient IChartEngine m_chart;
    private final Map<String, Image> m_textureMap = new HashMap<String, Image>();
    private final Map<String, UniversalPictureStruct> pictureMap = new HashMap<String, UniversalPictureStruct>();
    private final TrendlineSettings trendlineSettings = new TrendlineSettings(this);
    private FontRenderContext m_fontRenderContext;
    private boolean estimateHasOneSeries = false;
    private int missingTextures = 0;

    public Perspective() {
        this((ICVOMSettings)null);
    }

    public Perspective(ICVOMSettings cvomSettings) {
        this.cvomSettings = cvomSettings;
        this.m_background = new BackgroundObj(this);
        this.m_title = new TitleObj(this, new IdentObj(5), new IdentObj(46));
        this.m_subtitle = new TitleObj(this, new IdentObj(4), new IdentObj(45));
        this.m_footnote = new TitleObj(this, new IdentObj(3), new IdentObj(44));
        this.m_gaugeLook = new StandardLookPFJ(this);
        this.m_ExceptionalRisers = new Hashtable<Object, IdentObj>();
        this.m_markerTemplateArray = new MarkerTemplateArray();
        this.initLook();
        this.clearDataStorage();
        this.m_annotations = new Annotations(this);
    }

    public void setAttrValue(IdentObj id, Attr attr, Object value) {
        this.putToLook(id, attr, value);
    }

    public void setFillType(int seriesId, int newValue) {
        IdentObj id = new IdentObj(-3, seriesId, -3);
        this.setFillType(id, newValue);
    }

    public boolean getDrawAreaMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.DrawAreaMarkers);
        return m_Obj;
    }

    public void setDrawAreaMarkers(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DrawAreaMarkers, newValue);
    }

    void setDetectiv(IDrawContainer d) {
        this.m_Detectiv = d;
    }

    public Detectiv generateDetectiv(int width, int height, int twipWidth, int twipHeight) {
        this.setSize(width, height);
        this.m_fontRenderContext = this.calcFontRenderContext(width, height, twipWidth, twipHeight);
        Detectiv detList = new Detectiv(this);
        this.setDetectiv(detList);
        this.setNumericTimeScaleHack();
        this.newPlaceDefaultElements();
        this.calc();
        return detList;
    }

    private void setNumericTimeScaleHack() {
        JGraphType gt = this.getJGraphType();
        boolean isTimeScaleAxis = this.getUseTimeScaleAxis();
        boolean isNumericScaleAxis = this.getUseNumericScaleAxis() || this.getUsePGSDKTimeScaleAxis();
        boolean o1AxisIsX1Axis = (isTimeScaleAxis || isNumericScaleAxis) && !gt.isGanttType();
        gt.getAxisDescriptor().setO1AxisIsReallyX1AxisHack(o1AxisIsX1Axis);
        gt.setIsTimeScaleAxis(isTimeScaleAxis);
        gt.setIsNumericScaleAxis(isNumericScaleAxis);
    }

    private FontRenderContext calcFontRenderContext(int width, int height, int twipWidth, int twipHeight) {
        AffineTransform tx = new AffineTransform();
        return new FontRenderContext(tx, true, true);
    }

    public void drawDetectiv(Graphics2D g, Detectiv detList) {
        this.setDetectiv(detList);
        this.paintObjects(g);
    }

    public void calc() {
        assert (this.m_dimContainerSize != null);
        this.m_background.calc();
        this.updateAccess();
        boolean bl = this.m_bHaveExceptionalRisers = this.m_ExceptionalRisers.size() > 0;
        if (this.getChartDataValid()) {
            this.m_bValidChart = true;
            if (this.m_chart != null) {
                this.m_chart.calculate(this.m_Detectiv);
            }
            if (this.getTitleDisplay()) {
                this.m_title.calc();
            }
            if (this.getSubtitleDisplay()) {
                this.m_subtitle.calc();
            }
            if (this.getFootnoteDisplay()) {
                this.m_footnote.calc();
            }
            this.m_annotations.calc();
            this.calcAnnotations();
        } else {
            this.m_bValidChart = false;
        }
    }

    private void calcAnnotations() {
        for (int nIdx = 0; nIdx < this.getMaxNumAnnotations(); ++nIdx) {
            String strText = this.getTextString(this.getAnnotation(nIdx));
            boolean bDisplay = this.getDisplay(this.getAnnotation(nIdx));
            if (strText.length() <= 0 || !bDisplay) continue;
            TitleObj annot = new TitleObj(this, this.getAnnotation(nIdx), this.getAnnotationBox(nIdx));
            annot.calc();
        }
    }

    public static BufferedImage createOffscreenImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public int getNumColumnsInGroup(int nIntegerGraphType) {
        JGraphType graphType = JGraphType.getJGraphType(nIntegerGraphType);
        DataFormat dataFmt = graphType.getDataFormat();
        int nNumColsInGroup = dataFmt.getColsPerNode();
        return nNumColsInGroup;
    }

    public int getNumColumnsInGroup() {
        int nIntegerGraphType = this.getGraphType();
        int nNumColsInGroup = this.getNumColumnsInGroup(nIntegerGraphType);
        return nNumColsInGroup;
    }

    public int getMinNumSeries() {
        int nIntegerGraphType = this.getGraphType();
        int nMinNumSeries = this.getMinNumSeries(nIntegerGraphType);
        return nMinNumSeries;
    }

    public int getMinNumSeries(int nIntegerGraphType) {
        JGraphType graphType = JGraphType.getJGraphType(nIntegerGraphType);
        int nSeriesNeeded = 1;
        if (graphType.is3DSurface() || nIntegerGraphType == 9 || nIntegerGraphType == 10) {
            nSeriesNeeded = 1;
        }
        return nSeriesNeeded;
    }

    public int getMinNumGroups(int nIntegerGraphType) {
        JGraphType graphType = JGraphType.getJGraphType(nIntegerGraphType);
        int nGroupsNeeded = 1;
        if (!graphType.isBLAType() && (graphType.is3DSurface() || graphType.isRiserArea() || nIntegerGraphType == 6 || nIntegerGraphType == 7)) {
            nGroupsNeeded = 1;
        }
        return nGroupsNeeded;
    }

    public int getMinNumGroups() {
        int nIntegerGraphType = this.getGraphType();
        int nMinNumGroups = this.getMinNumGroups(nIntegerGraphType);
        return nMinNumGroups;
    }

    private TDGNotEnoughData isChartDataInvalid(int nMinGroups, int nMinSeries) {
        boolean bItemsAlongRows;
        int nActualCols;
        int nActualRows;
        JGraphType gt = this.getJGraphType();
        DataFormat dataFmt = gt.getDataFormat();
        Rectangle dataRange = this.getDataRect();
        int nIntegerGraphType = gt.getIntegerGraphType();
        int nSeriesNeeded = this.getMinNumSeries(nIntegerGraphType);
        int nGroupsNeeded = this.getMinNumGroups(nIntegerGraphType);
        if (dataRange == null || dataRange.isEmpty()) {
            nActualRows = 0;
            nActualCols = 0;
        } else {
            nActualRows = dataRange.height;
            nActualCols = dataRange.width;
        }
        TDGNotEnoughData notEnoughData = new TDGNotEnoughData();
        notEnoughData.bEnoughRowsOfData = true;
        notEnoughData.nNumActualRowsOfData = nActualRows;
        notEnoughData.bEnoughColsOfData = true;
        notEnoughData.nNumActualColsOfData = nActualCols;
        boolean bSeriesAreRows = this.getSeriesAreRows();
        boolean bItemsAlongSeries = this.getDataItemsAlongSeries();
        boolean bl = bItemsAlongRows = bSeriesAreRows == bItemsAlongSeries;
        if (bItemsAlongRows) {
            notEnoughData.nNumNeededRowsOfData = nSeriesNeeded * dataFmt.getRowsPerNode();
            notEnoughData.nNumNeededColsOfData = nGroupsNeeded * dataFmt.getColsPerNode();
        } else {
            notEnoughData.nNumNeededRowsOfData = nSeriesNeeded * dataFmt.getColsPerNode();
            notEnoughData.nNumNeededColsOfData = nGroupsNeeded * dataFmt.getRowsPerNode();
        }
        if (nMinSeries > 0 && (dataRange == null || nActualRows < notEnoughData.nNumNeededRowsOfData)) {
            notEnoughData.bEnoughRowsOfData = false;
        }
        if (nMinGroups > 0 && (dataRange == null || nActualCols < notEnoughData.nNumNeededColsOfData)) {
            notEnoughData.bEnoughColsOfData = false;
        }
        return notEnoughData;
    }

    public boolean hasBarOrMarkerSeries() {
        boolean bFound = false;
        boolean bMarkersOK = this.getMarkerDisplay();
        int[] seriesTypes = this.getSeriesTypes();
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this, this.m_chart.getDataView());
        while (sEnum.hasNext() && !bFound) {
            int s = sEnum.next();
            if (seriesTypes[s] == 1) {
                bFound = true;
            }
            if (!bMarkersOK || seriesTypes[s] != 2) continue;
            bFound = true;
        }
        return bFound;
    }

    public void clearDataStorage() {
        this.clearSeriesLabels();
        this.clearGroupLabels();
        this.clearDataLabels();
        if (this.m_UseFastDataStorage) {
            DataStorageFastDouble ds = (DataStorageFastDouble)DataStorageFactory.getInstance(0);
            ds.setExtents(this.m_FastDataRows, this.m_FastDataCols);
            this.dataStorage = ds;
        } else {
            this.dataStorage = DataStorageFactory.getInstance(1);
        }
        this.updateAccess();
        this.setDataRangeToExtent();
    }

    public void clearDataLabels() {
        Attr attrTextString = Attr.TextString;
        for (int s = 0; s < this.getNumTotalSeries(); ++s) {
            for (int g = 0; g < this.getNumTotalGroups(); ++g) {
                IdentObj idSeriesGroup = this.getSeriesGroup(s, g);
                if (this.getFromLook(idSeriesGroup, Attr.TextString, false) == null) continue;
                this.removeFromLook(idSeriesGroup, attrTextString);
            }
        }
    }

    public void clearGroupLabels() {
        Attr attrGroupLabel = Attr.GroupLabel;
        for (int g = 0; g < this.getNumTotalGroups(); ++g) {
            IdentObj idGroup = this.getGroup(g);
            if (this.getFromLook(idGroup, Attr.GroupLabel, false) == null) continue;
            this.removeFromLook(idGroup, attrGroupLabel);
        }
    }

    public void clearSeriesLabels() {
        Attr attrSeriesLabel = Attr.SeriesLabel;
        for (int s = 0; s < this.getNumTotalSeries(); ++s) {
            IdentObj idSeries = this.getSeries(s);
            if (this.getFromLook(idSeries, Attr.SeriesLabel, false) == null) continue;
            this.removeFromLook(idSeries, attrSeriesLabel);
        }
    }

    private IChartEngine createJChart(JGraphType gt) {
        IChartEngineFactory engineFactory = gt.getChartFactory();
        if (engineFactory != null) {
            IChartEngine engine = engineFactory.createChartEngine(this);
            engine.setDataView(new Access(this, this.getDataStorage(), this.dataRange, gt.getDataFormat()));
            engine.init();
            return engine;
        }
        assert (false);
        return null;
    }

    synchronized void doReshape() {
        Dimension d = this.getContainerSize();
        if (d.height <= 10) {
            d = this.getMinimumSize();
        }
        this.m_VC = new VC(d.width, d.height);
    }

    public Color getBorderColor(IdentObj id) {
        if (!this.getUseSeriesBorderDefaults() || !id.isSeriesRelated()) {
            return (Color)this.getFromLook(id, Attr.BorderColor, true);
        }
        Color color = this.getSeriesDefaultBorderColor();
        if (color != null) {
            return color;
        }
        return Color.black;
    }

    public boolean getChartDataValid() {
        boolean bValid = true;
        int nGroups = this.getNumGroups();
        int nSeries = this.getNumNonIgnoredSeries();
        int nMinGroups = this.getMinNumGroups();
        int nMinSeries = this.getMinNumSeries();
        if (nGroups < nMinGroups || nSeries < nMinSeries) {
            bValid = false;
        }
        TDGNotEnoughData notEnoughData = this.isChartDataInvalid(nMinGroups, nMinSeries);
        if (!notEnoughData.bEnoughRowsOfData || !notEnoughData.bEnoughColsOfData) {
            bValid = false;
        }
        return bValid;
    }

    public int[] getSeriesTypes() {
        int[] nSeriesTypes = null;
        JGraphType graphType = this.getJGraphType();
        int nTotalSeries = this.getNumTotalSeries();
        if (nTotalSeries > 0) {
            int nBaseRiserType = this.getBaseRiserType();
            nSeriesTypes = new int[nTotalSeries];
            for (int nSeries = 0; nSeries < nTotalSeries; ++nSeries) {
                nSeriesTypes[nSeries] = graphType.isBLAType() ? this.getASeriesType(nSeries, nBaseRiserType) : nBaseRiserType;
            }
        }
        return nSeriesTypes;
    }

    public int getBaseRiserType() {
        JGraphType graphType = this.getJGraphType();
        int nBaseRiserType = graphType.getRiserType();
        return nBaseRiserType;
    }

    private int getASeriesType(int s, int nBaseRiserType) {
        int nSeriesType = this.getSeriesType(s);
        JGraphType graphType = this.getJGraphType();
        if (nSeriesType == 0 || graphType.isPercent()) {
            nSeriesType = nBaseRiserType;
        }
        return nSeriesType;
    }

    public DataRange getViewableDataRange() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getViewableDataRange();
        }
        return null;
    }

    public Access getAccess() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView();
        }
        return null;
    }

    public DataRange getViewableDataRangeSG() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getViewableDataRangeSG(this);
        }
        return null;
    }

    public double getDataAsDouble(int row, int col) {
        return this.dataStorage.getDataAsDouble(row, col);
    }

    public String getDataAsString(int row, int col) {
        return this.dataStorage.getData(row, col).toString();
    }

    public IDrawContainer getDetectiv() {
        return this.m_Detectiv;
    }

    public int getEffectiveGroupOffset() {
        int nViewableGroups = this.getEffectiveViewableGroups();
        int nTotalGroups = this.getNumTotalGroups();
        int nGroupOffset = this.getScrollOffsetGroup();
        if (nViewableGroups < nTotalGroups) {
            if (nGroupOffset > nTotalGroups - nViewableGroups) {
                nGroupOffset = nTotalGroups - nViewableGroups;
            }
        } else if (nViewableGroups == nTotalGroups) {
            nGroupOffset = 0;
        } else {
            throw new RuntimeException("ViewableGroups = " + nViewableGroups + " TotalGroups = " + nTotalGroups);
        }
        return nGroupOffset;
    }

    public int getEffectiveSeriesOffset() {
        int nViewableSeries = this.getEffectiveViewableSeries();
        int nTotalSeries = this.getNumTotalSeries();
        int nSeriesOffset = this.getScrollOffsetSeries();
        if (nViewableSeries < nTotalSeries) {
            if (nSeriesOffset > nTotalSeries - nViewableSeries) {
                nSeriesOffset = nTotalSeries - nViewableSeries;
            }
        } else if (nViewableSeries == nTotalSeries) {
            nSeriesOffset = 0;
        } else {
            throw new RuntimeException("ViewableSeries = " + nViewableSeries + " TotalSeries = " + nTotalSeries);
        }
        return nSeriesOffset;
    }

    public int getEffectiveViewableGroups() {
        int nTotalGroups = this.getNumTotalGroups();
        return this.getEffectiveViewableGroups(nTotalGroups);
    }

    public int getEffectiveViewableGroups(int nTotalGroups) {
        int nViewableGroups;
        JGraphType gt = this.getJGraphType();
        int n = nViewableGroups = gt.isStockType() ? this.getViewableGroupsStock() : this.getViewableGroups();
        if (nViewableGroups != 0 && nTotalGroups > nViewableGroups) {
            return nViewableGroups;
        }
        return nTotalGroups;
    }

    public int getEffectiveViewableSeries() {
        int nTotalSeries = this.getNumTotalSeries();
        return this.getEffectiveViewableSeries(nTotalSeries);
    }

    public int getEffectiveViewableSeries(int nTotalSeries) {
        int nViewableSeries;
        JGraphType gt = this.getJGraphType();
        int n = nViewableSeries = gt.isStockType() ? this.getViewableSeriesStock() : this.getViewableSeries();
        if (nViewableSeries != 0 && nTotalSeries > nViewableSeries) {
            return nViewableSeries;
        }
        return nTotalSeries;
    }

    public Color getFillColor(IdentObj id) {
        return (Color)this.getFromLook(id, Attr.FillColor, true);
    }

    public int getFillType(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.FillType);
    }

    public Rectangle getFrameRect(boolean bInner) {
        Rectangle rVirt = this.getVirtFrameRect();
        if (bInner) {
            Rectangle rDest = this.m_VC.virtToDest(rVirt);
            rDest.grow(-1, -1);
            rVirt = this.m_VC.destToVirt(rDest);
        }
        return rVirt;
    }

    private Rectangle getVirtFrameRect() {
        FrameObj frame;
        if (this.m_chart instanceof JChart_2D && (frame = ((JChart_2D)this.m_chart).getFrame()) != null) {
            return frame.getBackWallBounds();
        }
        return this.getRect(new IdentObj(2));
    }

    public Point getFrameDepthOffset() {
        FrameObj frame;
        if (this.m_chart instanceof JChart_2D && (frame = ((JChart_2D)this.m_chart).getFrame()) != null) {
            return frame.getDepthOffset(1.0);
        }
        return new Point(0, 0);
    }

    public int getGradientDirection(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.GradientDirection);
    }

    public int getGradientNumPins(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.GradientNumPins);
    }

    public Color getGradientPinLeftColor(IdentObj id, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        return (Color)this.getFromLook(newID, Attr.GradientPinLeftColor);
    }

    public double getGradientPinPosition(IdentObj id, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        return (Double)this.getFromLook(newID, Attr.GradientPinPosition);
    }

    public Color getGradientPinRightColor(IdentObj id, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        return (Color)this.getFromLook(newID, Attr.GradientPinRightColor);
    }

    public JChart_Base getGraphObject() {
        return (JChart_Base)this.m_chart;
    }

    public int getGraphType() {
        return (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.GraphType);
    }

    public void setGraphType(int newValue) {
        this.internalSetGraphType(newValue);
        this.init();
    }

    void internalSetGraphType(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.GraphType, new Integer(newValue));
    }

    public JGraphType getJGraphType() {
        return JGraphType.getJGraphType(this.getGraphType());
    }

    public Rectangle getLegendRect() {
        return this.getRect(Identity.LegendArea);
    }

    public int getMarkerShape(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.MarkerShape, true);
    }

    public void removeMarkerShapes(int nSeriesStart, int nSeriesEnd) {
        if (nSeriesStart <= nSeriesEnd) {
            for (int nIdx = nSeriesStart; nIdx <= nSeriesEnd; ++nIdx) {
                IdentObj id = this.getSeries(nIdx);
                this.m_look.remove(this.m_cachedKey.set(Attr.MarkerShape, id));
            }
        }
    }

    public MarkerTemplate getMarkerTemplate(IdentObj id) {
        return this.m_markerTemplateArray.getMarkerTemplate(this.getMarkerShape(id));
    }

    public MarkerTemplate getMarkerTemplate(int nShape) {
        return this.m_markerTemplateArray.getMarkerTemplate(nShape);
    }

    public int getNumGroups() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getNumGroups();
        }
        return 0;
    }

    public int getNumNonIgnoredSeries() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getNumNonIgnoredSeries();
        }
        return 0;
    }

    public int getNumSeries() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getNumSeries();
        }
        return 0;
    }

    public int getNumTotalGroups() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getNumTotalGroups();
        }
        return 0;
    }

    public int getNumTotalSeries() {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            return this.m_chart.getDataView().getNumTotalSeries();
        }
        return 0;
    }

    public double getQuadrantLineValueX(int nIndex) {
        return this.getQuadrantLineValueX(this.getQuadrantLine(nIndex));
    }

    public double getQuadrantLineValueX(IdentObj id) {
        return (Double)this.getFromLook(id, Attr.QuadrantLineValueX);
    }

    public double getQuadrantLineValueY(int nIndex) {
        return this.getQuadrantLineValueY(this.getQuadrantLine(nIndex));
    }

    public double getQuadrantLineValueY(IdentObj id) {
        return (Double)this.getFromLook(id, Attr.QuadrantLineValueY);
    }

    public IdentObj getQuadrantLine(int nIndex) {
        IdentObj id = Identity.QuadrantLine;
        id = id.changeMisc(nIndex);
        return id;
    }

    public Image getTexture(String szURL) {
        Image aVal = this.m_textureMap.get(szURL);
        if (aVal != null) {
            return aVal;
        }
        return null;
    }

    public byte[] getMetafileData(String filename) {
        UniversalPictureStruct upc = this.pictureMap.get(filename);
        if (upc == null) {
            return null;
        }
        if (upc.isMetafile) {
            return upc.rawData;
        }
        return null;
    }

    public int getTextureDisplayMode(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.TextureDisplayMode);
    }

    public int getTextureFlipMode(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.TextureFlipMode);
    }

    public String getTexture(IdentObj id) {
        return (String)this.getFromLook(id, Attr.TextureURL);
    }

    public boolean getTransparentBorderColor(IdentObj id) {
        if (!this.getUseSeriesBorderDefaults() || !id.isSeriesRelated()) {
            return (Boolean)this.getFromLook(id, Attr.TransparentBorderColor, true);
        }
        boolean bVal = this.getSeriesDefaultTransparentBorderColor();
        return bVal;
    }

    public boolean getTransparentFillColor(IdentObj id) {
        return (Boolean)this.getFromLook(id, Attr.TransparentFillColor, true);
    }

    private void init() {
        this.setNumericTimeScaleHack();
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            assert (false);
        } else {
            this.removeFromLook(IdentObj.GLOBAL, Attr.GraphType);
            this.m_bValidChart = true;
            this.doReshape();
            this.m_chart = this.createJChart(gt);
        }
    }

    void initLook() {
        this.setDisplay(Identity.UserLine1, false);
        this.setDisplay(Identity.UserLine2, false);
        this.setDisplay(Identity.UserLine3, false);
        this.setDisplay(Identity.UserLine4, false);
        this.putToLook(IdentObj.GLOBAL, Attr.GraphType, new Integer(17));
        this.setAxisAssignment(this.getSeries(1), 1);
        this.setDisplay(Identity.ScatterQuadrantLine, false);
        this.setDisplay(new IdentObj(548), false);
        this.setDisplay(new IdentObj(549), false);
        this.setDisplay(Identity.StockMALine, false);
        this.setRect(Identity.ChartBackground, new Rectangle(-16000, -16000, 32000, 32000));
    }

    public final void setGridAttributes(IdentObj id, int style, Color color, int width, int stroke) {
        this.setDisplay(id, true);
        this.setGridStyle(id, style);
        this.setFillColor(id, color);
        this.setBorderColor(id, color);
        this.setLineWidth(id, width);
        this.setLineBasicStrokeType(id, stroke);
    }

    public final void setTickAttributes(IdentObj id, int style, Color color, int len, int width, int stroke, boolean forcePerpendicular) {
        Ticks2D.setTickAttributes(this, id, style, color, len, width, stroke, forcePerpendicular);
    }

    public final void setMajorTickAttributes(IdentObj id, int style, Color color, int len, int width, int stroke, boolean forcePerpendicular, boolean excludeMinTick, boolean excludeMaxTick) {
        Ticks2D.setMajorTickAttributes(this, id, style, color, len, width, stroke, forcePerpendicular, excludeMinTick, excludeMaxTick);
    }

    public int getEffectiveColorMode() {
        int nEffectiveColorMode = this.isColorByHeight() ? 3 : (this.isColorByGroup() ? 2 : 1);
        return nEffectiveColorMode;
    }

    public int getEffectiveColorModeEstimate() {
        int nEffectiveColorMode = this.isColorByHeight() ? 3 : (this.isColorByGroupEstimate() ? 2 : 1);
        return nEffectiveColorMode;
    }

    public boolean isColorByHeight() {
        boolean bByHeight = this.getColorMode() == 3 || this.shouldAutoColorByHeight();
        return bByHeight;
    }

    public boolean isColorByGroup() {
        boolean bByGroup = this.getColorMode() == 2 && this.mayColorByGroup() || this.shouldAutoColorByGroup(false);
        return bByGroup;
    }

    public boolean isColorByGroupEstimate() {
        return this.getColorMode() == 2 && this.mayColorByGroup() || this.shouldAutoColorByGroup(true);
    }

    boolean shouldAutoColorByHeight() {
        boolean bByHeight = false;
        JGraphType gt = this.getJGraphType();
        return bByHeight;
    }

    boolean shouldAutoColorByGroup(boolean useEstimate) {
        boolean oneSeries;
        boolean bByGroup = false;
        JGraphType gt = this.getJGraphType();
        boolean bl = useEstimate ? this.estimateHasOneSeries : (oneSeries = this.getNumNonIgnoredSeries() == 1);
        if (this.getColorMode() == 0) {
            if (gt.is3DConnectGroups() || gt.isGanttType()) {
                bByGroup = true;
            } else if (oneSeries) {
                bByGroup = gt.is3DType() && !gt.is3DConnectSeries() || gt.isBLAType() && gt.isRiserBar();
            }
        }
        return bByGroup;
    }

    boolean mayColorByGroup() {
        boolean bByGroupOK = true;
        JGraphType gt = this.getJGraphType();
        if (gt.isPieType()) {
            bByGroupOK = false;
        }
        return bByGroupOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintObjects(Graphics2D g) {
        if (this.m_bValidChart) {
            RenderingHints oldHints = g.getRenderingHints();
            Rectangle oldClipRect = g.getClipBounds();
            try {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                Dimension size = this.getSize();
                g.clipRect(0, 0, size.width, size.height);
                this.m_Detectiv.paint(g, this.m_VC);
            }
            finally {
                g.setClip(oldClipRect);
                g.setRenderingHints(oldHints);
            }
        }
    }

    public void restoreAllSlices() {
        int nTotalSeries = this.getNumTotalSeries();
        int nTotalGroups = this.getNumTotalGroups();
        for (int s = 0; s < nTotalSeries; ++s) {
            this.deleteAttribute(s, Attr.PieSliceDetach);
            this.deleteAttribute(s, Attr.PieSliceDelete);
            for (int g = 0; g < nTotalGroups; ++g) {
                this.deleteAttribute(s, g, Attr.PieSliceDetach);
                this.deleteAttribute(s, g, Attr.PieSliceDelete);
            }
        }
    }

    public void setBorderColor(IdentObj id, Color newValue) {
        if (id.needsStripping()) {
            id = new IdentObj(id.getObjectID());
        }
        if (this.getCascade()) {
            this.setTransparentBorderColor(id, false);
        }
        this.putToLook(id, Attr.BorderColor, newValue);
    }

    public float getMinLineWidthDC(IdentObj id) {
        Float value = (Float)this.getFromLook(id, Attr.MinLineWidth, false);
        if (value == null) {
            value = (Float)this.getFromLook(Identity.ID_GLOBAL, Attr.MinLineWidth, true);
        }
        return (float)this.ptsWidthToDC(value.floatValue());
    }

    public void setMinLineWidthPts(float minLineWidthPts) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MinLineWidth, new Float(minLineWidthPts));
    }

    public void setLineWidthAllSeries(int newValue) {
        for (int i = 0; i < this.getNumTotalSeries(); ++i) {
            this.setLineWidth(this.getSeries(i), newValue);
        }
    }

    public void setLineWidth(IdentObj id, float newValue) {
        if (!id.isSeriesRelated() && id.needsStripping()) {
            id = new IdentObj(id.getObjectID());
        }
        this.putToLook(id, Attr.LineWidth, new Double(newValue));
    }

    public double getLineWidthPts(IdentObj id) {
        Double lineWidth = (Double)this.getFromLook(id, Attr.LineWidth, false);
        double fLineWidth = 0.0;
        if (lineWidth == null) {
            if (id.isSeriesRelated()) {
                fLineWidth = this.getSeriesLineWidthDefault();
            }
        } else {
            fLineWidth = lineWidth;
        }
        return fLineWidth;
    }

    public double getLineWidth(IdentObj id) {
        return this.ptsWidthToDC(this.getLineWidthPts(id));
    }

    public void removeLineWidths(int nSeriesStart, int nSeriesEnd) {
        if (nSeriesStart <= nSeriesEnd) {
            for (int nIdx = nSeriesStart; nIdx <= nSeriesEnd; ++nIdx) {
                IdentObj id = this.getSeries(nIdx);
                this.m_look.remove(new KeyObject(Attr.LineWidth, id));
            }
        }
    }

    public void setNullData(int row, int col) {
        this.dataStorage.setData(row, col, null);
    }

    public void setData(int row, int col, double value) {
        this.dataStorage.setData(row, col, value);
    }

    public Rectangle getDataRect() {
        if (this.dataRange != null) {
            return new Rectangle(this.dataRange.getColStart(), this.dataRange.getRowStart(), this.dataRange.getNumCols(), this.dataRange.getNumRows());
        }
        return null;
    }

    public void setDataRange(int rowStop, int colStop) {
        this.setDataRange(0, 0, rowStop, colStop);
    }

    public void setDataRange(int rowStart, int colStart, int rowStop, int colStop) {
        this.dataRange = new DataRange(rowStart, colStart, rowStop, colStop);
        if (this.m_chart != null) {
            this.m_chart.setDataView(new Access(this, this.getDataStorage(), this.dataRange, this.getJGraphType().getDataFormat()));
        }
        this.m_bValidChart = true;
    }

    public void setDataRangeToExtent() {
        this.setDataRange(this.dataStorage.getDataExtents().getRowStop(), this.dataStorage.getDataExtents().getColStop());
    }

    public Rectangle getDataExtents() {
        DataRange extents = this.dataStorage.getDataExtents();
        return new Rectangle(extents.getColStart(), extents.getRowStart(), extents.getNumCols(), extents.getNumRows());
    }

    public void setDataValue(IdentObj id, double newValue) {
        this.setDataValue(id, DataItem.DI_GENERAL, newValue);
    }

    public void setDataValue(IdentObj id, DataItem item, double newValue) {
        if (this.m_chart != null && this.m_chart.getDataView() != null) {
            this.m_chart.getDataView().setDataAsDouble(id.getSeriesID(), id.getGroupID(), item, newValue);
        }
    }

    public void updateAccess() {
        if (this.m_chart != null) {
            this.m_chart.setDataView(new Access(this, this.getDataStorage(), this.dataRange, this.getJGraphType().getDataFormat()));
        }
    }

    public Color getShadowColor(IdentObj id) {
        return (Color)this.getFromLook(id, Attr.ShadowColor);
    }

    public void setShadowColor(IdentObj id, Color newValue) {
        this.putToLook(id, Attr.ShadowColor, newValue);
    }

    public boolean haveExceptionalRisers() {
        return this.m_bHaveExceptionalRisers;
    }

    public IdentObj getExceptionalID(IdentObj id) {
        if (id == null) {
            return null;
        }
        int s = id.getSeriesID();
        int g = id.getGroupID();
        IdentObj erID = this.getExceptionalRiser(s, g);
        return erID;
    }

    public IdentObj getExceptionalRiser(int s, int g) {
        Map<Object, IdentObj> excTable = this.getExceptionalRisers();
        for (IdentObj obj : excTable.values()) {
            IdentObj an_id = obj;
            if (an_id.getSeriesID() != s || an_id.getGroupID() != g) continue;
            return an_id;
        }
        return null;
    }

    public Map<Object, IdentObj> getExceptionalRisers() {
        return this.m_ExceptionalRisers;
    }

    public void setExceptionalRiser(int s, int g) {
        IdentObj erID = new IdentObj(ObjClassID.addExceptionalOffset(0), s, g);
        if (this.getExceptionalRiser(s, g) == null) {
            this.m_ExceptionalRisers.put(erID, erID);
        }
    }

    public void setNoExceptionalRiser() {
        this.m_ExceptionalRisers = new Hashtable<Object, IdentObj>();
    }

    public boolean isExceptionalAllowed() {
        JGraphType gt = this.getJGraphType();
        return gt.isExceptionalAllowed();
    }

    public void setMajorGridTickInterval(int interval) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MajorGridTickInterval, new Integer(interval));
    }

    public int getMajorGridTickInterval() {
        Integer levelInterval = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.MajorGridTickInterval);
        int interval = 0;
        if (levelInterval != null) {
            interval = levelInterval;
        }
        return interval;
    }

    public void setMinorGridTickInterval(int interval) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MinorGridTickInterval, new Integer(interval));
    }

    public int getMinorGridTickInterval() {
        Integer levelInterval = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.MinorGridTickInterval);
        int interval = 0;
        if (levelInterval != null) {
            interval = levelInterval;
        }
        return interval;
    }

    public int getQuarter1StartMonth() {
        Integer q1Start = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.Quarter1StartMonth);
        int q1StartInt = 1;
        if (q1Start != null) {
            q1StartInt = q1Start;
        }
        return q1StartInt;
    }

    public void setQuarter1StartMonth(int interval) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Quarter1StartMonth, new Integer(interval));
    }

    public void setLevelInterval(int level, int interval) {
        this.setLevelInterval(this.getTimeScaleLevel(level), interval);
    }

    public void setLevelInterval(IdentObj id, int interval) {
        int level = id.getObjectID() - 9000 - 1;
        if (level == 0) {
            // empty if block
        }
        this.putToLook(id, Attr.LevelInterval, new Integer(interval));
    }

    public void setLevelFillColor(IdentObj id, Color color) {
        this.setFillColor(id, color);
    }

    public void setLevelFillColor(int level, Color color) {
        this.setLevelFillColor(this.getTimeScaleLevel(level), color);
    }

    public Color getLevelFillColor(IdentObj id) {
        return this.getFillColor(id);
    }

    public Color getLevelFillColor(int level) {
        return this.getLevelFillColor(this.getTimeScaleLevel(level));
    }

    public void setLevelHeight(int level, int height) {
        this.setLevelHeight(this.getTimeScaleLevel(level), height);
    }

    public void setLevelHeight(IdentObj id, int height) {
        this.putToLook(id, Attr.LevelHeight, new Integer(height));
    }

    public void setLevelDateFormat(int level, String format) {
        this.setLevelDateFormat(this.getTimeScaleLevel(level), format);
    }

    public void setLevelDateFormat(IdentObj id, String format) {
        this.putToLook(id, Attr.LevelDateFormat, format);
    }

    public void setLevelTextFormat(int level, int format) {
        this.setLevelTextFormat(this.getTimeScaleLevel(level), format);
    }

    public void setLevelTextFormat(IdentObj id, int format) {
        this.putToLook(id, Attr.LevelFormat, new Integer(format));
    }

    public void setLevelTextColor(int level, Color color) {
        this.setFillColor(this.getTimeScaleLevel(level), color);
    }

    public void setLevelTextColor(IdentObj id, Color color) {
        int level = id.getObjectID() - 9000 - 1;
        id = this.getTimeScaleLevelText(level);
        this.setFillColor(id, color);
    }

    public void setLevelBorderColor(int level, Color color) {
        this.setBorderColor(this.getTimeScaleLevel(level), color);
    }

    public void setLevelBorderColor(IdentObj id, Color color) {
        int level = id.getObjectID() - 9000 - 1;
        id = this.getTimeScaleLevel(level);
        this.setBorderColor(id, color);
    }

    public int getLevelInterval(int level) {
        return (Integer)this.getFromLook(this.getTimeScaleLevel(level), Attr.LevelInterval);
    }

    public String getLevelDateFormat(int level) {
        return (String)this.getFromLook(this.getTimeScaleLevel(level), Attr.LevelDateFormat);
    }

    public int getLevelTextFormat(int level) {
        return (Integer)this.getFromLook(this.getTimeScaleLevel(level), Attr.LevelFormat);
    }

    public int getLevelHeight(int level) {
        return (Integer)this.getFromLook(this.getTimeScaleLevel(level), Attr.LevelHeight);
    }

    public boolean getUseTimeScaleAxis() {
        return (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.UseTimeScaleAxis);
    }

    public void setUseTimeScaleAxis(boolean useTimeScaleAxis) {
        this.putToLook(Identity.ID_GLOBAL, Attr.UseTimeScaleAxis, useTimeScaleAxis);
        this.setNumericTimeScaleHack();
    }

    public boolean getUseNumericScaleAxis() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.UseNumericScaleAxis);
        if (m_Obj != null) {
            return m_Obj;
        }
        return false;
    }

    public void setUseNumericScaleAxis(boolean useNumericAxis) {
        this.putToLook(Identity.ID_GLOBAL, Attr.UseNumericScaleAxis, useNumericAxis);
        this.setNumericTimeScaleHack();
    }

    public boolean getUsePGSDKTimeScaleAxis() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.UsePGSDKTimeScaleAxis);
        if (m_Obj != null) {
            return m_Obj;
        }
        return false;
    }

    public void setUsePGSDKTimeScaleAxis(boolean useTimeAxis) {
        this.putToLook(Identity.ID_GLOBAL, Attr.UsePGSDKTimeScaleAxis, useTimeAxis);
        this.setNumericTimeScaleHack();
    }

    public static final boolean leftWallHasDepth(Perspective p) {
        boolean hasDepth = false;
        Point ptFrameDepthOffset = p.getFrameDepthOffset();
        if (p.getDepthRadius() == 0 || p.getUseTimeScaleAxis()) {
            return false;
        }
        hasDepth = p.getDepthRadius() == 0 ? (ptFrameDepthOffset.x == 0 ? false : ptFrameDepthOffset.x > 0) : ptFrameDepthOffset.x > 0;
        return hasDepth;
    }

    public static final boolean rightWallHasDepth(Perspective p) {
        boolean hasDepth = false;
        Point ptFrameDepthOffset = p.getFrameDepthOffset();
        if (p.getDepthRadius() == 0 || p.getUseTimeScaleAxis()) {
            return false;
        }
        hasDepth = p.getDepthRadius() == 0 ? (ptFrameDepthOffset.x == 0 ? false : ptFrameDepthOffset.x < 0) : ptFrameDepthOffset.x < 0;
        return hasDepth;
    }

    public void setFillColor(IdentObj id, Color newValue) {
        if (id.needsStripping()) {
            id = new IdentObj(id.getObjectID());
        }
        if (this.getCascade()) {
            this.putToLook(id, Attr.FillColor, newValue);
            this.setTransparentFillColor(id, false);
            this.setFillType(id, 1);
        } else {
            this.putToLook(id, Attr.FillColor, newValue);
        }
    }

    public void setFillType(IdentObj id, int newValue) {
        if (newValue >= 1 && newValue <= 3) {
            boolean bCascade = this.getCascade();
            if (bCascade) {
                this.putToLook(id, Attr.FillType, new Integer(newValue));
                this.setTransparentFillColor(id, false);
            } else {
                this.putToLook(id, Attr.FillType, new Integer(newValue));
            }
        } else {
            throw new RuntimeException("setFillType: " + newValue);
        }
    }

    public void setGradientDirection(IdentObj id, int newValue) {
        if (newValue >= 1 && newValue <= 15) {
            if (this.getCascade()) {
                this.setTransparentFillColor(id, false);
            }
        } else {
            throw new RuntimeException("setGradientDirection:" + newValue);
        }
        this.putToLook(id, Attr.GradientDirection, new Integer(newValue));
    }

    public void setGradientNumPins(IdentObj id, int newValue) {
        this.putToLook(id, Attr.GradientNumPins, new Integer(newValue));
    }

    public void setGradientPinLeftColor(IdentObj id, Color newValue, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        this.putToLook(newID, Attr.GradientPinLeftColor, newValue);
    }

    public void setGradientPinColors(IdentObj id, Color[] colors) {
        int nLen = colors.length;
        if (nLen < 2) {
            throw new RuntimeException("Number of pin colors should be at least 2.");
        }
        this.setGradientNumPins(id, nLen);
        double dDelta = 1.0 / (double)(nLen - 1);
        double dRatio = 0.0;
        Color color1 = colors[0];
        int nIndex = 0;
        while (nIndex < nLen) {
            color1 = colors[nIndex];
            this.setGradientPinPosition(id, dRatio, nIndex);
            this.setGradientPinLeftColor(id, color1, nIndex);
            this.setGradientPinRightColor(id, color1, nIndex);
            ++nIndex;
            dRatio += dDelta;
        }
    }

    public void setGradientPinPosition(IdentObj id, double newValue, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        this.putToLook(newID, Attr.GradientPinPosition, new Double(newValue));
    }

    public final void initGradient(IdentObj id) {
        if (this.getFillType(id) != 2) {
            Color c = this.getFillColor(id);
            this.setGradientPinRightColor(id, c, 0);
            this.setGradientPinLeftColor(id, c, 1);
            this.setGradientPinRightColor(id, c, 1);
            this.setGradientPinLeftColor(id, c, 2);
            this.setFillType(id, 2);
            this.setGradientPinPosition(id, 0.0, 0);
            this.setGradientPinPosition(id, 1.0, 1);
            this.setGradientNumPins(id, 2);
        }
    }

    public void setGradientPinRightColor(IdentObj id, Color newValue, int nIndex) {
        IdentObj newID = id;
        newID = newID.changeMisc(nIndex);
        this.putToLook(newID, Attr.GradientPinRightColor, newValue);
    }

    public int getNextMarkerTemplateSlot() {
        return this.m_markerTemplateArray.findNextTemplateSlot();
    }

    public int registerMarkerTemplate(Polygon newPolygon) {
        MarkerTemplate newMarkerTemplate = new MarkerTemplate(newPolygon);
        return this.registerMarkerTemplate(newMarkerTemplate);
    }

    public int registerMarkerTemplate(MarkerTemplate newMarkerTemplate) {
        return this.m_markerTemplateArray.registerMarkerTemplate(newMarkerTemplate);
    }

    public void setMarkerTemplate(int nIndex, Polygon newPolygon) {
        MarkerTemplate newMarkerTemplate = new MarkerTemplate(newPolygon);
        this.setMarkerTemplate(nIndex, newMarkerTemplate);
    }

    public void setMarkerTemplate(int nIndex, MarkerTemplate newMarkerTemplate) {
        this.m_markerTemplateArray.setMarkerTemplate(nIndex, newMarkerTemplate);
    }

    public void setMarkerShape(IdentObj id, int markerShape) {
        if (id != null && id.isSeriesRelated()) {
            IdentObj idSeries = null;
            idSeries = this.isColorByGroup() ? new IdentObj(-3, id.getGroupID()) : new IdentObj(-3, id.getSeriesID());
            this.putToLook(idSeries, Attr.MarkerShape, markerShape);
        }
    }

    public void setLegendRect(Rectangle newValue) {
        this.setRect(new IdentObj(12), newValue);
    }

    public void setQuadrantLineValueX(int nIndex, double newValue) {
        this.setQuadrantLineValueX(this.getQuadrantLine(nIndex), newValue);
    }

    public void setQuadrantLineValueX(IdentObj id, double newValue) {
        this.putToLook(id, Attr.QuadrantLineValueX, new Double(newValue));
    }

    public void setQuadrantLineValueY(int nIndex, double newValue) {
        this.setQuadrantLineValueY(this.getQuadrantLine(nIndex), newValue);
    }

    public void setQuadrantLineValueY(IdentObj id, double newValue) {
        this.putToLook(id, Attr.QuadrantLineValueY, new Double(newValue));
    }

    public Color getSeriesBorderColor(int s) {
        IdentObj id = new IdentObj(-3, s, -3);
        return this.getBorderColor(id);
    }

    public void setSeriesBorderColor(int s, Color newValue) {
        IdentObj id = new IdentObj(-3, s, -3);
        this.setBorderColor(id, newValue);
    }

    public Color getSeriesFillColor(int s) {
        IdentObj id = new IdentObj(-3, s, -3);
        return this.getFillColor(id);
    }

    public void setSeriesFillColor(int s, Color newValue) {
        IdentObj id = new IdentObj(-3, s, -3);
        this.setFillColor(id, newValue);
    }

    public boolean getSeriesAreRows() {
        Boolean m_Obj = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.SeriesAreRows);
        return m_Obj;
    }

    public void setSeriesAreRows(boolean newValue) {
        this.setSeriesAreRows(newValue, true);
    }

    public void setSeriesAreRows(boolean newValue, boolean bSwapLabels) {
        if (bSwapLabels && this.getSeriesAreRows() != newValue) {
            this.swapLabels();
        }
        this.putToLook(IdentObj.GLOBAL, Attr.SeriesAreRows, newValue);
    }

    private void swapLabels() {
        if (this.getJGraphType().getAxisDescriptor().hasO2()) {
            String O1Title = this.getO1TitleString();
            String O2Title = this.getO2TitleString();
            this.setO1TitleString(O2Title);
            this.setO2TitleString(O1Title);
        }
        ArrayList<String> seriesLabels = new ArrayList<String>();
        ArrayList<String> groupLabels = new ArrayList<String>();
        int s = 0;
        while (this.getFromLook(this.getSeries(s), Attr.SeriesLabel, false) != null) {
            seriesLabels.add(this.getSeriesLabel(s));
            ++s;
        }
        int g = 0;
        while (this.getFromLook(this.getGroup(g), Attr.GroupLabel, false) != null) {
            groupLabels.add(this.getGroupLabel(g));
            ++g;
        }
        s = 0;
        while (this.getFromLook(this.getSeries(s), Attr.SeriesLabel, false) != null) {
            this.removeFromLook(this.getSeries(s), Attr.SeriesLabel);
            ++s;
        }
        g = 0;
        while (this.getFromLook(this.getGroup(g), Attr.GroupLabel, false) != null) {
            this.removeFromLook(this.getGroup(g), Attr.GroupLabel);
            ++g;
        }
        for (g = 0; g < groupLabels.size(); ++g) {
            this.setSeriesLabel(g, (String)groupLabels.get(g));
        }
        for (s = 0; s < seriesLabels.size(); ++s) {
            this.setGroupLabel(s, (String)seriesLabels.get(s));
        }
    }

    public void setTextureDisplayMode(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextureDisplayMode, new Integer(newValue));
    }

    public void setTextureFlipMode(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextureFlipMode, new Integer(newValue));
    }

    public void setTransparentBorderColor(IdentObj id, boolean newValue) {
        if (id.needsStripping()) {
            id = new IdentObj(id.getObjectID());
        }
        this.putToLook(id, Attr.TransparentBorderColor, newValue);
    }

    public void setTransparentFillColor(IdentObj id, boolean newValue) {
        if (id.needsStripping()) {
            id = new IdentObj(id.getObjectID());
        }
        this.putToLook(id, Attr.TransparentFillColor, newValue);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getContainerSize() {
        if (!this.getSizeToContainer()) {
            return this.m_dimContainerSize;
        }
        return this.getSize();
    }

    @Override
    public void setSize(Dimension d) {
        this.m_dimContainerSize = new Dimension(d);
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        this.m_dimContainerSize = new Dimension(width, height);
        super.setSize(width, height);
        this.doReshape();
    }

    public VC getVC() {
        return this.m_VC;
    }

    public int getMinimumAxisTextSizeVC() {
        return this.m_AxisTextSizeVC;
    }

    public void setMinimumAxisTextSizeVC(int SizeVC) {
        this.m_AxisTextSizeVC = SizeVC;
    }

    public boolean getTestLabelCalc() {
        return this.m_TestLabelCalc;
    }

    public void setTestLabelCalc(boolean testCalc) {
        this.m_TestLabelCalc = testCalc;
    }

    public boolean isChartDualY() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isDualY();
    }

    public boolean isChartBipolar() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isBipolar();
    }

    public boolean isChartOrientHorz() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isOrientHorz();
    }

    public boolean isChart3DType() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.is3DType();
    }

    public boolean isChartPieType() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isPieType();
    }

    public boolean isChartBLAType() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isBLAType();
    }

    public boolean isChartStockType() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isStockType();
    }

    public boolean isChartScatter() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isScatter();
    }

    public boolean isChartHistogram() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.isHistogram();
    }

    public boolean isO1AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasO1();
    }

    public boolean isO2AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasO2();
    }

    public boolean isX1AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasX1();
    }

    public boolean isY1AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasY1();
    }

    public boolean isY2AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasY2();
    }

    public boolean isZ1AxisPresent() {
        JGraphType gt = this.getJGraphType();
        if (gt == null) {
            return false;
        }
        return gt.getAxisDescriptor().hasZ1();
    }

    public Matrix3d getCubeRotationMatrix() {
        Matrix3d m_Obj = (Matrix3d)this.getFromLook(IdentObj.GLOBAL, Attr.CubeRotationMatrixAttr);
        return m_Obj;
    }

    public void setCubeRotationMatrix(Matrix3d m) {
        this.putToLook(IdentObj.GLOBAL, Attr.CubeRotationMatrixAttr, m);
    }

    public void setCubeRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setCubeRotationMatrix(new Matrix3d(m00, m01, m02, m10, m11, m12, m20, m21, m22));
    }

    private void newPlaceDefaultElements() {
        boolean bPlace = this.getPlace();
        if (bPlace) {
            this.place();
        }
    }

    private void place() {
        boolean bDisposeOffscreen = false;
        PlaceDefaultElements.place(this);
        this.m_bPlacing = true;
    }

    public Object getAttrValue(IdentObj id, Attr attrID) {
        return this.getFromLook(id, attrID, true);
    }

    public Image getShadowTextureURL(String szURL) {
        Image img = this.m_textureMap.get(szURL);
        if (img != null) {
            return img;
        }
        return null;
    }

    public String getShadowTextureURL(IdentObj id) {
        return (String)this.getFromLook(id, Attr.ShadowTextureURL);
    }

    public boolean getPlacing() {
        return this.m_bPlacing;
    }

    public void useFastDoubleDataStorage(int numRows, int numCols) {
        this.m_UseFastDataStorage = true;
        this.m_FastDataRows = numRows;
        this.m_FastDataCols = numCols;
        this.clearDataStorage();
    }

    public void setTextureImage(IdentObj id, UniversalPictureStruct upc) {
        this.putToLook(id, Attr.TextureURL, upc.filename);
        if (upc.image != null) {
            this.m_textureMap.put(upc.filename, upc.image);
        }
        this.pictureMap.put(upc.filename, upc);
    }

    public Iterator<UniversalPictureStruct> getPictureTableIterator() {
        return this.pictureMap.values().iterator();
    }

    public boolean isGanttChart() {
        JGraphType jgt = this.getJGraphType();
        return jgt.isGanttType();
    }

    public boolean isChartBubble() {
        JGraphType jgt = this.getJGraphType();
        return jgt.isBubble();
    }

    public void setEstimateHasOneSeries(boolean estimateHasOneSeries) {
        this.estimateHasOneSeries = estimateHasOneSeries;
    }

    public int getPGSDKLineStyle(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.PGSDKLineStyle);
    }

    public void setPGSDKLineStyle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PGSDKLineStyle, new Integer(newValue));
    }

    public int getMissingTextures() {
        return this.missingTextures;
    }

    public void setMissingTextures(int mt) {
        this.missingTextures = mt;
    }

    public IdentObj getCurrentFrame() {
        return this.isChartPieType() ? Identity.PieFrame : Identity.Frame;
    }

    public void set3TFCreationRevision(int revision) {
    }

    public void set3TFCreationSubRevision(int subrevision) {
    }

    public int get3TFCreationRevision() {
        return (Integer)Attr.TTFCreationRevision.getDefault();
    }

    public int get3TFCreationSubRevision() {
        return (Integer)Attr.TTFCreationSubRevision.getDefault();
    }

    public double getUserLineValue(IdentObj objectID) {
        return (Double)this.getFromLook(objectID, Attr.UserLineValue);
    }

    public void setUserLineValue(IdentObj objectID, double value) {
        this.putToLook(objectID, Attr.UserLineValue, value);
    }

    public int getUserLineAxis(IdentObj objectID) {
        return (Integer)this.getFromLook(objectID, Attr.UserLineAxisID);
    }

    public void setUserLineAxis(IdentObj objectID, int value) {
        this.putToLook(objectID, Attr.UserLineAxisID, value);
    }

    public boolean dataTextTemplateMatchesMacro(String macro) {
        String template = this.getJGraphType().isBubble() ? this.getDataTextTemplateBubble() : (this.getJGraphType().isScatter() ? this.getDataTextTemplateScatter() : (this.getJGraphType().isStockType() ? this.getDataTextTemplateHiLo() : this.getDataTextTemplate()));
        if (template == null || macro == null) {
            return false;
        }
        return template.indexOf(macro) >= 0;
    }

    public void setFullFrame(IdentObj id, Rectangle fullRect) {
        Rectangle frameRect = new Rectangle(fullRect);
        if (this.getJGraphType().wantDepthEffect()) {
            int depthAngle = this.getDepthAngle();
            int depthRadius = this.getDepthRadius();
            double radius = depthRadius * 10;
            int dx = (int)Math.abs(radius * Math.cos((double)depthAngle * (Math.PI / 180)));
            int dy = (int)Math.abs(radius * Math.sin((double)depthAngle * (Math.PI / 180)));
            if (depthAngle < 90) {
                frameRect.x = fullRect.x + dx;
            }
            frameRect.y = fullRect.y + dy;
            frameRect.width -= dx;
            frameRect.height -= dy;
        }
        this.setRect(id, frameRect);
    }

    public Rectangle getFullFrame(IdentObj id) {
        Rectangle rect = this.getRect(id);
        if (this.getJGraphType().wantDepthEffect()) {
            int depthAngle = this.getDepthAngle();
            int depthRadius = this.getDepthRadius();
            double radius = depthRadius * 10;
            int dx = (int)Math.abs(radius * Math.cos((double)depthAngle * (Math.PI / 180)));
            int dy = (int)Math.abs(radius * Math.sin((double)depthAngle * (Math.PI / 180)));
            if (depthAngle < 90) {
                rect.x -= dx;
            }
            rect.y -= dy;
            rect.width += dx;
            rect.height += dy;
        }
        return rect;
    }

    public void setTimeScaleAxisDefaults() {
        this.setLevelTextFormat(0, 0);
        this.setLevelTextFormat(1, 2);
        this.setLevelTextFormat(2, 2);
        this.setLevelInterval(0, 0);
        this.setLevelInterval(1, 0);
        this.setLevelInterval(2, 0);
        this.setFillColor(this.getTimeScaleLevel(0), new Color(204, 204, 204));
        this.setFillColor(this.getTimeScaleLevel(1), new Color(221, 221, 221));
        this.setFillColor(this.getTimeScaleLevel(2), new Color(238, 238, 238));
        this.setFillColor(this.getTimeScaleLevelText(0), Color.black);
        this.setFillColor(this.getTimeScaleLevelText(1), Color.black);
        this.setFillColor(this.getTimeScaleLevelText(2), Color.black);
        this.setTextJustVert(this.getTimeScaleLevelText(0), 1);
        this.setTextJustVert(this.getTimeScaleLevelText(1), 1);
        this.setTextJustVert(this.getTimeScaleLevelText(2), 1);
        this.setLevelHeight(0, 1200);
        this.setLevelHeight(1, 1200);
        this.setLevelHeight(2, 1200);
        this.setTimeScaleDataTextFormat(DateFormat.getDateInstance(3));
    }

    public boolean pgsdkToPfjO1MajorMinorGridlinesSwapped() {
        return !this.getJGraphType().isRiserArea() && !this.getJGraphType().isRiserMarker();
    }

    public IDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public TrendlineSettings getTrendlineSettings() {
        return this.trendlineSettings;
    }

    public boolean hasO1() {
        return this.getJGraphType().getAxisDescriptor().hasO1();
    }

    public boolean hasX1() {
        return this.getJGraphType().getAxisDescriptor().hasX1();
    }

    public FontRenderContext getFontRenderContext() {
        return this.m_fontRenderContext;
    }

    public boolean isPgsdkAutoArrange() {
        return this.pgsdkAutoArrange;
    }

    public void setPgsdkAutoArrange(boolean pgsdkAutoArrange) {
        this.pgsdkAutoArrange = pgsdkAutoArrange;
    }
}

