/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.IAdvFormatStructExporter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.TTFNumberFormatCallback;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class PFJDateFormat
extends Format
implements IAdvFormatStructExporter {
    public DateType dateType;
    public int dateStyle = -1;
    public int timeStyle = -1;
    public String customPattern = "";
    DateFormat dateFormat;

    private PFJDateFormat(String customPattern, Locale locale) {
        this.dateType = DateType.CUSTOM;
        this.customPattern = customPattern;
        if (customPattern.startsWith("Amigo")) {
            customPattern = TTFNumberFormatCallback.localizeAmigoDatePattern(customPattern, locale);
        }
        assert (customPattern.length() > 0);
        this.dateFormat = 0 == customPattern.length() ? DateFormat.getDateInstance(3, locale) : new SimpleDateFormat(customPattern, locale);
    }

    private PFJDateFormat(DateType dateType, int dateStyle, int timeStyle, DateFormat dateFormat) {
        this.dateType = dateType;
        this.dateFormat = dateFormat;
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
    }

    public static PFJDateFormat getDateInstance(int style, Locale locale) {
        return new PFJDateFormat(DateType.DATE, style, -1, DateFormat.getDateInstance(style, locale));
    }

    public static PFJDateFormat getTimeInstance(int style, Locale locale) {
        return new PFJDateFormat(DateType.TIME, -1, style, DateFormat.getTimeInstance(style, locale));
    }

    public static PFJDateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return new PFJDateFormat(DateType.DATETIME, dateStyle, timeStyle, DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale));
    }

    public static PFJDateFormat getCustomInstance(String customPattern, Locale locale) {
        return new PFJDateFormat(customPattern, locale);
    }

    public StringBuffer format(Object date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.dateFormat.format(date, toAppendTo, pos);
    }

    public Object parseObject(String text, ParsePosition pos) {
        return this.dateFormat.parse(text, pos);
    }

    public AdvFormatStruct toAdvFormatStruct() {
        AdvFormatStruct fmt = new AdvFormatStruct();
        switch (this.dateType) {
            case DATE: {
                fmt.szDateFormat = this.convertDateFmt();
                fmt.formatType = NumberFormatOptions.DateFormat.ordinal();
                break;
            }
            case TIME: {
                fmt.szTimeFormat = this.convertTimeFmt();
                fmt.formatType = NumberFormatOptions.TimeFormat.ordinal();
                break;
            }
            case DATETIME: {
                fmt.szDateFormat = this.convertDateFmt();
                fmt.szTimeFormat = this.convertTimeFmt();
                fmt.formatType = NumberFormatOptions.DateTimeFormat.ordinal();
                break;
            }
            case CUSTOM: {
                String timeString = "";
                String dateString = "";
                if (this.customPattern.startsWith("Amigo")) {
                    int dateEnd = this.customPattern.indexOf(")");
                    dateString = this.customPattern.substring(this.customPattern.indexOf("(") + 1, dateEnd);
                    if (this.customPattern.length() > dateEnd + 1) {
                        timeString = this.customPattern.substring(dateEnd + 1);
                    }
                } else {
                    int timeStart = this.customPattern.indexOf(104);
                    if (timeStart == -1) {
                        timeStart = this.customPattern.indexOf(72);
                    }
                    if (timeStart == -1) {
                        dateString = this.customPattern;
                    } else {
                        dateString = this.customPattern.substring(0, timeStart);
                        timeString = this.customPattern.substring(timeStart);
                    }
                }
                dateString = dateString.trim();
                timeString = timeString.trim();
                if (dateString.length() > 0 && timeString.length() > 0) {
                    fmt.formatType = NumberFormatOptions.DateTimeFormat.ordinal();
                } else if (dateString.length() > 0) {
                    fmt.formatType = NumberFormatOptions.DateFormat.ordinal();
                } else if (timeString.length() > 0) {
                    fmt.formatType = NumberFormatOptions.TimeFormat.ordinal();
                } else {
                    assert (false) : "Broken date format";
                    return fmt;
                }
                fmt.szDateFormat = PFJDateFormat.restoreDatePattern(dateString).toCharArray();
                fmt.szTimeFormat = PFJDateFormat.restoreTimePattern(timeString).toCharArray();
            }
        }
        return fmt;
    }

    private char[] convertDateFmt() {
        switch (this.dateStyle) {
            default: {
                return "MM'/'dd'/'yy".toCharArray();
            }
            case 2: {
                return "MM'/'dd'/'yyyy".toCharArray();
            }
            case 1: 
        }
        return "MMMM d','yyyy".toCharArray();
    }

    private char[] convertTimeFmt() {
        switch (this.timeStyle) {
            default: {
                return (this.isAMPM() ? "h':'mm tt" : "H':'mm").toCharArray();
            }
            case 1: 
        }
        return (this.isAMPM() ? "h':'mm':'ss tt" : "H':'mm':'ss").toCharArray();
    }

    private boolean isAMPM() {
        if (this.dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat date = (SimpleDateFormat)this.dateFormat;
            if (date.toPattern().indexOf(72) > -1) {
                return false;
            }
        } else assert (false);
        return true;
    }

    private static String restoreDatePattern(String datePattern) {
        datePattern = datePattern.replaceAll("EEEE", "dddd");
        return datePattern.replaceAll("EEE", "ddd");
    }

    private static String restoreTimePattern(String timePattern) {
        return timePattern.replace('a', 't');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateType {
        DATE,
        TIME,
        DATETIME,
        CUSTOM;

    }
}

