/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.IAdvFormatStructExporter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class MaskFormat
extends Format
implements IAdvFormatStructExporter {
    String mask;
    int maskLen;
    int digits;

    public MaskFormat(String mask) {
        this.mask = mask;
        this.maskLen = mask.length();
        this.digits = 0;
        for (int maskIndex = 0; maskIndex < this.maskLen; ++maskIndex) {
            if (mask.charAt(maskIndex) != '#') continue;
            ++this.digits;
        }
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer string = new StringBuffer(this.mask);
        assert (obj instanceof Number);
        int val = obj instanceof Number ? ((Number)obj).intValue() : 0;
        for (int index = this.maskLen - 1; index >= 0; --index) {
            if ('#' != string.charAt(index)) continue;
            string.setCharAt(index, (char)(48 + val % 10));
            val /= 10;
        }
        return toAppendTo.append(string);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public AdvFormatStruct toAdvFormatStruct() {
        AdvFormatStruct fmt = new AdvFormatStruct();
        if ("#####".equals(this.mask)) {
            fmt.formatType = NumberFormatOptions.ZipCodeFormat.ordinal();
        } else if ("#####-####".equals(this.mask)) {
            fmt.formatType = NumberFormatOptions.ZipCodePlus4Format.ordinal();
        } else if ("###-##-####".equals(this.mask)) {
            fmt.formatType = NumberFormatOptions.SSNFormat.ordinal();
        } else if ("###-####".equals(this.mask)) {
            fmt.formatType = NumberFormatOptions.PhoneFormat.ordinal();
        } else assert (false);
        return fmt;
    }
}

