/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.NDC;
import com.businessobjects.foundation.logging.StubLogger;
import com.businessobjects.foundation.logging.StubNDC;
import com.businessobjects.foundation.logging.spi.BootstrapLogger;
import com.businessobjects.foundation.logging.spi.ILoggingProvider;
import com.businessobjects.foundation.logging.spi.INDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class LoggerManager {
    public static final String LOGGING_KEY = "bobj.logging";
    public static final String LOGGING_PROVIDER_KEY = "bobj.logging.provider";
    public static final String DEFAULT_PROVIDER = "com.businessobjects.foundation.logging.log4j.Log4jProvider";
    private static ILoggingProvider s_provider;

    private static ILoggingProvider createLoggingProviderInstance(String providerName) throws ClassNotFoundException, ClassCastException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        BootstrapLogger.debug("Attempting to instance a logging provider of type " + providerName + ".");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(providerName);
        }
        catch (ClassNotFoundException e) {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(providerName);
        }
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        Object o = ctor.newInstance(null);
        ILoggingProvider p = (ILoggingProvider)o;
        BootstrapLogger.debug("Instancing was successful.");
        return p;
    }

    public static void disable() {
        LoggerManager.setProvider(new StubLoggingProvider());
    }

    public static ILogger getLogger(String name) {
        return s_provider.getLogger(name);
    }

    public static ILogger getLogger(Class clazz) {
        return s_provider.getLogger(clazz.getName());
    }

    public static Class getProviderType() {
        return s_provider instanceof StubLoggingProvider ? null : s_provider.getClass();
    }

    public static boolean isEnabled() {
        return !(s_provider instanceof StubLoggingProvider);
    }

    public static void reconfigureProvider() {
        s_provider.reconfigure();
    }

    private static void setProviderFromConfig() {
        String loggingProperty = System.getProperty(LOGGING_KEY);
        if (loggingProperty == null || Boolean.valueOf(loggingProperty).booleanValue()) {
            try {
                LoggerManager.setProvider(System.getProperty(LOGGING_PROVIDER_KEY));
            }
            catch (Throwable t) {
                BootstrapLogger.error("Could not set the configured logging provider.", t);
                BootstrapLogger.warn("Falling back to the stub implementation.");
                LoggerManager.setProvider(new StubLoggingProvider());
            }
        } else {
            LoggerManager.setProvider(new StubLoggingProvider());
            BootstrapLogger.debug("Logging is disabled; using the stub implementation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProvider(String className) throws ClassNotFoundException, ClassCastException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ILoggingProvider p = null;
        if (className == null) {
            BootstrapLogger.debug("Logging provider has not been specified; using a default provider.");
            p = LoggerManager.createLoggingProviderInstance(DEFAULT_PROVIDER);
        } else {
            p = LoggerManager.createLoggingProviderInstance(className);
        }
        boolean success = false;
        try {
            LoggerManager.setProvider(p);
            success = true;
        }
        finally {
            if (!success) {
                p.dispose();
            }
        }
    }

    public static void setProvider(ILoggingProvider p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (s_provider != null) {
            s_provider.dispose();
        }
        s_provider = p;
        p.initializeConfiguration();
        NDC.setNDCInterface(p.getNDCInterface());
    }

    static void touch() {
    }

    static {
        LoggerManager.setProviderFromConfig();
    }

    private static class StubLoggingProvider
    implements ILoggingProvider {
        static StubLogger s_stubLogger = new StubLogger();
        static StubNDC s_ndc = new StubNDC();

        private StubLoggingProvider() {
        }

        public void dispose() {
        }

        public ILogger getLogger(String name) {
            return s_stubLogger;
        }

        public INDC getNDCInterface() {
            return s_ndc;
        }

        public void initializeConfiguration() {
        }

        public void reconfigure() {
        }
    }
}

