/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.language;

import com.businessobjects.foundation.commandline.Parameters;
import com.businessobjects.foundation.language.LangException;
import com.businessobjects.foundation.language.LocaleConverter;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LocaleHelper {
    private static final ILogger LOG = LoggerManager.getLogger("com.crystaldecisions.sdk.framework.LocaleHelper");
    private static String Language_Packs_File_Name = "LanguagePacks.xml";
    private static String Language_Pack_Item = "LanguagePack";
    private static String Language_Country_Code = "LangCode";
    private static String ICOUSeparator = "_";
    public static final String BOBJ_HOME = "bobj.root.internal";
    public static final String INST_LANG = "INSTALLEDLANGUAGES";
    public static final String INST_PROP_FILE = "langpacks.properties";

    public static List getSupportedLocales() {
        List l = LocaleConverter.getLocales();
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Locale loc = (Locale)ite.next();
            String countryCode = loc.getCountry();
            if (countryCode != null && !countryCode.equals("")) continue;
            ite.remove();
        }
        return l;
    }

    public static String getBOBJHomeHelper() {
        int lastSep;
        String key = "bobj.enterprise.home";
        String enterpriseHome = System.getProperty(key);
        String defaultRootLocation = null;
        if (enterpriseHome != null && enterpriseHome != null && (lastSep = enterpriseHome.lastIndexOf(File.separator)) > 0) {
            defaultRootLocation = enterpriseHome.substring(0, lastSep);
            Parameters params = Parameters.getInstance();
            params.setProperty("bobj.home", defaultRootLocation);
        }
        return defaultRootLocation;
    }

    public static List getInstalledLocales() throws LangException {
        String fileName;
        File f;
        LOG.info("getInstalledLocales() called");
        String s_prop = System.getProperty(INST_LANG);
        if (s_prop != null) {
            LOG.info("Found Property INSTALLEDLANGUAGES");
            ArrayList<Locale> localeList = new ArrayList<Locale>();
            String[] a_prop = s_prop.split(",");
            LOG.info("Languages: " + a_prop.length);
            for (int i = 0; i < a_prop.length; ++i) {
                Locale newLocale = LocaleHelper.getInstalledLocaleHelper(a_prop[i]);
                if (localeList.contains(newLocale)) continue;
                localeList.add(newLocale);
            }
            Collections.sort(localeList, new LocaleConverter.LocaleComparator());
            return localeList;
        }
        LOG.info("Checking for langpacks.properties");
        Properties props = new Properties();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = null;
            if (cl != null) {
                url = cl.getResource(INST_PROP_FILE);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(INST_PROP_FILE);
            }
            if (url != null) {
                props.load(url.openStream());
                LOG.info("Found langpacks.properties");
                s_prop = props.getProperty(INST_LANG);
                if (s_prop != null) {
                    LOG.info("Found Property INSTALLEDLANGUAGES");
                    ArrayList<Locale> localeList = new ArrayList<Locale>();
                    String[] a_prop = s_prop.split(",");
                    LOG.info("Languages: " + a_prop.length);
                    for (int i = 0; i < a_prop.length; ++i) {
                        Locale newLocale = LocaleHelper.getInstalledLocaleHelper(a_prop[i]);
                        if (localeList.contains(newLocale)) continue;
                        localeList.add(newLocale);
                    }
                    Collections.sort(localeList, new LocaleConverter.LocaleComparator());
                    return localeList;
                }
            }
        }
        catch (IOException e) {
            LOG.info("IOException: Error while handling langpacks.properties: " + e.toString());
        }
        LOG.info("Checking for " + Language_Packs_File_Name);
        String enterpriseHome = Parameters.getInstance().getProperty(BOBJ_HOME);
        if (enterpriseHome == null) {
            enterpriseHome = LocaleHelper.getBOBJHomeHelper();
        }
        if (!(f = new File(fileName = enterpriseHome + File.separator + Language_Packs_File_Name)).exists()) {
            LOG.error("LanguagePacks.xml not found:" + fileName, new FileNotFoundException());
            throw new LangException.InstallLocaleFileNotFoundException(new FileNotFoundException(fileName));
        }
        SimpleParser handler = new SimpleParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(f, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException pce) {
            throw new LangException.InstallLocaleParseException(pce);
        }
        catch (SAXException saxe) {
            throw new LangException.InstallLocaleParseException(saxe);
        }
        catch (IOException ioe) {
            throw new LangException.InstallLocaleParseException(ioe);
        }
        catch (IllegalArgumentException iae) {
            throw new LangException.InstallLocaleParseException(iae);
        }
        return handler.getLocaleList();
    }

    private static Locale getInstalledLocaleHelper(String code) {
        Locale newLocale;
        String langCode = "en";
        String countryCode = "US";
        int index = code.indexOf(ICOUSeparator);
        if (index != -1) {
            langCode = code.substring(0, index);
            countryCode = code.substring(index + 1);
            newLocale = new Locale(langCode, countryCode);
        } else {
            newLocale = new Locale(code);
        }
        return newLocale;
    }

    public static Locale getEffectiveLocale(List locales, Locale locale) {
        Locale locLangCodeOnly;
        if (locales == null || locale == null) {
            return null;
        }
        if (locales.contains(locale)) {
            return locale;
        }
        String langCode = locale.getLanguage();
        if (!langCode.equals("zh") && !langCode.equals("sr") && locales.contains(locLangCodeOnly = new Locale(langCode))) {
            return locLangCodeOnly;
        }
        if (locales.contains(Locale.ENGLISH)) {
            return Locale.ENGLISH;
        }
        return (Locale)locales.get(0);
    }

    private static class SimpleParser
    extends DefaultHandler {
        List localeList = new ArrayList();

        private SimpleParser() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            String code;
            Locale newLocale;
            if ((sName.equalsIgnoreCase(Language_Pack_Item) || qName.equalsIgnoreCase(Language_Pack_Item)) && attrs != null && !this.localeList.contains(newLocale = LocaleHelper.getInstalledLocaleHelper(code = attrs.getValue(Language_Country_Code)))) {
                this.localeList.add(newLocale);
            }
            Collections.sort(this.localeList, new LocaleConverter.LocaleComparator());
        }

        List getLocaleList() {
            return this.localeList;
        }
    }
}

