/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.typeconversion;

import com.crystaldecisions12.reports.common.StringUtil;
import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.StringValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

class i
extends FormulaFunctionBase {
    public i(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        return FormulaValueType.currency;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        FormulaValue formulaValue = formulaValueReferenceArray[0].getFormulaValue();
        if (formulaValue.getFormulaValueType().isNumeric()) {
            if (formulaValue.getFormulaValueType() == FormulaValueType.currency) {
                return formulaValue;
            }
            return CurrencyValue.fromNumberValue((NumberValue)formulaValue);
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
            String string = ((StringValue)formulaValue).getString();
            string = string.trim();
            Locale locale = formulaEnvironment.getFormulaClient().getLocale();
            DecimalFormat decimalFormat = FormatterCache.do(locale);
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            String string2 = decimalFormatSymbols.getCurrencySymbol();
            String string3 = StringUtil.removeNegativeSymbol(string = StringUtil.removeCurrencySymbol(string, string2));
            boolean bl2 = string3.compareTo(string) != 0;
            try {
                NumberFormat numberFormat = FormatterCache.new(locale);
                Number number = numberFormat.parse(string3);
                double d10 = number.doubleValue();
                if (bl2) {
                    d10 = -d10;
                }
                return CurrencyValue.fromDouble(d10);
            }
            catch (ParseException parseException) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "StringIsNonNumeric", 0);
            }
        }
        CrystalAssert.a(false);
        return formulaValue;
    }
}

