/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.formulas.ExpressionNode;
import com.crystaldecisions12.reports.formulas.ExpressionNodeType;
import com.crystaldecisions12.reports.formulas.FieldExpression;
import com.crystaldecisions12.reports.formulas.FormulaInfo;
import com.crystaldecisions12.reports.formulas.OperatorNode;
import com.crystaldecisions12.reports.formulas.ParentNode;
import com.crystaldecisions12.reports.formulas.x;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BinaryOperatorNode
extends OperatorNode
implements FieldExpression.BinaryOperator {
    BinaryOperatorNode(ExpressionNode expressionNode, ExpressionNodeType expressionNodeType, ExpressionNode expressionNode2, ExpressionNode expressionNode3) {
        this(expressionNode, expressionNodeType);
        this.setLeftOperand(expressionNode2);
        this.setRightOperand(expressionNode3);
    }

    public BinaryOperatorNode(ExpressionNodeType expressionNodeType, ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        this(expressionNodeType);
        this.setLeftOperand(expressionNode);
        this.setRightOperand(expressionNode2);
    }

    BinaryOperatorNode(BinaryOperatorNode binaryOperatorNode, boolean bl2) {
        super((OperatorNode)binaryOperatorNode, bl2);
    }

    BinaryOperatorNode(ExpressionNode expressionNode, ExpressionNodeType expressionNodeType) {
        super(expressionNode, expressionNodeType);
        CrystalAssert.a(x.if.a(expressionNodeType));
    }

    public BinaryOperatorNode(ExpressionNodeType expressionNodeType) {
        super(expressionNodeType);
        CrystalAssert.a(x.if.a(expressionNodeType));
    }

    boolean a() {
        return this.size() < 2;
    }

    ParentNode if() {
        return new BinaryOperatorNode(this, false);
    }

    ParentNode do() {
        return new BinaryOperatorNode(this, true);
    }

    public ExpressionNode getLeftOperand() {
        return this.size() < 1 ? null : this.get(0);
    }

    public ExpressionNode getRightOperand() {
        return this.size() < 2 ? null : this.get(1);
    }

    public ExpressionNode setLeftOperand(ExpressionNode expressionNode) {
        if (this.size() == 0) {
            this.add(expressionNode);
            return null;
        }
        return this.set(0, expressionNode);
    }

    public ExpressionNode setRightOperand(ExpressionNode expressionNode) {
        if (this.size() == 0) {
            this.add(null);
            this.add(expressionNode);
            return null;
        }
        if (this.size() == 1) {
            this.add(expressionNode);
            return null;
        }
        return this.set(1, expressionNode);
    }

    public FieldExpression getLeftSubexpression() {
        return this.getLeftOperand();
    }

    public FieldExpression getRightSubexpression() {
        return this.getRightOperand();
    }

    public String toFormulaText(FormulaInfo.Syntax syntax, int n2) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = bl2 = this.getLeftOperand().size() > 1 || this.getLeftOperand().if == ExpressionNodeType.Semicolon;
        if (bl2) {
            stringBuilder.append('(');
        }
        stringBuilder.append(this.getLeftOperand().toFormulaText(syntax, n2));
        if (bl2) {
            stringBuilder.append(')');
        }
        bl2 = this.getRightOperand().size() > 1 || this.getRightOperand().if == ExpressionNodeType.Semicolon;
        boolean bl4 = false;
        switch (this.if.value()) {
            case 44: {
                stringBuilder.append(" + ");
                break;
            }
            case 45: {
                stringBuilder.append(" - ");
                break;
            }
            case 38: {
                stringBuilder.append(" * ");
                break;
            }
            case 39: {
                stringBuilder.append(" / ");
                break;
            }
            case 41: {
                stringBuilder.append(" \\ ");
                break;
            }
            case 36: {
                stringBuilder.append(" % ");
                break;
            }
            case 42: {
                stringBuilder.append(" mod ");
                break;
            }
            case 40: {
                stringBuilder.append(" ^ ");
                break;
            }
            case 43: {
                stringBuilder.append(" & ");
                break;
            }
            case 61: {
                stringBuilder.append(" = ");
                break;
            }
            case 62: {
                stringBuilder.append(" <> ");
                break;
            }
            case 56: {
                stringBuilder.append(" in ");
                break;
            }
            case 57: {
                stringBuilder.append(" < ");
                break;
            }
            case 59: {
                stringBuilder.append(" >= ");
                break;
            }
            case 58: {
                stringBuilder.append(" > ");
                break;
            }
            case 60: {
                stringBuilder.append(" <= ");
                break;
            }
            case 47: {
                stringBuilder.append(" to ");
                break;
            }
            case 48: {
                stringBuilder.append(" _to ");
                break;
            }
            case 49: {
                stringBuilder.append(" to_ ");
                break;
            }
            case 50: {
                stringBuilder.append(" _to_ ");
                break;
            }
            case 118: 
            case 119: 
            case 139: {
                stringBuilder.append(" [");
                bl4 = true;
                bl2 = false;
                break;
            }
            case 29: {
                stringBuilder.append(" := ");
                if (this.getRightOperand().if == ExpressionNodeType.Semicolon) break;
                bl2 = false;
                break;
            }
            case 65: {
                stringBuilder.append(" xor ");
                break;
            }
            case 66: {
                stringBuilder.append(" eqv ");
                break;
            }
            case 67: {
                stringBuilder.append(" imp ");
                break;
            }
            case 91: {
                stringBuilder.append(" startsWith ");
                break;
            }
            case 90: {
                stringBuilder.append(" like ");
                break;
            }
            default: {
                CrystalAssert.a(false);
                stringBuilder.append("?");
            }
        }
        if (bl2) {
            stringBuilder.append('(');
        }
        stringBuilder.append(this.getRightOperand().toFormulaText(syntax, n2));
        if (bl2) {
            stringBuilder.append(')');
        }
        if (bl4) {
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

