/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimeValue
extends FormulaValue
implements Comparable {
    public static final int nullCRTime = -1;
    public static final int hoursPerDay = 24;
    public static final int minutesPerHour = 60;
    public static final int secondsPerMinute = 60;
    public static final int secondsPerDay = 86400;
    public static final int millisecondsPerSecond = 1000;
    public static final int nanosecondsPerMillisecond = 1000000;
    public static final long nanosecondsPerSecond = 1000000000L;
    public static final long nanosecondsPerMinute = 60000000000L;
    public static final long nanosecondsPerHour = 3600000000000L;
    public static final long nanosecondsPerDay = 86400000000000L;
    public static final long minTimeInNs = 0L;
    public static final long maxTimeInNs = 86399999999999L;
    public static final TimeValue min = new TimeValue(0L);
    public static final TimeValue max = new TimeValue(86399999999999L);
    public static final TimeValue maxTimeValueInSeconds = new TimeValue(86399000000000L);
    private final long int;

    private TimeValue(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeInNs is less than minTimeInNs");
        }
        if (l2 > 86399999999999L) {
            throw new IllegalArgumentException("timeInNs is greater than maxTimeInNs");
        }
        this.int = l2;
    }

    private static long a(int n2, int n3, int n4, long l2) {
        return (long)n2 * 3600000000000L + (long)n3 * 60000000000L + (long)n4 * 1000000000L + l2;
    }

    private static long a(int n2, int n3, double d10) {
        return (long)n2 * 3600000000000L + (long)n3 * 60000000000L + Math.round(d10 * 1.0E9);
    }

    public static long NormalizeTimeInNs(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2 - 1L;
        }
        long l3 = l2 % 86400000000000L;
        return bl2 ? 86400000000000L - l3 - 1L : l3;
    }

    public static TimeValue now() {
        return TimeValue.fromCalendar(new GregorianCalendar(Locale.US));
    }

    public static TimeValue fromTimeInNs(long l2) {
        if (l2 == TimeValue.min.int) {
            return min;
        }
        if (l2 == TimeValue.max.int) {
            return max;
        }
        return new TimeValue(l2);
    }

    public static TimeValue fromCRTime(int n2) {
        if (n2 == -1) {
            return null;
        }
        if (n2 > 86400) {
            n2 %= 86400;
        }
        return TimeValue.fromTimeInNs((long)n2 * 1000000000L);
    }

    public static TimeValue fromOleDate(double d10) {
        double d11 = Math.abs(d10 - (double)((int)d10));
        return TimeValue.fromTimeInNs(Math.round(d11 * 8.64E13));
    }

    public double getOleDate() {
        return (double)this.int / 8.64E13;
    }

    public static TimeValue fromHMSN(int n2, int n3, int n4, long l2) {
        if (n2 < 0 || n2 >= 24) {
            throw new IllegalArgumentException("hours must be between 0 and 23");
        }
        if (n3 < 0 || n3 >= 60) {
            throw new IllegalArgumentException("minutes must be between 0 and 59");
        }
        if (n4 < 0 || n4 >= 60) {
            throw new IllegalArgumentException("seconds must be between 0 and 59");
        }
        if (l2 < 0L || l2 >= 1000000000L) {
            throw new IllegalArgumentException("nanseconds must be between 0 and 999999999");
        }
        return TimeValue.fromTimeInNs(TimeValue.a(n2, n3, n4, l2));
    }

    public static TimeValue fromHMS(int n2, int n3, double d10) {
        if (n2 < 0 || n2 >= 24) {
            throw new IllegalArgumentException("hours must be between 0 and 23");
        }
        if (n3 < 0 || n3 >= 60) {
            throw new IllegalArgumentException("minutes must be between 0 and 59");
        }
        if (d10 < 0.0 || d10 >= 60.0) {
            throw new IllegalArgumentException("seconds must be between 0 and 59");
        }
        return TimeValue.fromTimeInNs(TimeValue.a(n2, n3, d10));
    }

    public static TimeValue fromCalendar(Calendar calendar) {
        return TimeValue.fromHMSN(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    public long getTimeInNs() {
        return this.int;
    }

    public static int getCRTime(TimeValue timeValue) {
        return timeValue == null ? -1 : timeValue.getCRTime();
    }

    public static int getHours(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getHours();
    }

    public static int getMinutes(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getMinutes();
    }

    public static int getWholeSeconds(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getWholeSeconds();
    }

    public static long getNanoseconds(TimeValue timeValue) {
        return timeValue == null ? 0L : timeValue.getNanoseconds();
    }

    public int getCRTime() {
        return (int)(this.int / 1000000000L);
    }

    public int getHours() {
        return (int)(this.int / 3600000000000L);
    }

    public int getMinutes() {
        return (int)(this.int / 60000000000L % 60L);
    }

    public int getWholeSeconds() {
        return (int)(this.int / 1000000000L % 60L);
    }

    public double getSeconds() {
        return (double)this.int / 1.0E9 % 60.0;
    }

    public long getNanoseconds() {
        return this.int % 1000000000L;
    }

    public double getMilliseconds() {
        return (double)this.int / 1000000.0 % 1000.0;
    }

    public int getWholeMilliseconds() {
        return (int)(this.int / 1000000L % 1000L);
    }

    public ValueType getValueType() {
        return ValueType.J;
    }

    public FormulaValue coerceToTime() {
        return this;
    }

    public FormulaValue coerceToDateTime() {
        return DateTimeValue.fromDateAndTimeValues(null, this);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((TimeValue)object).int == this.int;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int hashCode() {
        return (int)(this.int ^ this.int >>> 32);
    }

    public int compareTo(Object object) {
        TimeValue timeValue = (TimeValue)object;
        if (this.int < timeValue.int) {
            return -1;
        }
        if (this.int > timeValue.int) {
            return 1;
        }
        return 0;
    }

    public TimeValue addNumberToTime(double d10) {
        return new TimeValue(TimeValue.NormalizeTimeInNs(this.int + Math.round(d10 * 1.0E9)));
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "t(" + numberFormat.format(this.getHours()) + ":" + numberFormat.format(this.getMinutes()) + ":" + numberFormat.format(this.getWholeSeconds());
        numberFormat.setMinimumIntegerDigits(9);
        string = string + "." + numberFormat.format(this.getNanoseconds()) + ")";
        return string;
    }

    public static double To1900Format(TimeValue timeValue) {
        double d10 = 86400.0;
        return (double)timeValue.getCRTime() / 86400.0;
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, this.getHours());
        calendar.set(12, this.getMinutes());
        calendar.set(13, this.getWholeSeconds());
        calendar.set(14, this.getWholeMilliseconds());
        return calendar.getTime();
    }

    public String toValueString(Locale locale) {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        calendar.set(0, 0, 0, this.getHours(), this.getMinutes(), this.getWholeSeconds());
        calendar.set(14, (int)(this.getNanoseconds() / 1000000L));
        return FormatterCache.for(locale).format((Object)calendar);
    }

    public static String toTimeValueString(TimeValue timeValue, Locale locale) {
        if (timeValue != null) {
            return timeValue.toValueString(locale);
        }
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance();
        calendar.set(0, 0, 0, TimeValue.getHours(null), TimeValue.getMinutes(null), TimeValue.getWholeSeconds(null));
        calendar.set(14, (int)(TimeValue.getNanoseconds(null) / 1000000L));
        return FormatterCache.for(locale).format((Object)calendar);
    }

    public static CrystalValue fromFormattedString(String string) {
        if (!string.startsWith("Time(") || !string.endsWith(")")) {
            CrystalAssert.a(false);
            return null;
        }
        String string2 = string = string.substring(5, string.length() - 1);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 3) {
            CrystalAssert.a(false);
            return null;
        }
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        return TimeValue.fromHMS(n2, n3, n4);
    }

    public static boolean Equals(TimeValue timeValue, TimeValue timeValue2) {
        if (timeValue == null || timeValue2 == null) {
            return false;
        }
        return timeValue.getCRTime() == timeValue2.getCRTime();
    }

    public String toValueString() {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)Locale.US);
        calendar.set(0, 0, 0, this.getHours(), this.getMinutes(), this.getWholeSeconds());
        calendar.set(14, (int)(this.getNanoseconds() / 1000000L));
        DateFormat dateFormat = FormatterCache.for(Locale.US);
        ((SimpleDateFormat)dateFormat).applyPattern("'Time('HH','mm','ss')'");
        return dateFormat.format(calendar.getTime());
    }
}

