/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.util.Comparator;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BooleanValue
extends FormulaValue
implements Comparable {
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private final boolean try;
    private static final String new = "True";
    private static final String byte = "False";

    private BooleanValue(boolean bl2) {
        this.try = bl2;
    }

    public static BooleanValue fromBoolean(boolean bl2) {
        return bl2 ? TRUE : FALSE;
    }

    public boolean getBoolean() {
        return this.try;
    }

    public ValueType getValueType() {
        return ValueType.G;
    }

    public FormulaValue coerceToNumber() {
        return this.try ? NumberValue.one : NumberValue.zero;
    }

    public FormulaValue coerceToCurrency() {
        return this.try ? CurrencyValue.one : CurrencyValue.zero;
    }

    public FormulaValue coerceToBoolean() {
        return this;
    }

    public int hashCode() {
        return this.try ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        return BooleanValue.a(this.try, ((BooleanValue)object).try);
    }

    public String toString() {
        return this.try ? "b(true)" : "b(false)";
    }

    public String toValueString(Locale locale) {
        if (this.getBoolean()) {
            return new;
        }
        return byte;
    }

    public static CrystalValue fromFormattedString(Locale locale, String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(new)) {
            return TRUE;
        }
        if (string.equalsIgnoreCase(byte)) {
            return FALSE;
        }
        return null;
    }

    public String toValueString() {
        if (this.getBoolean()) {
            return new;
        }
        return byte;
    }
}

