/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.engine.config.apache;

import com.crystaldecisions12.reports.common.CommonResources;
import com.crystaldecisions12.reports.common.engine.config.ConfigurationObserver;
import com.crystaldecisions12.reports.common.engine.config.CrystalConfigException;
import com.crystaldecisions12.reports.common.engine.config.ObservableConfiguration;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrystalConfigurationImpl
extends CompositeConfiguration
implements ObservableConfiguration {
    private static final Logger do = Logger.getLogger((String)"com.crystaldecisions12.reports.common.engine.config");
    private List new;
    private Set int;
    private int if;
    private boolean for;

    public CrystalConfigurationImpl() {
        do.debug((Object)"A new CrystalConfiguration instance created.");
        this.for = true;
    }

    public CrystalConfigurationImpl(Configuration configuration) {
        super(configuration);
        do.debug((Object)"A new CrystalConfiguration instance with custom inMemoryConfiguration created.");
        this.for = true;
    }

    public Object getProperty(String string) {
        Object object;
        int n2;
        Configuration configuration = null;
        for (n2 = this.getNumberOfConfigurations() - 1; n2 >= 0 && !(configuration = this.getConfiguration(n2)).containsKey(string); --n2) {
        }
        Object object2 = object = n2 < 0 ? null : configuration.getProperty(string);
        if (do.isDebugEnabled()) {
            do.debug((Object)("Configuration queried; key=\"" + string + "\", result=\"" + object + "\""));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTree(String string) {
        this.for = false;
        try {
            int n2 = this.getNumberOfConfigurations();
            for (int i2 = 0; i2 < n2; ++i2) {
                Configuration configuration = this.getConfiguration(i2);
                if (configuration instanceof HierarchicalConfiguration) {
                    ((HierarchicalConfiguration)configuration).clearTree(string);
                    continue;
                }
                Iterator iterator = configuration.getKeys(string);
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    configuration.clearProperty(string2);
                }
            }
        }
        finally {
            this.for = true;
        }
        this.a(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        this.holdNotifications();
        try {
            super.setProperty(string, object);
        }
        finally {
            this.releaseNotifications();
        }
    }

    private void a(ConfigurationObserver configurationObserver) {
        if (!this.for) {
            return;
        }
        if (this.if > 0) {
            if (this.int == null) {
                this.int = new HashSet();
            }
            if (do.isDebugEnabled()) {
                do.debug((Object)"Notification put on hold");
            }
            this.int.add(configurationObserver);
        } else {
            if (do.isDebugEnabled()) {
                do.debug((Object)("An instance of " + configurationObserver.getClass().getName() + " was notified."));
            }
            configurationObserver.configurationChanged(this);
        }
    }

    private void a(String string, boolean bl2) {
        if (!this.for || this.new == null) {
            return;
        }
        if (do.isDebugEnabled()) {
            do.debug((Object)("Notifying configuration observers; key=\"" + string + "\""));
        }
        int n2 = 0;
        for (ConfigurationObserver configurationObserver : this.new) {
            if (string == null) {
                this.a(configurationObserver);
                ++n2;
                continue;
            }
            String string2 = configurationObserver.getKeyPrefix();
            if (string2 != null && string2.length() != 0 && !string.startsWith(string2) && (!bl2 || !string2.startsWith(string))) continue;
            this.a(configurationObserver);
            ++n2;
        }
        if (do.isDebugEnabled()) {
            do.debug((Object)("A total of " + n2 + " configuration observers notified."));
        }
    }

    public void holdNotifications() {
        do.debug((Object)"Putting notifications on hold");
        ++this.if;
    }

    public void releaseNotifications() {
        do.debug((Object)"Removing notification hold");
        --this.if;
        if (this.if < 0) {
            this.if = 0;
            throw new IllegalStateException("Negative notification hold count");
        }
        if (this.if == 0 && this.int != null) {
            for (ConfigurationObserver configurationObserver : this.int) {
                configurationObserver.configurationChanged(this);
            }
            this.int = null;
        }
    }

    protected void addPropertyDirect(String string, Object object) {
        if (do.isDebugEnabled()) {
            do.debug((Object)("New configuration entry; key=\"" + string + "\", token=\"" + object + "\""));
        }
        super.addPropertyDirect(string, object);
        this.a(string, false);
    }

    public void addConfiguration(Configuration configuration) {
        if (do.isInfoEnabled()) {
            do.info((Object)"New configuration being added to the stack.");
        }
        super.addConfiguration(configuration);
        this.a(null, false);
    }

    public void clear() {
        if (do != null && do.isInfoEnabled()) {
            do.info((Object)"All configurations cleared.");
        }
        super.clear();
        this.a(null, false);
    }

    public void clearProperty(String string) {
        if (do.isDebugEnabled()) {
            do.debug((Object)("Configuration entry removed; key=\"" + string + "\""));
        }
        super.clearProperty(string);
        this.a(string, false);
    }

    public void clearDynamicProperty(String string) {
        if (do.isDebugEnabled()) {
            do.debug((Object)("Configuration entry removed from dynamic layer; key=\"" + string + "\""));
        }
        this.getInMemoryConfiguration().clearProperty(string);
        this.a(string, false);
    }

    public void removeConfiguration(Configuration configuration) {
        if (do.isInfoEnabled()) {
            do.info((Object)"Configuration being removed from the stack.");
        }
        super.removeConfiguration(configuration);
        this.a(null, false);
    }

    public void addObserver(ConfigurationObserver configurationObserver) {
        if (configurationObserver == null) {
            return;
        }
        if (this.new == null) {
            this.new = new ArrayList();
        }
        this.new.add(configurationObserver);
        if (do.isDebugEnabled()) {
            do.debug((Object)"New observer registered with the configuration manager.");
        }
    }

    public void removeObserver(ConfigurationObserver configurationObserver) {
        if (this.new != null && configurationObserver != null) {
            this.new.remove(configurationObserver);
            if (do.isDebugEnabled()) {
                do.debug((Object)"Observer unregistered from the configuration manager.");
            }
        }
    }

    public void pushXmlConfiguration(URL uRL) throws CrystalConfigException {
        XMLConfiguration xMLConfiguration;
        try {
            xMLConfiguration = new XMLConfiguration(uRL);
        }
        catch (ConfigurationException configurationException) {
            throw new CrystalConfigException(CommonResources.getFactory(), "CannotCreateConfig", configurationException);
        }
        this.addConfiguration((Configuration)xMLConfiguration);
    }

    public void pushXmlConfiguration(Reader reader) throws CrystalConfigException {
        XMLConfiguration xMLConfiguration = new XMLConfiguration();
        try {
            xMLConfiguration.load(reader);
        }
        catch (ConfigurationException configurationException) {
            throw new CrystalConfigException(CommonResources.getFactory(), "CannotCreateConfig", configurationException);
        }
        this.addConfiguration((Configuration)xMLConfiguration);
    }

    public void popConfiguration() throws CrystalConfigException {
        int n2 = this.getNumberOfConfigurations();
        if (n2 <= 1) {
            throw new CrystalConfigException(CommonResources.getFactory(), "NoMoreConfigs");
        }
        this.removeConfiguration(this.getConfiguration(n2 - 2));
    }
}

