/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.SaveLoadException;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.archive.ITslvInputRecordArchive;
import com.crystaldecisions.reports.common.archive.ITslvOutputRecordArchive;
import java.awt.Dimension;

public final class TwipSize {
    public static final TwipSize ZERO_SIZE = new TwipSize(0, 0);
    public static final TwipSize MAX_SIZE = new TwipSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int cx;
    public final int cy;

    public TwipSize(int n2, int n3) {
        this.cx = n2;
        this.cy = n3;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TwipSize twipSize = (TwipSize)object;
        return this.cx == twipSize.cx && this.cy == twipSize.cy;
    }

    public int hashCode() {
        return 17 * this.cx + this.cy;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TwipSize:<width=");
        stringBuilder.append(this.cx);
        stringBuilder.append("><height=");
        stringBuilder.append(this.cy);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public int getWidth() {
        return this.cx;
    }

    public int getHeight() {
        return this.cy;
    }

    public void store(ITslvOutputRecordArchive iTslvOutputRecordArchive) throws SaveLoadException, ArchiveException {
        iTslvOutputRecordArchive.storeInt32Compressed(this.cx);
        iTslvOutputRecordArchive.storeInt32Compressed(this.cy);
    }

    public static TwipSize Load(ITslvInputRecordArchive iTslvInputRecordArchive) throws SaveLoadException, ArchiveException {
        int n2 = iTslvInputRecordArchive.loadInt32Compressed();
        int n3 = iTslvInputRecordArchive.loadInt32Compressed();
        return new TwipSize(n2, n3);
    }

    public void saveContentsIn(IOutputArchive iOutputArchive) throws SaveLoadException, ArchiveException {
        iOutputArchive.storeInt32Compressed(this.cx);
        iOutputArchive.storeInt32Compressed(this.cy);
    }

    public static TwipSize LoadFrom(IInputArchive iInputArchive) throws SaveLoadException, ArchiveException {
        int n2 = iInputArchive.loadInt32Compressed();
        int n3 = iInputArchive.loadInt32Compressed();
        return new TwipSize(n2, n3);
    }

    public final Dimension getSampleSize(int n2) {
        double d10 = (double)(this.cx * n2) / 1440.0;
        double d11 = (double)(this.cy * n2) / 1440.0;
        return new Dimension((int)d10, (int)d11);
    }
}

