/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.lov.ILOVDataSource;
import com.businessobjects.prompting.internal.PasswordEncryptHelper;
import com.businessobjects.prompting.objectmodel.common.ILOVNetwork;
import com.businessobjects.prompting.objectmodel.runtime.IPromptingInfoProvider;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.SerializationHelper;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRPromptingInfoProvider
implements IPromptingInfoProvider {
    private static final String XML_INFOPROVIDER_TOKEN = "Token";
    private static final String XML_INFOPROVIDER_LOVNETWORK_OBJECT = "LOVNETWORK";
    private static final String XML_INFOPROVIDER_LOVDATASOURCE_OBJECT = "LOVDATASOURCE";
    private Map<UUID, ILOVNetwork> m_lovNetworks = new HashMap<UUID, ILOVNetwork>();
    private Map<UUID, ILOVDataSource> m_lovDataSources = new HashMap<UUID, ILOVDataSource>();
    private String m_sEnterpriseToken = null;

    public CRPromptingInfoProvider() {
    }

    public CRPromptingInfoProvider(String sRepositoryLogonToken) {
        this.m_sEnterpriseToken = sRepositoryLogonToken;
    }

    @Override
    public String getEnterpriseSessionToken() {
        return this.m_sEnterpriseToken;
    }

    @Override
    public void setEnterpriseSessionToken(String enterpriseToken) {
        this.m_sEnterpriseToken = enterpriseToken;
    }

    @Override
    public void addLOVDataSource(ILOVDataSource lovDataSource) {
        this.m_lovDataSources.put(lovDataSource.getUUID(), lovDataSource);
    }

    @Override
    public void addLOVNetwork(ILOVNetwork network) {
        this.m_lovNetworks.put(network.getUUID(), network);
    }

    @Override
    public ILOVDataSource getLOVDataSource(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("InvalidObjectURI");
        }
        return this.m_lovDataSources.get(uuid);
    }

    @Override
    public ILOVNetwork getLOVNetwork(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("InvalidObjectURI");
        }
        return this.m_lovNetworks.get(uuid);
    }

    @Override
    public Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] bLoaded) {
        Object newObject = ClassFactory.createObject(attrs, ctxt, bLoaded);
        if (eleName.equals(XML_INFOPROVIDER_LOVNETWORK_OBJECT)) {
            ILOVNetwork promptObj = (ILOVNetwork)newObject;
            this.m_lovNetworks.put(promptObj.getUUID(), promptObj);
        } else if (eleName.equals(XML_INFOPROVIDER_LOVDATASOURCE_OBJECT)) {
            ILOVDataSource promptObj = (ILOVDataSource)newObject;
            this.m_lovDataSources.put(promptObj.getUUID(), promptObj);
        }
        return newObject;
    }

    @Override
    public void endElement(String eleName, Map<Object, Object> objState) {
        if (eleName == null || eleName.length() == 0) {
            ArrayList<ILOVNetwork> tempLOVNetworks = new ArrayList<ILOVNetwork>(this.m_lovNetworks.values());
            ArrayList<ILOVDataSource> tempLOVDataSources = new ArrayList<ILOVDataSource>(this.m_lovDataSources.values());
            this.m_lovNetworks.clear();
            this.m_lovDataSources.clear();
            for (ILOVNetwork iLOVNetwork : tempLOVNetworks) {
                this.m_lovNetworks.put(iLOVNetwork.getUUID(), iLOVNetwork);
            }
            for (ILOVDataSource iLOVDataSource : tempLOVDataSources) {
                this.m_lovDataSources.put(iLOVDataSource.getUUID(), iLOVDataSource);
            }
        }
    }

    @Override
    public void readElement(String eleName, String sVal, Attributes attrs, Map<Object, Object> objState) {
        if (eleName.equals(XML_INFOPROVIDER_TOKEN)) {
            this.m_sEnterpriseToken = PasswordEncryptHelper.decryptPassword(sVal);
        }
    }

    @Override
    public void save(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        String sTypeName = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties attrs = SerializationHelper.getHeaderAttributes(sTypeName);
        writer.writeStartElement(sTypeName, attrs);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(sTypeName);
    }

    @Override
    public void save(XMLWriter writer, String sTag, XMLSerializationContext ctxt) throws IOException {
        writer.writeStartObjectElement(sTag, "2", this, ctxt);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(sTag);
    }

    @Override
    public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        String encodedToken = PasswordEncryptHelper.encryptPassword(this.m_sEnterpriseToken);
        writer.writeTextElement(XML_INFOPROVIDER_TOKEN, encodedToken, null);
        for (ILOVNetwork iLOVNetwork : this.m_lovNetworks.values()) {
            writer.writeObjectElement(iLOVNetwork, XML_INFOPROVIDER_LOVNETWORK_OBJECT, ctxt);
        }
        for (ILOVDataSource iLOVDataSource : this.m_lovDataSources.values()) {
            writer.writeObjectElement(iLOVDataSource, XML_INFOPROVIDER_LOVDATASOURCE_OBJECT, ctxt);
        }
    }

    @Override
    public void startElement(String eleName, Map<Object, Object> objState, Attributes attrs) {
    }
}

