/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.lov.ILOVContext;
import com.businessobjects.lov.ILOVDataSource;
import com.businessobjects.lov.ILOVField;
import com.businessobjects.lov.ILOVObject;
import com.businessobjects.prompting.exceptions.PromptingException;
import com.businessobjects.prompting.objectmodel.common.ILOVNetwork;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.LOVNetwork;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.crystaldecisions.sdk.framework.IEnterpriseSession;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRLOVFactory {
    private static ICELOVAbstractFactory ceLOVAbstractFactory;
    private static ILocalLOVAbstractFactory localLOVAbstractFactory;
    private static IStaticLOVAbstractFactory staticLOVAbstractFactory;

    public static CRLOVFactory getCELOVFactory(IEnterpriseSession enterpriseSession) {
        return ceLOVAbstractFactory.getCELOVFactory(enterpriseSession);
    }

    public static CRLOVFactory getLocalLOVFactory(ILOVReportDocument document) {
        return localLOVAbstractFactory.getLocalLOVFactory(document);
    }

    public static StaticLOVFactory getStaticLOVFactory() {
        return staticLOVAbstractFactory.getStaticLOVFactory();
    }

    static String getFormattedPromptValue(IPromptValue promptValue, Locale locale) {
        return localLOVAbstractFactory.getFormattedPromptValue(promptValue, locale);
    }

    public abstract ILOVDataSource makeLOVDataSource(UUID var1, String var2, String var3, List<ILOVObject> var4);

    public abstract ILOVObject makeLOVObject(UUID var1, String var2, List<UUID> var3, ILOVContext.FilterType var4, List<ILOVField> var5);

    public abstract ILOVField makeLOVField(UUID var1, String var2, String var3, String var4, PromptValueType var5, int var6, int var7);

    public ILOVNetwork makeLOVNetwork(UUID id, String name, String enterpriseURI, String description, ILOVDataSource lovDataSource, List<IPrompt> prompts) throws PromptingException.InvalidNetworkException {
        return new LOVNetwork(id, name, enterpriseURI, description, lovDataSource, prompts);
    }

    static {
        block2: {
            try {
                ceLOVAbstractFactory = (ICELOVAbstractFactory)Class.forName("com.businessobjects.reports.crlov.CELOV").newInstance();
                localLOVAbstractFactory = (ILocalLOVAbstractFactory)Class.forName("com.businessobjects.reports.crlov.LocalLOV").newInstance();
                staticLOVAbstractFactory = (IStaticLOVAbstractFactory)Class.forName("com.businessobjects.reports.crlov.StaticLOV").newInstance();
            }
            catch (Exception e10) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Failed to initialize LOV Factories");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StaticLOVFactory
    extends CRLOVFactory {
        public abstract ILOVObject makeStaticLOVObject(UUID var1, String var2, List<UUID> var3, ILOVContext.FilterType var4, List<ILOVField> var5, List<IPromptValue.IPromptValueList> var6);
    }

    public static interface ICELOVDataSource
    extends ILOVDataSource {
    }

    public static interface ILocalLOVDataSource
    extends ILOVDataSource {
    }

    public static interface IStaticLOVDataSource
    extends ILOVDataSource {
    }

    public static interface IStaticLOVAbstractFactory {
        public StaticLOVFactory getStaticLOVFactory();
    }

    public static interface ILocalLOVAbstractFactory {
        public CRLOVFactory getLocalLOVFactory(ILOVReportDocument var1);

        public String getFormattedPromptValue(IPromptValue var1, Locale var2);
    }

    public static interface ICELOVAbstractFactory {
        public CRLOVFactory getCELOVFactory(IEnterpriseSession var1);
    }

    public static interface ILOVReportDocument {
    }
}

