/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.window;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataPushMode;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataWindow;
import com.businessobjects.visualization.dataexchange.data.generated.XMLWindowManager;
import com.businessobjects.visualization.graphicengine.GraphicEngine;
import com.businessobjects.visualization.rendering.RenderEngine;
import com.businessobjects.visualization.window.DataWindow;
import com.businessobjects.visualization.window.MeasureRange;
import com.businessobjects.visualization.window.WindowSize;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class DataWindowManager
implements IXMLDelegator {
    public static final int FULL_PUSH = 0;
    public static final int ADHOC_PUSH = 1;
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$window$DataWindowManager == null ? (class$com$businessobjects$visualization$window$DataWindowManager = DataWindowManager.class$("com.businessobjects.visualization.window.DataWindowManager")) : class$com$businessobjects$visualization$window$DataWindowManager).getName());
    private final GraphicInstance gi_;
    private DataWindow currentGraphicWindow_;
    private boolean windowModeFlag_;
    private int[] indexesUpperLimits_;
    private boolean isFixedScale_;
    private int dataPushMode_;
    static /* synthetic */ Class class$com$businessobjects$visualization$window$DataWindowManager;

    public DataWindowManager(GraphicInstance gi) {
        this.gi_ = gi;
        this.currentGraphicWindow_ = null;
        this.isFixedScale_ = true;
        this.setLimits(gi.getDataAdapter());
    }

    public int getDataPushMode() {
        return this.dataPushMode_;
    }

    public void setDataPushMode(int dataPushMode) {
        this.dataPushMode_ = dataPushMode;
        this.indexesUpperLimits_ = null;
    }

    public DataWindowManager(XMLWindowManager xmlWindowManager, SerializationHelper sh, GraphicInstance gi) {
        this(gi);
        this.isFixedScale_ = xmlWindowManager.m_a_fixedScale;
        this.dataPushMode_ = xmlWindowManager.m_a_dataPushMode == null ? 0 : (xmlWindowManager.m_a_dataPushMode.get() == 0 ? 0 : 1);
        this.currentGraphicWindow_ = new DataWindow(xmlWindowManager.m_dataWindow, sh, gi.getDataDescriptor().getDatasetDescriptor());
    }

    public void setLimits(DataAdapter da) {
        if (da == null || !da.isFilled()) {
            return;
        }
        int numAxis = da.getDataset().getAxisList().length;
        this.indexesUpperLimits_ = new int[numAxis];
        IValuesGrid aGrid = da.getDataset().getValueGroupList()[0].getMeasureValuesList()[0].getGridCallback();
        if (numAxis == 1) {
            this.indexesUpperLimits_[0] = aGrid.getSerie(0, 0).length - 1;
        } else if (numAxis == 2) {
            this.indexesUpperLimits_[1] = aGrid.getSeriesCount() - 1;
            this.indexesUpperLimits_[0] = aGrid.getSerie(0, 0).length - 1;
        } else if (numAxis == 3) {
            throw new NotImplementedException();
        }
    }

    public int[] getLimits() {
        if (this.indexesUpperLimits_ != null) {
            return this.indexesUpperLimits_;
        }
        return new int[0];
    }

    public WindowSize getDataWindowBestSize() {
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
            return graphicEngine.getDataWindowBestSize(this.gi_);
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
        }
    }

    public WindowSize getDataWindowMaximumSize() {
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
            return graphicEngine.getDataWindowMaximumSize(this.gi_);
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
        }
    }

    public WindowSize getDataWindowBestSize(int[] axesLimit) {
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
            return graphicEngine.getDataWindowBestSize(this.gi_, axesLimit);
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
        }
    }

    public void setDataWindow(DataWindow gw) {
        if (gw == null) {
            this.currentGraphicWindow_ = null;
            return;
        }
        int[] limits = this.getLimits();
        int numAxis = gw.getDataRangeByAxis().length;
        DataRange[] newRanges = new DataRange[numAxis];
        for (int i = 0; i < numAxis; ++i) {
            if (limits.length > i && gw.getDataRangeByAxis()[i].getUpper() > limits[i] && this.dataPushMode_ != 1) {
                throw new VisualizationRuntimeException("VIZ_00139_ERR_UPPER_INDEX___0___TO", new Object[]{new Integer(gw.getDataRangeByAxis()[i].getUpper()), new Integer(limits[i])});
            }
            newRanges[i] = new DataRange(gw.getDataRangeByAxis()[i].getLower(), gw.getDataRangeByAxis()[i].getUpper());
        }
        this.currentGraphicWindow_ = DataWindow.getNewWindow(newRanges, new MeasureRange(gw.getMeasureRange()));
    }

    public DataWindow getDataWindow() {
        return this.currentGraphicWindow_;
    }

    public DataWindow checkDataWindow() {
        if (this.windowModeFlag_) {
            return this.getDataWindow();
        }
        return null;
    }

    private GraphicInstance getGraphicInstanceCopy(GraphicInstance gi) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        gi.serialize(bos);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        GraphicInstance tempGi = gi.getLocalizedEngine().getGraphicInstance(bis);
        tempGi.setDataAdapter(gi.getDataAdapter());
        return tempGi;
    }

    public RenderEngine getWindowedGraphic(int outputType, int retrieveMap) {
        GraphicInstance tempGi = this.getGraphicInstanceCopy(this.gi_);
        tempGi.getWindowManager().windowModeFlag_ = true;
        return tempGi.makeGraph(outputType, retrieveMap);
    }

    public RenderEngine getGlobalGraphic(int outputType, int retrieveMap) {
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
            GraphicInstance tempGi = this.getGraphicInstanceCopy(this.gi_);
            return graphicEngine.process(tempGi, outputType, retrieveMap, true);
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(this.gi_.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
        }
    }

    public static boolean supportsWindowing(GraphicDescription graphicDesc) {
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(graphicDesc.getPublicGraphic().getGraphicDef().getProviderDescription().getLoaderClass());
            return graphicEngine.supportsWindowing(graphicDesc.getPublicGraphic());
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(graphicDesc.getProvider().getId(), objThrowable);
        }
    }

    public boolean hasNext() {
        if (this.currentGraphicWindow_ == null) {
            return false;
        }
        if (this.currentGraphicWindow_.isFullRange()) {
            return false;
        }
        if (this.dataPushMode_ == 1) {
            return false;
        }
        if (this.indexesUpperLimits_ == null) {
            throw new VisualizationRuntimeException("VIZ_00067_ERR_CANNOT_CHECK_HASNEXT");
        }
        if (this.currentGraphicWindow_.getMeasureRange().hasNext()) {
            return true;
        }
        for (int i = 0; i < this.indexesUpperLimits_.length; ++i) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("hasNext(" + i + "), current: " + this.currentGraphicWindow_.getDataRangeByAxis()[i].getUpper() + " , limit:" + this.indexesUpperLimits_[i]));
            }
            if (this.currentGraphicWindow_.getDataRangeByAxis()[i].equals(DataRange.FULL_RANGE) || this.currentGraphicWindow_.getDataRangeByAxis()[i].getUpper() >= this.indexesUpperLimits_[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.currentGraphicWindow_ == null) {
            return false;
        }
        if (this.currentGraphicWindow_.isFullRange()) {
            return false;
        }
        if (this.currentGraphicWindow_.getMeasureRange().hasPrevious()) {
            return true;
        }
        if (this.dataPushMode_ == 1) {
            return false;
        }
        int[] startIndexes = this.currentGraphicWindow_.getWindowStartIndexes();
        boolean bOk = false;
        for (int i = 0; i < startIndexes.length; ++i) {
            if (startIndexes[i] <= 0) continue;
            bOk = true;
            break;
        }
        return bOk;
    }

    public DataWindow next() {
        DataRange range;
        if (this.currentGraphicWindow_ == null) {
            throw new VisualizationRuntimeException("VIZ_00068_ERR_NULL_CURRENT_WINDOW_");
        }
        if (this.indexesUpperLimits_ == null) {
            throw new VisualizationRuntimeException("VIZ_00069_ERR_NO_UPPER_LIMITS_DEFI");
        }
        int[] startIndexes = this.currentGraphicWindow_.getWindowStartIndexes();
        int measureStartIndex = this.currentGraphicWindow_.getMeasuresStartIndex();
        WindowSize windowSize = this.currentGraphicWindow_.getWindowSize();
        int numAxis = this.indexesUpperLimits_.length;
        boolean bIncrementFirstAxis = false;
        boolean bSkipAxis = false;
        if (windowSize.getMeasureCount() > 0) {
            if (this.currentGraphicWindow_.getMeasureRange().hasNext()) {
                measureStartIndex = this.currentGraphicWindow_.getMeasureRange().next().getLower();
                bSkipAxis = true;
            } else {
                measureStartIndex = 0;
            }
        }
        if (numAxis == 2 && !bSkipAxis) {
            range = this.currentGraphicWindow_.getDataRangeByAxis()[1];
            if (!range.equals(DataRange.FULL_RANGE)) {
                if (range.getUpper() < this.indexesUpperLimits_[1]) {
                    startIndexes[1] = startIndexes[1] + 1;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("next(1): " + startIndexes[1]));
                    }
                } else {
                    startIndexes[1] = 0;
                    bIncrementFirstAxis = true;
                }
            } else {
                bIncrementFirstAxis = true;
            }
        }
        if (!(numAxis != 1 && !bIncrementFirstAxis || bSkipAxis || (range = this.currentGraphicWindow_.getDataRangeByAxis()[0]).equals(DataRange.FULL_RANGE) || range.getUpper() >= this.indexesUpperLimits_[0])) {
            startIndexes[0] = startIndexes[0] + 1;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("next(0): " + startIndexes[0]));
            }
        }
        this.currentGraphicWindow_ = DataWindow.getNewWindow(startIndexes, measureStartIndex, windowSize);
        return this.currentGraphicWindow_;
    }

    public DataWindow previous() {
        DataRange range;
        if (this.currentGraphicWindow_ == null) {
            throw new VisualizationRuntimeException("VIZ_00070_ERR_NULL_CURRENT_WINDOW_");
        }
        int[] startIndexes = this.currentGraphicWindow_.getWindowStartIndexes();
        int measureStartIndex = this.currentGraphicWindow_.getMeasuresStartIndex();
        WindowSize windowSize = this.currentGraphicWindow_.getWindowSize();
        int numAxis = this.indexesUpperLimits_.length;
        boolean bDecrementFirstAxis = false;
        boolean bSkipAxis = false;
        if (windowSize.getMeasureCount() > 0) {
            if (this.currentGraphicWindow_.getMeasureRange().hasPrevious()) {
                measureStartIndex = this.currentGraphicWindow_.getMeasureRange().previous().getLower();
                bSkipAxis = true;
            } else {
                measureStartIndex = this.currentGraphicWindow_.getMeasureRange().getUpperIndexLimit() - windowSize.getMeasureCount();
            }
        }
        if (numAxis == 2 && !bSkipAxis) {
            range = this.currentGraphicWindow_.getDataRangeByAxis()[1];
            if (!range.equals(DataRange.FULL_RANGE)) {
                if (range.getLower() > 0) {
                    startIndexes[1] = startIndexes[1] - 1;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("previous(1): " + startIndexes[1]));
                    }
                } else {
                    startIndexes[1] = this.indexesUpperLimits_[1] - windowSize.getCountByAxis()[1] + 1;
                    bDecrementFirstAxis = true;
                }
            } else {
                bDecrementFirstAxis = true;
            }
        }
        if (!(numAxis != 1 && !bDecrementFirstAxis || bSkipAxis || (range = this.currentGraphicWindow_.getDataRangeByAxis()[0]).equals(DataRange.FULL_RANGE) || range.getLower() <= 0)) {
            startIndexes[0] = startIndexes[0] - 1;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("previous(0): " + startIndexes[0]));
            }
        }
        this.currentGraphicWindow_ = DataWindow.getNewWindow(startIndexes, measureStartIndex, windowSize);
        return this.currentGraphicWindow_;
    }

    public DataWindow resizeCurrent(WindowSize windowSize) {
        int iLower;
        if (this.currentGraphicWindow_ == null) {
            throw new VisualizationRuntimeException("VIZ_00071_ERR_NO_WINDOW_DEFINED_YE");
        }
        DataRange[] dataRanges = this.currentGraphicWindow_.getDataRangeByAxis();
        MeasureRange measureRange = this.currentGraphicWindow_.getMeasureRange();
        DataRange[] newDataRanges = new DataRange[2];
        for (int i = 0; i < dataRanges.length; ++i) {
            if (windowSize.getCountByAxis()[i] == -3) {
                newDataRanges[i] = DataRange.FULL_RANGE;
                continue;
            }
            if (windowSize.getCountByAxis()[i] == -1) {
                throw new VisualizationRuntimeException("VIZ_00140_ERR_CANNOT_RESIZE_WITH_U", new Object[]{new Integer(i)});
            }
            if (dataRanges[i].getLower() + windowSize.getCountByAxis()[i] > this.indexesUpperLimits_[i]) {
                iLower = this.indexesUpperLimits_[i] - windowSize.getCountByAxis()[i] + 1;
                if (iLower < 0) {
                    newDataRanges[i] = DataRange.FULL_RANGE;
                    continue;
                }
                newDataRanges[i] = new DataRange(iLower, this.indexesUpperLimits_[i]);
                continue;
            }
            newDataRanges[i] = new DataRange(dataRanges[i].getLower(), dataRanges[i].getLower() + windowSize.getCountByAxis()[i] - 1);
        }
        MeasureRange newMeasureRange = null;
        if (windowSize.getMeasureCount() == -3) {
            newMeasureRange = MeasureRange.FULL_RANGE;
        } else {
            if (windowSize.getMeasureCount() == -1) {
                throw new VisualizationRuntimeException("VIZ_00072_ERR_CANNOT_RESIZE_WITH_U");
            }
            newMeasureRange = measureRange.equals(MeasureRange.FULL_RANGE) ? new MeasureRange(0, windowSize.getMeasureCount(), this.gi_.getDataDescriptor().getDatasetDescriptor()) : (measureRange.getLower() + windowSize.getMeasureCount() > measureRange.getUpperIndexLimit() ? ((iLower = measureRange.getUpperIndexLimit() - windowSize.getMeasureCount()) < 0 ? MeasureRange.FULL_RANGE : new MeasureRange(iLower, measureRange.getUpperIndexLimit() - 1, measureRange.getDataset())) : new MeasureRange(measureRange.getLower(), measureRange.getLower() + windowSize.getMeasureCount() - 1, measureRange.getDataset()));
        }
        this.currentGraphicWindow_ = DataWindow.getNewWindow(newDataRanges, newMeasureRange);
        return this.currentGraphicWindow_;
    }

    public void setFixedScale(boolean isFixedScale) {
        this.isFixedScale_ = isFixedScale;
    }

    public boolean isFixedScale() {
        return this.isFixedScale_;
    }

    public Object getXMLDelegate() {
        XMLWindowManager xmlWindowManager = new XMLWindowManager();
        xmlWindowManager.m_a_fixedScale = this.isFixedScale_;
        xmlWindowManager.m_a_dataPushMode = this.dataPushMode_ == 0 ? new XMLDataPushMode(0) : new XMLDataPushMode(1);
        if (this.currentGraphicWindow_ != null) {
            xmlWindowManager.m_dataWindow = (XMLDataWindow)this.currentGraphicWindow_.getXMLDelegate();
        }
        return xmlWindowManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

