/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.util.xml;

import com.businessobjects.visualization.util.xml.XmlReader;
import org.xmlpull.v1.XmlPullParserException;

public class XmlException
extends Exception {
    private final int line;
    private final int column;

    public XmlException() {
        this.line = -1;
        this.column = -1;
    }

    public XmlException(String message) {
        super(message);
        this.line = -1;
        this.column = -1;
    }

    public XmlException(Throwable cause) {
        super(cause);
        this.line = -1;
        this.column = -1;
    }

    public XmlException(String message, Throwable cause) {
        super(message, cause);
        this.line = -1;
        this.column = -1;
    }

    public XmlException(String message, XmlReader reader, Throwable cause) {
        super(message, cause);
        if (reader != null) {
            this.line = reader.getLineNumber();
            this.column = reader.getColumnNumber();
        } else {
            this.line = -1;
            this.column = -1;
        }
    }

    private XmlException(String message, Throwable cause, int aLine, int aColumn) {
        super(message, cause);
        this.line = aLine;
        this.column = aColumn;
    }

    static XmlException createXmlException(XmlPullParserException e) {
        return new XmlException(e.getMessage(), e.getDetail(), e.getLineNumber(), e.getColumnNumber());
    }

    public final int getLineNumber() {
        return this.line;
    }

    public final int getColumnNumber() {
        return this.column;
    }

    public final String toString() {
        String s = super.toString();
        int extraBufferSize = 9;
        StringBuffer buffer = new StringBuffer(s.length() + 9);
        if (this.line >= 0) {
            buffer.append(this.line).append(':').append(this.column).append(": ");
        }
        buffer.append(s);
        return buffer.toString();
    }
}

