/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public final class FileHelper {
    private FileHelper() {
    }

    public static String getContents(File aFile) throws FileNotFoundException, IOException {
        return FileHelper.getContents(aFile, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile, String anEncoding) throws FileNotFoundException, IOException {
        InputStreamReader objInputStreamReader;
        FileInputStream objFileInputStream;
        StringBuffer contents;
        block8: {
            contents = new StringBuffer();
            objFileInputStream = null;
            objInputStreamReader = null;
            BufferedReader input = null;
            try {
                objFileInputStream = new FileInputStream(aFile);
                objInputStreamReader = new InputStreamReader((InputStream)objFileInputStream, anEncoding);
                input = new BufferedReader(objInputStreamReader);
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
                Object var8_7 = null;
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (input != null) {
                    input.close();
                }
                if (objFileInputStream != null) {
                    objFileInputStream.close();
                }
                if (objInputStreamReader != null) {
                    objInputStreamReader.close();
                }
                throw throwable;
            }
            input.close();
        }
        if (objFileInputStream != null) {
            objFileInputStream.close();
        }
        if (objInputStreamReader != null) {
            objInputStreamReader.close();
        }
        return contents.toString();
    }

    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        FileHelper.setContents(aFile, aContents, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents, String anEncoding) throws FileNotFoundException, IOException {
        OutputStreamWriter objOutputStreamWriter;
        FileOutputStream objFileOutputStream;
        block8: {
            if (aFile == null) {
                throw new IllegalArgumentException("File should not be null.");
            }
            objFileOutputStream = null;
            objOutputStreamWriter = null;
            Writer output = null;
            try {
                objFileOutputStream = new FileOutputStream(aFile);
                objOutputStreamWriter = new OutputStreamWriter((OutputStream)objFileOutputStream, anEncoding);
                output = new BufferedWriter(objOutputStreamWriter);
                output.write(aContents);
                Object var7_6 = null;
                if (output == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (output != null) {
                    output.close();
                }
                if (objFileOutputStream != null) {
                    objFileOutputStream.close();
                }
                if (objOutputStreamWriter != null) {
                    objOutputStreamWriter.close();
                }
                throw throwable;
            }
            output.close();
        }
        if (objFileOutputStream != null) {
            objFileOutputStream.close();
        }
        if (objOutputStreamWriter != null) {
            objOutputStreamWriter.close();
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void emptydir(String dirPath) {
        File dirToEmpty = new File(dirPath);
        if (dirToEmpty.isDirectory()) {
            File[] tabFiles = dirToEmpty.listFiles();
            for (int i = 0; i < tabFiles.length; ++i) {
                if (!tabFiles[i].isFile()) continue;
                tabFiles[i].delete();
            }
        }
    }
}

