/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.graphic.VisuValueType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuFont
extends VisuObject {
    private static final int[] PARAMSIZE = new int[]{4, 5};
    private static VisuObjectType type = VisuObjectType.FONT;
    private VisuString fontName_;
    private VisuDouble fontSize_;
    private VisuInteger fontStyle_;
    private VisuRGBA fontColor_;
    private VisuRGBA fontEdgeColor_;

    public VisuFont(String name, double size, int style, VisuRGBA color) {
        this.initFields(name, size, style, color, null);
    }

    public VisuFont(String name, double size, int style, VisuRGBA color, VisuRGBA edgeColor) {
        this.initFields(name, size, style, color, edgeColor);
    }

    private void initFields(String name, double size, int style, VisuRGBA color, VisuRGBA edgeColor) {
        if (name != null && name.length() > 0) {
            this.fontName_ = new VisuString(name);
        }
        if (size >= 0.0) {
            this.fontSize_ = new VisuDouble(size);
        }
        if (style >= 0) {
            this.fontStyle_ = new VisuInteger(style);
        }
        this.fontColor_ = color;
        this.fontEdgeColor_ = edgeColor;
    }

    public VisuFont(VisuString name, VisuInteger size, VisuInteger style, VisuRGBA color) {
        this.fontName_ = name;
        this.fontSize_ = new VisuDouble(size.intValue());
        this.fontStyle_ = style;
        this.fontColor_ = color;
    }

    public VisuFont(VisuString name, VisuDouble size, VisuInteger style, VisuRGBA color) {
        this.fontName_ = name;
        this.fontSize_ = size;
        this.fontStyle_ = style;
        this.fontColor_ = color;
    }

    public VisuFont(VisuString name, VisuInteger size, VisuInteger style, VisuRGBA color, VisuRGBA edgeColor) {
        this.fontName_ = name;
        this.fontSize_ = new VisuDouble(size.intValue());
        this.fontStyle_ = style;
        this.fontColor_ = color;
        this.fontEdgeColor_ = edgeColor;
    }

    public VisuFont(VisuString name, VisuDouble size, VisuInteger style, VisuRGBA color, VisuRGBA edgeColor) {
        this.fontName_ = name;
        this.fontSize_ = size;
        this.fontStyle_ = style;
        this.fontColor_ = color;
        this.fontEdgeColor_ = edgeColor;
    }

    public VisuFont(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public VisuString getName() {
        return this.fontName_;
    }

    public VisuDouble getHeight() {
        return this.fontSize_;
    }

    public VisuInteger getStyle() {
        return this.fontStyle_;
    }

    public VisuRGBA getFontColor() {
        return this.fontColor_;
    }

    public void setFontColor(VisuRGBA color) {
        this.fontColor_ = color;
    }

    public String toString() {
        String s = "font: " + this.fontName_ + " size:" + this.fontSize_ + " style:" + this.fontStyle_ + " color:" + this.fontColor_.toString();
        if (this.fontEdgeColor_ != null) {
            s = s + " edge color:" + this.fontEdgeColor_;
        }
        return s;
    }

    public VisuObjectType getType() {
        return type;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuFont.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        String xmlValue = "[" + (this.fontName_ == null ? "" : this.fontName_.getXmlValue()) + "];[" + (this.fontSize_ == null ? "" : this.fontSize_.getXmlValue()) + "];[" + (this.fontStyle_ == null ? "" : this.fontStyle_.getXmlValue()) + "];[" + (this.fontColor_ == null ? "" : this.fontColor_.getXmlValue()) + "];[" + (this.fontEdgeColor_ == null ? "" : this.fontEdgeColor_.getXmlValue()) + "]";
        return xmlValue;
    }

    private void setXmlValue(String[] values) {
        this.checkParams(values, PARAMSIZE);
        this.fontName_ = values[0].equals("") ? null : new VisuString(values[0]);
        this.fontSize_ = values[1].equals("") ? null : new VisuDouble(values[1]);
        this.fontStyle_ = values[2].equals("") ? null : new VisuInteger(values[2]);
        VisuRGBA visuRGBA = this.fontColor_ = values[3].equals("") ? null : new VisuRGBA(values[3]);
        if (values.length == 5) {
            this.fontEdgeColor_ = values[4].equals("") ? null : new VisuRGBA(values[4]);
        }
    }

    protected boolean isPartial() {
        boolean result = false;
        if (this.fontName_ == null || this.fontSize_ == null || this.fontStyle_ == null || this.fontColor_ == null) {
            result = true;
        }
        return result;
    }

    protected VisuObject cloneAsPartial(VisuObject defaultValue) {
        VisuRGBA param4;
        VisuRGBA param3;
        VisuInteger param2;
        VisuDouble param1;
        if (!(defaultValue instanceof VisuFont)) {
            throw new VisualizationRuntimeException("VIZ_00122_ERR_INVALID_DEFAULTVALUE", new Object[]{defaultValue.getType()});
        }
        VisuFont defaultFont = (VisuFont)defaultValue;
        VisuString param0 = this.fontName_;
        if (param0 == null) {
            param0 = defaultFont.getName();
            param0.setVisuValueType(VisuValueType.DEFAULT);
        }
        if ((param1 = this.fontSize_) == null) {
            param1 = defaultFont.getHeight();
            param1.setVisuValueType(VisuValueType.DEFAULT);
        }
        if ((param2 = this.fontStyle_) == null) {
            param2 = defaultFont.getStyle();
            param2.setVisuValueType(VisuValueType.DEFAULT);
        }
        if ((param3 = this.fontColor_) == null) {
            param3 = defaultFont.getFontColor();
            param3.setVisuValueType(VisuValueType.DEFAULT);
        }
        if ((param4 = this.fontEdgeColor_) == null && (param4 = defaultFont.getFontEdgeColor()) != null) {
            param4.setVisuValueType(VisuValueType.DEFAULT);
        }
        VisuFont result = new VisuFont(param0, param1, param2, param3, param4);
        result.setVisuValueType(VisuValueType.PARTIAL);
        return result;
    }

    public VisuRGBA getFontEdgeColor() {
        return this.fontEdgeColor_;
    }

    protected boolean checkValidity(Object param) {
        if (param != null) {
            VisuInteger vi = (VisuInteger)param;
            int extraStyle = vi.intValue();
            if ((extraStyle & 0x10) == 0 && this.fontEdgeColor_ != null) {
                throw new VisualizationInternalException("edge color not supported for this object");
            }
            if ((extraStyle & 4) == 0 && this.fontStyle_ != null && (this.fontStyle_.intValue() & 4) != 0) {
                throw new VisualizationInternalException("underline style not supported for this object");
            }
            if ((extraStyle & 8) == 0 && this.fontStyle_ != null && (this.fontStyle_.intValue() & 8) != 0) {
                throw new VisualizationInternalException("strikeout style not supported for this object");
            }
        }
        return true;
    }

    protected Object clone() {
        VisuFont vf = (VisuFont)super.clone();
        vf.fontName_ = this.fontName_ == null ? null : (VisuString)this.fontName_.clone();
        vf.fontSize_ = this.fontSize_ == null ? null : (VisuDouble)this.fontSize_.clone();
        vf.fontStyle_ = this.fontStyle_ == null ? null : (VisuInteger)this.fontStyle_.clone();
        vf.fontColor_ = this.fontColor_ == null ? null : (VisuRGBA)this.fontColor_.clone();
        vf.fontEdgeColor_ = this.fontEdgeColor_ == null ? null : (VisuRGBA)this.fontEdgeColor_.clone();
        return vf;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuFont) {
            VisuFont vf = (VisuFont)obj;
            if (this.fontColor_ == null && vf.fontColor_ != null || this.fontColor_ != null && vf.fontColor_ == null) {
                result = false;
            } else if (this.fontEdgeColor_ == null && vf.fontEdgeColor_ != null || this.fontEdgeColor_ != null && vf.fontEdgeColor_ == null) {
                result = false;
            } else if (this.fontName_ == null && vf.fontName_ != null || this.fontName_ != null && vf.fontName_ == null) {
                result = false;
            } else if (this.fontSize_ == null && vf.fontSize_ != null || this.fontSize_ != null && vf.fontSize_ == null) {
                result = false;
            } else if (this.fontStyle_ == null && vf.fontStyle_ != null || this.fontStyle_ != null && vf.fontStyle_ == null) {
                result = false;
            } else if ((vf.fontColor_ == null && this.fontColor_ == null || vf.fontColor_.equals(this.fontColor_)) && (vf.fontEdgeColor_ == null && this.fontEdgeColor_ == null || vf.fontEdgeColor_.equals(this.fontEdgeColor_)) && (vf.fontName_ == null && this.fontName_ == null || vf.fontName_.equals(this.fontName_)) && (vf.fontSize_ == null && this.fontSize_ == null || vf.fontSize_.equals(this.fontSize_)) && (vf.fontStyle_ == null && this.fontStyle_ == null || vf.fontStyle_.equals(this.fontStyle_))) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("name", this.fontName_.toString());
            jsonObj.put("size", new Double(this.fontSize_.doubleValue()));
            jsonObj.put("style", new Integer(this.fontStyle_.intValue()));
            jsonObj.put("color", this.fontColor_.getJSONObject());
            if (this.fontEdgeColor_ != null) {
                jsonObj.put("edgecolor", this.fontEdgeColor_.getJSONObject());
            }
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuFont(JSONObject jobj) {
        try {
            this.fontName_ = new VisuString(jobj.getString("name"));
            this.fontSize_ = new VisuDouble(jobj.getDouble("size"));
            this.fontStyle_ = new VisuInteger(jobj.getInt("style"));
            JSONObject colorJson = jobj.getJSONObject("color");
            this.fontColor_ = (VisuRGBA)VisuObject.createFromJSON(colorJson.toString());
            if (!jobj.isNull("edgecolor")) {
                JSONObject edgecolorJson = jobj.getJSONObject("edgecolor");
                this.fontEdgeColor_ = (VisuRGBA)VisuObject.createFromJSON(edgecolorJson.toString());
            }
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

