/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.HSL;
import com.businessobjects.visualization.graphic.VisuRGBA;

final class RGBHSL {
    private RGBHSL() {
    }

    public static VisuRGBA setBrightness(VisuRGBA c, double brightness) {
        HSL hsl = RGBHSL.rgb2hsl(c);
        hsl.setL(brightness);
        return RGBHSL.hsl2Rgb(hsl);
    }

    public static VisuRGBA modifyBrightness(VisuRGBA c, double brightness) {
        HSL hsl = RGBHSL.rgb2hsl(c);
        hsl.setL(brightness * hsl.getL());
        return RGBHSL.hsl2Rgb(hsl);
    }

    private static VisuRGBA hsl2Rgb(HSL hsl) {
        double b;
        double g;
        double r;
        if (hsl.getL() == 0.0) {
            r = 0.0;
            g = 0.0;
            b = 0.0;
        } else if (hsl.getS() == 0.0) {
            r = hsl.getL();
            g = hsl.getL();
            b = hsl.getL();
        } else {
            double temp2 = hsl.getL() <= 0.5 ? hsl.getL() * (1.0 + hsl.getS()) : hsl.getL() + hsl.getS() - hsl.getL() * hsl.getS();
            double temp1 = 2.0 * hsl.getL() - temp2;
            double[] t3 = new double[]{hsl.getH() + 0.3333333333333333, hsl.getH(), hsl.getH() - 0.3333333333333333};
            double[] clr = new double[]{0.0, 0.0, 0.0};
            for (int i = 0; i < 3; ++i) {
                if (t3[i] < 0.0) {
                    int n = i;
                    t3[n] = t3[n] + 1.0;
                }
                if (t3[i] > 1.0) {
                    int n = i;
                    t3[n] = t3[n] - 1.0;
                }
                clr[i] = 6.0 * t3[i] < 1.0 ? temp1 + (temp2 - temp1) * t3[i] * 6.0 : (2.0 * t3[i] < 1.0 ? temp2 : (3.0 * t3[i] < 2.0 ? temp1 + (temp2 - temp1) * (0.6666666666666666 - t3[i]) * 6.0 : temp1));
            }
            r = clr[0];
            g = clr[1];
            b = clr[2];
        }
        return new VisuRGBA((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b));
    }

    private static HSL rgb2hsl(VisuRGBA c) {
        HSL hsl = new HSL();
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        double h = 0.0;
        double s = 0.0;
        double l = 0.0;
        double v = Math.max(r, g);
        v = Math.max(v, b);
        double m = Math.min(r, g);
        l = ((m = Math.min(m, b)) + v) / 2.0;
        if (l <= 0.0) {
            hsl.setH(h);
            hsl.setS(s);
            hsl.setL(l);
            return hsl;
        }
        double vm = v - m;
        s = vm;
        if (s > 0.0) {
            s /= l <= 0.5 ? v + m : 2.0 - v - m;
        } else {
            hsl.setH(h);
            hsl.setS(s);
            hsl.setL(l);
            return hsl;
        }
        double r2 = (v - r) / vm;
        double g2 = (v - g) / vm;
        double b2 = (v - b) / vm;
        h = r == v ? (g == m ? 5.0 + b2 : 1.0 - g2) : (g == v ? (b == m ? 1.0 + r2 : 3.0 - b2) : (r == m ? 3.0 + g2 : 5.0 - r2));
        hsl.setH(h /= 6.0);
        hsl.setS(s);
        hsl.setL(l);
        return hsl;
    }
}

