/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorType;
import com.businessobjects.visualization.graphic.VisuGradient;
import com.businessobjects.visualization.graphic.VisuRGBA;

public class ColorZone {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$ColorZone == null ? (class$com$businessobjects$visualization$graphic$ColorZone = ColorZone.class$("com.businessobjects.visualization.graphic.ColorZone")) : class$com$businessobjects$visualization$graphic$ColorZone));
    private static final int GRADIENT_ITEM_COUNT = 256;
    private static final int GRADIENT_ITEM_MAX = 255;
    private VisuColor objVisuColor_;
    private int[] gradientTable_;
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$ColorZone;

    public ColorZone(VisuColor objVisuColor) {
        this.objVisuColor_ = objVisuColor;
        if (this.objVisuColor_.getColorType() == VisuColorType.GRADIENT) {
            VisuGradient objVisuGradient = (VisuGradient)this.objVisuColor_.getValue();
            this.makeGradientTable(objVisuGradient.getColors()[0].intValue(), objVisuGradient.getColors()[1].intValue());
        } else if (this.objVisuColor_.getColorType() != VisuColorType.RGBA) {
            throw new VisualizationInternalException("ColorZone: only colors of type VisuColorType.RGBA or VisuColorType.GRADIENT are supported.");
        }
    }

    public VisuRGBA getColor(double dValue) {
        if (this.objVisuColor_.getColorType() == VisuColorType.RGBA) {
            return (VisuRGBA)this.objVisuColor_.getValue();
        }
        if (this.objVisuColor_.getColorType() == VisuColorType.GRADIENT) {
            return new VisuRGBA(this.gradientTable_[(int)(255.0 * dValue)]);
        }
        throw new NotImplementedException();
    }

    public VisuColor getMinColor() {
        if (this.objVisuColor_.getColorType() == VisuColorType.RGBA) {
            return this.objVisuColor_;
        }
        if (this.objVisuColor_.getColorType() == VisuColorType.GRADIENT) {
            return new VisuColor(this.gradientTable_[0]);
        }
        throw new NotImplementedException();
    }

    public VisuColor getMaxColor() {
        if (this.objVisuColor_.getColorType() == VisuColorType.RGBA) {
            return this.objVisuColor_;
        }
        if (this.objVisuColor_.getColorType() == VisuColorType.GRADIENT) {
            return new VisuColor(this.gradientTable_[255]);
        }
        throw new NotImplementedException();
    }

    public VisuColor getColor() {
        return this.objVisuColor_;
    }

    public VisuColorType getVisuColorType() {
        return this.objVisuColor_.getColorType();
    }

    public static boolean isInRange(double dValue, double dLowerBound, double dUpperBound, boolean bUpperBoundIsInclusive) {
        return dValue >= dLowerBound && (!bUpperBoundIsInclusive && dValue < dUpperBound || bUpperBoundIsInclusive && dValue <= dUpperBound);
    }

    public static double getProportion(double dValue, double dLowerBound, double dUpperBound) {
        return (dValue - dLowerBound) / (dUpperBound - dLowerBound);
    }

    public static int getLinear(double dFactor, int iValueFrom, int iValueTo) {
        return (int)((double)iValueFrom + (double)(iValueTo - iValueFrom) * dFactor + 0.49);
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 0.0;
    }

    void trace() {
        StringBuffer objStringBuffer = new StringBuffer();
        objStringBuffer.append("Colorzone: ").append(this.objVisuColor_);
        LOGGER.info((Object)objStringBuffer.toString());
    }

    private void makeGradientTable(int iStartRGBA, int iEndRGBA) {
        int iFromA = iStartRGBA >> 24 & 0xFF;
        int iFromR = iStartRGBA >> 16 & 0xFF;
        int iFromG = iStartRGBA >> 8 & 0xFF;
        int iFromB = iStartRGBA & 0xFF;
        int iToA = iEndRGBA >> 24 & 0xFF;
        int iToR = iEndRGBA >> 16 & 0xFF;
        int iToG = iEndRGBA >> 8 & 0xFF;
        int iToB = iEndRGBA & 0xFF;
        this.gradientTable_ = new int[256];
        for (int iGradientItemIndex = 0; iGradientItemIndex < 256; ++iGradientItemIndex) {
            double dFactor = ColorZone.getProportion(iGradientItemIndex, 0.0, 255.0);
            int iA = ColorZone.getLinear(dFactor, iFromA, iToA);
            int iR = ColorZone.getLinear(dFactor, iFromR, iToR);
            int iG = ColorZone.getLinear(dFactor, iFromG, iToG);
            int iB = ColorZone.getLinear(dFactor, iFromB, iToB);
            this.gradientTable_[iGradientItemIndex] = iA << 24 | iR << 16 | iG << 8 | iB;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

