/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.dataexchange.common.DimensionType;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import com.businessobjects.visualization.feed.DataFeed;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.feed.FeedStrategyOption;
import com.businessobjects.visualization.feed.FeedStructureHelper;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.FeedDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

abstract class FeedStrategy {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$feed$FeedStrategy == null ? (class$com$businessobjects$visualization$feed$FeedStrategy = FeedStrategy.class$("com.businessobjects.visualization.feed.FeedStrategy")) : class$com$businessobjects$visualization$feed$FeedStrategy));
    private FeedStrategy nextStrategy_;
    static /* synthetic */ Class class$com$businessobjects$visualization$feed$FeedStrategy;

    protected FeedStrategy(FeedStrategy aNextStrategy) {
        this.nextStrategy_ = aNextStrategy;
    }

    protected abstract void feed(DataFeed var1, ArrayList var2, DatasetDescriptor var3);

    protected boolean checkFeedType(FeedDef currentDef, DataContainer currentDC) {
        return currentDef.accepts(DataContainerType.DIMENSIONSHIERARCHY) && currentDC instanceof DimensionLabels || currentDef.accepts(DataContainerType.MEASUREVALUES) && currentDC instanceof MeasureValues;
    }

    protected boolean checkDimensionType(FeedDef currentDef, DataContainer currentDC) {
        if (!(currentDC instanceof DimensionLabels)) {
            return true;
        }
        return currentDef.accepts(((DimensionLabels)currentDC).getDimensionType());
    }

    protected FeedStrategy getNextStrategy() {
        return this.nextStrategy_;
    }

    private static int getAllMeasuresCount(DatasetDescriptor dd, int structureIndex) {
        MeasureValuesGroup[] mvgList = dd.getValueGroupList();
        if (mvgList.length == 0) {
            return 0;
        }
        int count = 0;
        if (structureIndex != -1) {
            if (structureIndex < mvgList.length) {
                return mvgList[structureIndex].getMeasureValuesList().length;
            }
            return 0;
        }
        for (int i = 0; i < mvgList.length; ++i) {
            count += mvgList[i].getMeasureValuesList().length;
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FeedMeasureNames
    extends FeedStrategy {
        public FeedMeasureNames(FeedStrategy nextStrategy) {
            super(nextStrategy);
        }

        protected void feed(DataFeed dataFeed, ArrayList dataContainerList, DatasetDescriptor dataset) {
            FeedDef[] fullFeedDefList = dataFeed.getDataFeedDef().getFullFeedDefList(true);
            int dcCount = dataContainerList.size();
            LOGGER.debug((Object)("starting FeedMeasureNames with dcCount:" + dcCount));
            for (int i = 0; i < fullFeedDefList.length; ++i) {
                if (!fullFeedDefList[i].accepts(DataContainerType.MEASURENAMESDIMENSION) || !dataFeed.getFeedStructureHelper().isValidStructure(dataset, DimensionLabels.MEASURENAMES_DIMENSION, fullFeedDefList[i]) || FeedStrategy.getAllMeasuresCount(dataset, dataFeed.getFeedStructureHelper().getFeedStructureIndexFromId(fullFeedDefList[i].getStructureId(DataContainerType.MEASURENAMESDIMENSION))) <= 1) continue;
                int nFeedCount = dataFeed.findByDefId(fullFeedDefList[i].getId()).length;
                if (dataFeed.getMediator().getMinOccurence(fullFeedDefList[i]) <= nFeedCount) continue;
                dataFeed.attach(fullFeedDefList[i].getId(), DimensionLabels.MEASURENAMES_DIMENSION);
                LOGGER.info((Object)("attached MeasureNames on : " + fullFeedDefList[i]));
                return;
            }
        }
    }

    static class FeedAdder
    extends FeedStrategy {
        private final FeedStrategyOption option_;
        private boolean bIgnoreDataStructure_;

        public FeedAdder(FeedStrategyOption option, FeedStrategy aNextStrategy) {
            super(aNextStrategy);
            this.option_ = option;
            this.bIgnoreDataStructure_ = this.option_.ignoreStructure();
        }

        private boolean isTypedDataset(DatasetDescriptor dataset) {
            AnalysisAxis[] axesList = dataset.getAxisList();
            for (int i = 0; i < axesList.length; ++i) {
                DimensionLabels[] dlList = axesList[i].getDimensionLabelsList();
                for (int j = 0; j < dlList.length; ++j) {
                    if (dlList[j].getDimensionType().equals(DimensionType.STANDARD)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void feed(DataFeed dataFeed, ArrayList dataContainerList, DatasetDescriptor dataset) {
            FeedDef[] fullFeedDefList = dataFeed.getDataFeedDef().getFullFeedDefList(true);
            int dcCount = dataContainerList.size();
            if (dcCount == 0) {
                return;
            }
            LOGGER.debug((Object)("starting FeedAdder with option:" + this.option_.toString() + " with dcCount:" + dcCount));
            boolean isTypedDataset = this.isTypedDataset(dataset);
            FeedStructureHelper feedStructHelper = dataFeed.getFeedStructureHelper();
            for (int i = 0; i < fullFeedDefList.length; ++i) {
                DataContainer currentDC;
                if (fullFeedDefList[i].isOptional() && this.option_.isMandatoryOnly() || !fullFeedDefList[i].isOptional() && this.option_.isOptionalOnly()) continue;
                boolean bFeedDefFullFilled = false;
                LinkedList<DataContainer> orderedDCList = new LinkedList<DataContainer>();
                for (int j = dataContainerList.size() - 1; j > -1; --j) {
                    currentDC = (DataContainer)dataContainerList.get(j);
                    if (feedStructHelper.isMatchingStructure(dataset, currentDC, fullFeedDefList[i])) {
                        orderedDCList.addFirst(currentDC);
                        continue;
                    }
                    orderedDCList.add(currentDC);
                }
                Iterator iterDC = orderedDCList.iterator();
                while (iterDC.hasNext() && !bFeedDefFullFilled) {
                    Feed aFeed;
                    currentDC = (DataContainer)iterDC.next();
                    if (!this.checkFeedType(fullFeedDefList[i], currentDC) || isTypedDataset && !this.option_.ignoreDimensionTypes() && !this.checkDimensionType(fullFeedDefList[i], currentDC)) continue;
                    boolean bIsValidStructure = feedStructHelper.isValidStructure(dataset, currentDC, fullFeedDefList[i]);
                    if ((!this.bIgnoreDataStructure_ || currentDC instanceof DimensionLabels) && !bIsValidStructure) continue;
                    int nFeedCount = dataFeed.findByDefId(fullFeedDefList[i].getId()).length;
                    if (!dataFeed.getMediator().checkRestrictions(nFeedCount + 1, fullFeedDefList[i].getId()) || !(aFeed = new Feed(dataFeed.getMediator(), fullFeedDefList[i])).accepts(currentDC)) continue;
                    aFeed.addDataContainer(currentDC);
                    if (!dataFeed.accepts(aFeed)) continue;
                    dataFeed.addFeed(aFeed);
                    feedStructHelper.markStructure(dataset, currentDC, fullFeedDefList[i]);
                    bFeedDefFullFilled = true;
                    iterDC.remove();
                    dataContainerList.remove(currentDC);
                    --dcCount;
                    if (dataFeed.getMediator() == null) continue;
                    dataFeed.getMediator().notifyFeedAdded(aFeed);
                }
            }
            FeedFiller implicitStrategies = new FeedFiller(new FeedMultiplier(null));
            ((FeedStrategy)implicitStrategies).feed(dataFeed, dataContainerList, dataset);
            if (this.getNextStrategy() != null) {
                this.getNextStrategy().feed(dataFeed, dataContainerList, dataset);
            } else if (dcCount > 0) {
                LOGGER.warn((Object)("No more strategy to feed, but DataContainers remaining : " + dcCount));
            }
        }
    }

    static class FeedFiller
    extends FeedStrategy {
        public FeedFiller(FeedStrategy aNextStrategy) {
            super(aNextStrategy);
        }

        protected void feed(DataFeed dataFeed, ArrayList dataContainerList, DatasetDescriptor dataset) {
            int dcCount = dataContainerList.size();
            if (dcCount == 0) {
                return;
            }
            LOGGER.debug((Object)("starting FeedFiller with dcCount:" + dcCount));
            Feed[] fullFeedList = dataFeed.getFullFeedList(true);
            for (int i = 0; i < fullFeedList.length; ++i) {
                Iterator iterDC = dataContainerList.iterator();
                while (iterDC.hasNext()) {
                    DataContainer dc = (DataContainer)iterDC.next();
                    if (!fullFeedList[i].accepts(dc) || !dataFeed.getFeedStructureHelper().isValidStructure(dataset, dc, fullFeedList[i].getFeedDef())) continue;
                    fullFeedList[i].addDataContainer(dc);
                    iterDC.remove();
                    --dcCount;
                }
            }
            if (this.getNextStrategy() != null) {
                this.getNextStrategy().feed(dataFeed, dataContainerList, dataset);
            }
        }
    }

    static class FeedMultiplier
    extends FeedStrategy {
        public FeedMultiplier(FeedStrategy aNextStrategy) {
            super(aNextStrategy);
        }

        protected void feed(DataFeed dataFeed, ArrayList dataContainerList, DatasetDescriptor dataset) {
            int dcCount = dataContainerList.size();
            if (dcCount == 0) {
                return;
            }
            LOGGER.debug((Object)("starting FeedMultiplier with dcCount:" + dcCount));
            Feed[] fullFeedList = dataFeed.getFullFeedList(true);
            for (int i = 0; i < fullFeedList.length; ++i) {
                FeedDef def = fullFeedList[i].getFeedDef();
                Iterator iterDC = dataContainerList.iterator();
                while (iterDC.hasNext()) {
                    Feed aFeed;
                    DataContainer dc = (DataContainer)iterDC.next();
                    if (!this.checkFeedType(def, dc) || !this.checkDimensionType(def, dc) || !dataFeed.getFeedStructureHelper().isValidStructure(dataset, dc, fullFeedList[i].getFeedDef())) continue;
                    int nFeedCount = dataFeed.findByDefId(def.getId()).length;
                    if (!dataFeed.getMediator().checkRestrictions(nFeedCount + 1, def.getId()) || !(aFeed = new Feed(dataFeed.getMediator(), def)).accepts(dc)) continue;
                    aFeed.addDataContainer(dc);
                    if (!dataFeed.accepts(aFeed)) continue;
                    dataFeed.addFeed(aFeed);
                    iterDC.remove();
                    --dcCount;
                    if (dataFeed.getMediator() == null) continue;
                    dataFeed.getMediator().notifyFeedAdded(aFeed);
                }
            }
            if (this.getNextStrategy() != null) {
                this.getNextStrategy().feed(dataFeed, dataContainerList, dataset);
            }
        }
    }
}

