/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.graph.impl;

import com.businessobjects.visualization.dataexchange.data.graph.IAxisTree;
import com.businessobjects.visualization.dataexchange.data.graph.INode;
import com.businessobjects.visualization.dataexchange.data.graph.impl.AxisGraphImpl;
import com.businessobjects.visualization.dataexchange.data.graph.impl.NodeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class AxisTreeImpl
extends AxisGraphImpl
implements IAxisTree {
    private NodeImpl rootNode_;
    private HashMap parentMap_;

    public AxisTreeImpl(ArrayList nodeList, int maxNodesSize, NodeImpl rootNode) {
        super(nodeList, maxNodesSize, true, true, true);
        if (rootNode == null) {
            throw new IllegalArgumentException("Need a non-null root for this tree");
        }
        this.rootNode_ = rootNode;
        this.parentMap_ = new HashMap();
        this.bIsDiGraph_ = true;
        this.bIsTree_ = true;
    }

    public void insertEdge(NodeImpl parentNode, NodeImpl childNode) {
        this.insertEdge(parentNode, childNode, true, "", null, 0);
        this.parentMap_.put(childNode, parentNode);
    }

    public Iterator getChildsIterator(INode parentNode) {
        return this.iterBoundNodes(parentNode);
    }

    public INode getParent(INode node) {
        return (INode)this.parentMap_.get(node);
    }

    public INode getRootNode() {
        return this.rootNode_;
    }

    public boolean isLeaf(INode node) {
        return this.getChildrenCount(node) == 0;
    }

    public int getChildrenCount(INode node) {
        return this.getEdgesCount(node);
    }

    public Iterator getBFSIterator(final INode node) {
        this.checkValidNodeFromGraph(node);
        return new Iterator(){
            private SimpleQueue queue_;
            private int currentIndex_;
            private AxisGraphImpl.AdjNode currentAdjNode_;
            {
                this.queue_ = new SimpleQueue();
                this.currentIndex_ = ((NodeImpl)node).internalIndex_;
                this.currentAdjNode_ = AxisTreeImpl.this.adj_[((NodeImpl)node).internalIndex_];
            }

            public boolean hasNext() {
                return this.currentIndex_ >= 0;
            }

            public Object next() {
                if (this.currentIndex_ == -1) {
                    return null;
                }
                INode retNode = (INode)AxisTreeImpl.this.nodeList_.get(this.currentIndex_);
                if (this.currentAdjNode_ != null) {
                    this.currentIndex_ = this.currentAdjNode_.v_;
                    this.currentAdjNode_ = this.currentAdjNode_.next_;
                } else {
                    if (!this.queue_.empty()) {
                        int lastDequeue = this.queue_.dequeue();
                        this.currentIndex_ = AxisTreeImpl.this.adj_[lastDequeue].v_;
                        this.currentAdjNode_ = AxisTreeImpl.this.adj_[lastDequeue].next_;
                    }
                    if (this.queue_.empty() && this.currentAdjNode_ == null) {
                        this.currentIndex_ = -1;
                    }
                }
                if (this.currentIndex_ != -1 && AxisTreeImpl.this.adj_[this.currentIndex_] != null) {
                    this.queue_.enqueue(this.currentIndex_);
                }
                return retNode;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getDFSIterator(final INode node) {
        this.checkValidNodeFromGraph(node);
        return new Iterator(){
            private Stack stack_ = new Stack();
            private int currentIndex_;
            private AxisGraphImpl.AdjNode currentAdjNode_;
            {
                this.currentIndex_ = ((NodeImpl)node).internalIndex_;
                this.currentAdjNode_ = AxisTreeImpl.this.adj_[((NodeImpl)node).internalIndex_];
            }

            public boolean hasNext() {
                return this.currentIndex_ >= 0;
            }

            public Object next() {
                if (this.currentIndex_ == -1) {
                    return null;
                }
                INode retNode = (INode)AxisTreeImpl.this.nodeList_.get(this.currentIndex_);
                if (this.currentIndex_ != -1 && this.currentAdjNode_ != null) {
                    AxisGraphImpl.AdjNode tmpNode = this.currentAdjNode_.next_;
                    while (tmpNode != null) {
                        this.stack_.push(new Integer(tmpNode.v_));
                        tmpNode = tmpNode.next_;
                    }
                }
                if (this.currentAdjNode_ != null) {
                    this.currentIndex_ = this.currentAdjNode_.v_;
                    this.currentAdjNode_ = AxisTreeImpl.this.adj_[this.currentIndex_];
                } else if (this.stack_.empty() && this.currentAdjNode_ == null) {
                    this.currentIndex_ = -1;
                } else if (!this.stack_.empty()) {
                    int lastDequeue;
                    this.currentIndex_ = lastDequeue = ((Integer)this.stack_.pop()).intValue();
                    this.currentAdjNode_ = AxisTreeImpl.this.adj_[lastDequeue];
                }
                return retNode;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getLevel(INode node) {
        this.checkValidNodeFromGraph(node);
        INode parNode = this.getParent(node);
        if (parNode != null) {
            return this.getLevel(parNode) + 1;
        }
        return 0;
    }

    public Iterator getLevelBasedIterator(final int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be 0 or positive, current:" + level);
        }
        return new Iterator(){
            private Iterator bfsIterator_;
            private INode nextNode_;
            private int targetLevel_;
            {
                this.bfsIterator_ = AxisTreeImpl.this.getBFSIterator(AxisTreeImpl.this.getRootNode());
                this.nextNode_ = this.bfsIterator_.hasNext() ? (INode)this.bfsIterator_.next() : null;
                this.targetLevel_ = level;
            }

            public boolean hasNext() {
                return this.nextNode_ != null && AxisTreeImpl.this.getLevel(this.nextNode_) <= this.targetLevel_;
            }

            public Object next() {
                INode current = this.nextNode_;
                while (AxisTreeImpl.this.getLevel(current) < this.targetLevel_ && this.bfsIterator_.hasNext()) {
                    current = (INode)this.bfsIterator_.next();
                }
                this.nextNode_ = this.bfsIterator_.hasNext() ? (INode)this.bfsIterator_.next() : null;
                return current;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final class SimpleQueue {
        private LinkedList items_ = new LinkedList();

        private SimpleQueue() {
        }

        public int enqueue(int element) {
            if (element < 0) {
                throw new IllegalArgumentException(element + " only positive int allowed for this queue");
            }
            this.items_.add(new Integer(element));
            return element;
        }

        public int dequeue() {
            if (this.items_.size() == 0) {
                return -1;
            }
            return (Integer)this.items_.removeFirst();
        }

        public int front() {
            if (this.items_.size() == 0) {
                return -1;
            }
            return (Integer)this.items_.getFirst();
        }

        public int size() {
            return this.items_.size();
        }

        public boolean empty() {
            return this.size() == 0;
        }

        public void clear() {
            this.items_.clear();
        }
    }
}

