/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.graph.impl;

import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.dataexchange.data.graph.IAxisGraph;
import com.businessobjects.visualization.dataexchange.data.graph.IEdge;
import com.businessobjects.visualization.dataexchange.data.graph.INode;
import com.businessobjects.visualization.dataexchange.data.graph.impl.EdgeImpl;
import com.businessobjects.visualization.dataexchange.data.graph.impl.NodeImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class AxisGraphImpl
implements IAxisGraph {
    protected ArrayList nodeList_;
    protected AdjNode[] adj_;
    private HashSet edges_;
    protected boolean bIsDiGraph_;
    protected boolean bIsTree_;
    protected boolean bKeepOrdered_ = true;
    static final String NEWLINE = System.getProperty("line.separator");

    public AxisGraphImpl(ArrayList nodeList, int maxNodesSize, boolean bIsDiGraph, boolean bIsTree, boolean bKeepInsertionOrder) {
        if (maxNodesSize < 0) {
            throw new IllegalArgumentException("maxNodesSize must be >= 0");
        }
        if (nodeList != null) {
            this.nodeList_ = new ArrayList(nodeList);
            int counter = 0;
            try {
                Iterator iter = nodeList.iterator();
                while (iter.hasNext()) {
                    ((NodeImpl)iter.next()).internalIndex_ = counter++;
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("ClassCast Exception, nodeList param must only have NodeImpl elements, currently:" + e.getMessage());
            }
            this.adj_ = new AdjNode[this.nodeList_.size()];
        } else {
            this.nodeList_ = new ArrayList();
            this.adj_ = new AdjNode[maxNodesSize];
        }
        this.edges_ = new HashSet();
        this.bIsDiGraph_ = bIsDiGraph;
    }

    public void insert(EdgeImpl e) {
        this.checkValidEdge(e);
        if (!this.bKeepOrdered_) {
            this.adj_[e.srcIndex_] = new AdjNode(e.destlIndex_, this.adj_[e.srcIndex_], e);
            if (!this.bIsDiGraph_) {
                this.adj_[e.destlIndex_] = new AdjNode(e.srcIndex_, this.adj_[e.destlIndex_], e);
            }
        } else {
            this.addAdjToEnd(e, e.srcIndex_, e.destlIndex_);
            if (!this.bIsDiGraph_) {
                this.addAdjToEnd(e, e.destlIndex_, e.srcIndex_);
            }
        }
        this.edges_.add(e);
    }

    private void addAdjToEnd(EdgeImpl e, int src, int dest) {
        AdjNode adj = this.adj_[src];
        if (adj == null) {
            this.adj_[src] = new AdjNode(dest, null, e);
        } else {
            while (adj.next_ != null) {
                adj = adj.next_;
            }
            adj.next_ = new AdjNode(dest, null, e);
        }
    }

    public void insertEdge(NodeImpl src, NodeImpl dest, boolean bisParentChild, String name, Properties edgeProperties, int relationIndex) {
        this.checkValidNode(src);
        this.checkValidNode(dest);
        if (src.internalIndex_ == -1) {
            src.internalIndex_ = this.nodeList_.size();
            this.nodeList_.add(src);
        } else {
            this.checkValidNodeFromGraph(src);
        }
        if (dest.internalIndex_ == -1) {
            dest.internalIndex_ = this.nodeList_.size();
            this.nodeList_.add(dest);
        } else {
            this.checkValidNodeFromGraph(dest);
        }
        if (this.nodeList_.size() > this.adj_.length) {
            this.resizeAdjArray();
        }
        EdgeImpl edge = new EdgeImpl(src.internalIndex_, dest.internalIndex_, relationIndex, bisParentChild, name, edgeProperties);
        this.insert(edge);
    }

    private void resizeAdjArray() {
        AdjNode[] newData = new AdjNode[this.adj_.length * 2];
        System.arraycopy(this.adj_, 0, newData, 0, this.adj_.length);
        this.adj_ = newData;
    }

    public int getEdgesCount() {
        return this.edges_.size();
    }

    public int getNodesCount() {
        return this.nodeList_.size();
    }

    public Iterator iterAllEdges() {
        return this.edges_.iterator();
    }

    public Iterator iterEdges(final INode node) {
        this.checkValidNodeFromGraph(node);
        return new Iterator(){
            private AdjNode currentNode_;
            {
                this.currentNode_ = AxisGraphImpl.this.adj_[((NodeImpl)node).internalIndex_];
            }

            public boolean hasNext() {
                return this.currentNode_ != null && this.currentNode_.edge_ != null;
            }

            public Object next() {
                if (this.currentNode_ == null) {
                    return null;
                }
                EdgeImpl retEdge = this.currentNode_.edge_;
                this.currentNode_ = this.currentNode_.next_;
                return retEdge;
            }

            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    public Iterator iterBoundNodes(final INode node) {
        this.checkValidNodeFromGraph(node);
        return new Iterator(){
            private AdjNode currentNode_;
            {
                this.currentNode_ = AxisGraphImpl.this.adj_[((NodeImpl)node).internalIndex_];
            }

            public boolean hasNext() {
                return this.currentNode_ != null && this.currentNode_.edge_ != null;
            }

            public Object next() {
                if (this.currentNode_ == null) {
                    return null;
                }
                INode retNode = (INode)AxisGraphImpl.this.nodeList_.get(this.currentNode_.v_);
                this.currentNode_ = this.currentNode_.next_;
                return retNode;
            }

            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    public Iterator iterAllNodes() {
        return this.nodeList_.iterator();
    }

    public INode getBoundNode(IEdge edge, INode srcNode) {
        NodeImpl nodeImpl = this.checkValidNodeFromGraph(srcNode);
        EdgeImpl edgeImpl = this.checkValidEdge(edge);
        if (((EdgeImpl)edge).destlIndex_ == nodeImpl.internalIndex_) {
            return (INode)this.nodeList_.get(edgeImpl.srcIndex_);
        }
        return (INode)this.nodeList_.get(edgeImpl.destlIndex_);
    }

    public boolean isDirected() {
        return this.bIsDiGraph_;
    }

    public boolean isTree() {
        return this.bIsTree_;
    }

    public String toDotFormat() {
        StringBuffer sb = new StringBuffer();
        if (this.bIsDiGraph_) {
            sb.append("digraph G {").append(NEWLINE);
        } else {
            sb.append("graph G {").append(NEWLINE);
        }
        Iterator iter = this.nodeList_.iterator();
        while (iter.hasNext()) {
            NodeImpl node = (NodeImpl)iter.next();
            Iterator edgeIter = this.iterEdges(node);
            while (edgeIter.hasNext()) {
                EdgeImpl edge = (EdgeImpl)edgeIter.next();
                NodeImpl toNode = (NodeImpl)this.getBoundNode(edge, node);
                sb.append("\"" + node.getValue() + " (" + node.getAbsoluteIndex() + "," + node.hashCode() + ") " + "\"" + " -" + (this.bIsDiGraph_ ? ">" : "-") + " ");
                sb.append("\"" + toNode.getValue() + " (" + toNode.getAbsoluteIndex() + "," + toNode.hashCode() + ") " + "\"" + " ");
                sb.append(";").append(NEWLINE);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    protected boolean isValidIndex(int index) {
        return index >= 0 && index < this.adj_.length;
    }

    protected NodeImpl checkValidNode(INode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        if (!(node instanceof NodeImpl)) {
            throw new IllegalArgumentException("Node must be of type NodeImpl");
        }
        NodeImpl n = (NodeImpl)node;
        if (n.internalIndex_ >= this.adj_.length) {
            throw new IllegalArgumentException("Bad Index for node:" + n.internalIndex_);
        }
        return (NodeImpl)node;
    }

    protected NodeImpl checkValidNodeFromGraph(INode node) {
        NodeImpl n = this.checkValidNode(node);
        if (!this.isValidIndex(n.internalIndex_)) {
            throw new IllegalArgumentException("Node must be part of the current graph");
        }
        return n;
    }

    protected EdgeImpl checkValidEdge(IEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Cannot pass null edge");
        }
        if (!(edge instanceof EdgeImpl)) {
            throw new IllegalArgumentException("need an edge of type EdgeImpl");
        }
        EdgeImpl e = (EdgeImpl)edge;
        if (!this.isValidIndex(e.srcIndex_) || !this.isValidIndex(e.destlIndex_)) {
            throw new IllegalArgumentException("Edge needs to have valid indexes to the nodeList indexes");
        }
        return e;
    }

    public boolean areBoundNodes(INode srcNode, INode dstNode) {
        int srcIndex = this.checkValidNode((INode)srcNode).internalIndex_;
        int dstIndex = this.checkValidNode((INode)dstNode).internalIndex_;
        if (srcIndex == -1 || dstIndex == -1) {
            return false;
        }
        AdjNode currAdjNode = this.adj_[srcIndex];
        while (currAdjNode != null && currAdjNode.v_ != dstIndex) {
            currAdjNode = currAdjNode.next_;
        }
        return currAdjNode != null;
    }

    public int getEdgesCount(INode node) {
        NodeImpl nodeImpl = this.checkValidNodeFromGraph(node);
        AdjNode currentNode = this.adj_[nodeImpl.internalIndex_];
        int count = 0;
        while (currentNode != null) {
            ++count;
            currentNode = currentNode.next_;
        }
        return count;
    }

    class AdjNode {
        int v_;
        AdjNode next_;
        EdgeImpl edge_;

        AdjNode(int v, AdjNode next, EdgeImpl edge) {
            this.v_ = v;
            this.next_ = next;
            this.edge_ = edge;
        }
    }
}

