/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.data.ClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DataContainerAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLMeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;
import com.businessobjects.visualization.dataexchange.data.impl.MeasureValuesGridImpl;

public class MeasureValuesAdapter
extends DataContainerAdapter {
    private MeasureValuesGroupAdapter group_;
    private IValuesGrid grid_;
    private boolean isCustomGridImpl_;

    public MeasureValuesAdapter(ClientInfoAdapter cia, String uid, String defaultTitle) {
        this.clientInfoAdapter_ = cia;
        this.serialId_ = uid;
        this.title_ = defaultTitle;
    }

    public MeasureValuesAdapter(XMLMeasureValuesAdapter xmlMv, SerializationHelper sh) {
        super.fromXMLDelegate(xmlMv, sh);
        if (xmlMv.m_values != null) {
            if (xmlMv.m_values.m_dataStructure != null && xmlMv.m_values.m_dataStructure.value() == 1) {
                throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", "Invalid dataStructure for MeasureValues:" + xmlMv.m_values.m_dataStructure);
            }
            switch (xmlMv.m_values.m_dataType.value()) {
                case 1: {
                    this.data_ = new DoubleValueData(xmlMv.m_values, sh);
                    break;
                }
                default: {
                    throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", "Unknown values datatype:" + xmlMv.m_values.m_dataType);
                }
            }
        }
    }

    public void setGroup(MeasureValuesGroupAdapter group) {
        this.group_ = group;
    }

    public MeasureValuesGroupAdapter getGroup() {
        return this.group_;
    }

    public Object getXMLDelegate() {
        XMLMeasureValuesAdapter mv = new XMLMeasureValuesAdapter();
        super.toXMLDelegate(mv);
        return mv;
    }

    public void setData(Data data) {
        super.setData(data);
        this.grid_ = null;
    }

    public IValuesGrid getGridCallback() {
        if (this.grid_ == null) {
            if (this.data_ == null) {
                throw new VisualizationRuntimeException("VIZ_00028_ERR_CANNOT_RETURN_IVALUE");
            }
            this.grid_ = new MeasureValuesGridImpl((DoubleValueData)this.data_);
        }
        return this.grid_;
    }

    public void setGridCallback(IValuesGrid aCallback) {
        this.grid_ = aCallback;
        this.isCustomGridImpl_ = true;
    }

    public boolean isCustomGridImpl() {
        return this.isCustomGridImpl_;
    }
}

