/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsSimpleIterator;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import java.util.ArrayList;

public class MeasureNamesDimensionAdapter
extends DimensionLabelsAdapter {
    private DataHolder dataHolder_;
    public static final String DEFAULT_TITLE = "All Measures";

    public MeasureNamesDimensionAdapter(DataHolder dataHolder) {
        super(null, "mndUID", DEFAULT_TITLE);
        this.dataHolder_ = dataHolder;
    }

    public void setData(Data data) {
        throw new VisualizationInternalException("Cannot set any data on the MeasureNamesDimension object, it is generated internally");
    }

    public Data getData() {
        if (this.data_ != null) {
            return this.data_;
        }
        ArrayList<String> values = new ArrayList<String>();
        MeasureValuesGroupAdapter[] mvgList = this.dataHolder_.getDataAdapter().getDataset().getValueGroupList();
        for (int i = 0; i < mvgList.length; ++i) {
            MeasureValuesAdapter[] mv = mvgList[i].getMeasureValuesList();
            for (int j = 0; j < mv.length; ++j) {
                values.add(mv[j].getTitle());
            }
        }
        this.data_ = new StringLabelData(values.toArray(new String[0]));
        return this.data_;
    }

    public IDimensionLabelsIterator getLabelIterator(DataRange dataRange) {
        if (dataRange != null && !dataRange.equals(DataRange.FULL_RANGE)) {
            return new DimensionLabelsSimpleIterator(this.getData(), dataRange.getLower(), dataRange.getUpper() - dataRange.getLower() + 1, DataType.STRING, -1, -1);
        }
        return new DimensionLabelsSimpleIterator(this.getData(), DataType.STRING, -1, -1);
    }
}

