/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.dataexchange.GraphicContextCalculation;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import java.util.ArrayList;

public class MeasureValuesContext {
    private double value_ = 1.7E308;
    private double maxvalue_ = 1.7E308;
    private boolean inclusive_;
    private MeasureValues measureValues_;
    private ArrayList gcCalcList_;

    public MeasureValuesContext(double val, double maxval, boolean inclusive, MeasureValues mes, GraphicContextCalculation[] calcValuesList) {
        this.value_ = val;
        this.maxvalue_ = maxval;
        this.measureValues_ = mes;
        this.inclusive_ = inclusive;
        if (calcValuesList != null) {
            for (int i = 0; i < calcValuesList.length; ++i) {
                this.addGCCalculation(calcValuesList[i]);
            }
        }
    }

    public MeasureValuesContext(double val, MeasureValues mes, GraphicContextCalculation[] calcValuesList) {
        this(val, 1.7E308, false, mes, calcValuesList);
    }

    private ArrayList getGCCalculationList() {
        if (this.gcCalcList_ == null) {
            this.gcCalcList_ = new ArrayList();
        }
        return this.gcCalcList_;
    }

    public MeasureValuesContext(MeasureValues measureValues) {
        this.measureValues_ = measureValues;
    }

    public void setValue(double value) {
        this.value_ = value;
    }

    public double getValue() {
        return this.value_;
    }

    public void setMaxValue(double value, boolean inclusive) {
        this.maxvalue_ = value;
        this.inclusive_ = inclusive;
    }

    public double getMaxValue() {
        return this.maxvalue_;
    }

    public boolean isRange() {
        return this.maxvalue_ != 1.7E308;
    }

    public boolean isInclusive() {
        return this.inclusive_;
    }

    public MeasureValues getMeasureValues() {
        return this.measureValues_;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof MeasureValuesContext)) {
            return false;
        }
        MeasureValuesContext mvc = (MeasureValuesContext)oThat;
        if (this.measureValues_ == null) {
            return mvc.measureValues_ == null;
        }
        return Double.doubleToLongBits(this.value_) == Double.doubleToLongBits(mvc.value_) && this.isRange() == mvc.isRange() && Double.doubleToLongBits(this.maxvalue_) == Double.doubleToLongBits(mvc.maxvalue_) && this.measureValues_.equals(mvc.measureValues_) && (this.gcCalcList_ == null ? mvc.gcCalcList_ == null : this.gcCalcList_.equals(mvc.gcCalcList_));
    }

    public boolean addGCCalculation(GraphicContextCalculation value) {
        return this.getGCCalculationList().add(value);
    }

    public boolean removeGCCalculation(GraphicContextCalculation value) {
        return this.getGCCalculationList().remove(value);
    }

    public GraphicContextCalculation[] getGCCalculations() {
        if (this.gcCalcList_ == null) {
            return new GraphicContextCalculation[0];
        }
        return this.gcCalcList_.toArray(new GraphicContextCalculation[0]);
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.value_);
        result = HashCodeHelper.hash(result, this.maxvalue_);
        result = HashCodeHelper.hash(result, this.measureValues_);
        result = HashCodeHelper.hash(result, this.gcCalcList_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MVFilter[");
        buffer.append("mv_ = ").append(this.measureValues_.getId());
        buffer.append(", value_ = ").append(this.value_);
        if (this.maxvalue_ != 1.7E308) {
            buffer.append(", maxvalue_ = ").append(this.maxvalue_);
        }
        if (this.gcCalcList_ != null) {
            buffer.append(", gcCalcList_= ").append(this.gcCalcList_);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

